// Code generated by go-swagger; DO NOT EDIT.

package firewall_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewCreateFirewallPoliciesParams creates a new CreateFirewallPoliciesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateFirewallPoliciesParams() *CreateFirewallPoliciesParams {
	return &CreateFirewallPoliciesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateFirewallPoliciesParamsWithTimeout creates a new CreateFirewallPoliciesParams object
// with the ability to set a timeout on a request.
func NewCreateFirewallPoliciesParamsWithTimeout(timeout time.Duration) *CreateFirewallPoliciesParams {
	return &CreateFirewallPoliciesParams{
		timeout: timeout,
	}
}

// NewCreateFirewallPoliciesParamsWithContext creates a new CreateFirewallPoliciesParams object
// with the ability to set a context for a request.
func NewCreateFirewallPoliciesParamsWithContext(ctx context.Context) *CreateFirewallPoliciesParams {
	return &CreateFirewallPoliciesParams{
		Context: ctx,
	}
}

// NewCreateFirewallPoliciesParamsWithHTTPClient creates a new CreateFirewallPoliciesParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateFirewallPoliciesParamsWithHTTPClient(client *http.Client) *CreateFirewallPoliciesParams {
	return &CreateFirewallPoliciesParams{
		HTTPClient: client,
	}
}

/*
CreateFirewallPoliciesParams contains all the parameters to send to the API endpoint

	for the create firewall policies operation.

	Typically these are written to a http.Request.
*/
type CreateFirewallPoliciesParams struct {

	// Body.
	Body *models.FirewallCreateFirewallPoliciesReqV1

	/* CloneID.

	   The policy ID to be cloned from
	*/
	CloneID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create firewall policies params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateFirewallPoliciesParams) WithDefaults() *CreateFirewallPoliciesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create firewall policies params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateFirewallPoliciesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create firewall policies params
func (o *CreateFirewallPoliciesParams) WithTimeout(timeout time.Duration) *CreateFirewallPoliciesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create firewall policies params
func (o *CreateFirewallPoliciesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create firewall policies params
func (o *CreateFirewallPoliciesParams) WithContext(ctx context.Context) *CreateFirewallPoliciesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create firewall policies params
func (o *CreateFirewallPoliciesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create firewall policies params
func (o *CreateFirewallPoliciesParams) WithHTTPClient(client *http.Client) *CreateFirewallPoliciesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create firewall policies params
func (o *CreateFirewallPoliciesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create firewall policies params
func (o *CreateFirewallPoliciesParams) WithBody(body *models.FirewallCreateFirewallPoliciesReqV1) *CreateFirewallPoliciesParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create firewall policies params
func (o *CreateFirewallPoliciesParams) SetBody(body *models.FirewallCreateFirewallPoliciesReqV1) {
	o.Body = body
}

// WithCloneID adds the cloneID to the create firewall policies params
func (o *CreateFirewallPoliciesParams) WithCloneID(cloneID *string) *CreateFirewallPoliciesParams {
	o.SetCloneID(cloneID)
	return o
}

// SetCloneID adds the cloneId to the create firewall policies params
func (o *CreateFirewallPoliciesParams) SetCloneID(cloneID *string) {
	o.CloneID = cloneID
}

// WriteToRequest writes these params to a swagger request
func (o *CreateFirewallPoliciesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.CloneID != nil {

		// query param clone_id
		var qrCloneID string

		if o.CloneID != nil {
			qrCloneID = *o.CloneID
		}
		qCloneID := qrCloneID
		if qCloneID != "" {

			if err := r.SetQueryParam("clone_id", qCloneID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
