// Code generated by go-swagger; DO NOT EDIT.

package firewall_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CreateFirewallPoliciesReader is a Reader for the CreateFirewallPolicies structure.
type CreateFirewallPoliciesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateFirewallPoliciesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewCreateFirewallPoliciesCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateFirewallPoliciesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateFirewallPoliciesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewCreateFirewallPoliciesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCreateFirewallPoliciesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateFirewallPoliciesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /policy/entities/firewall/v1] createFirewallPolicies", response, response.Code())
	}
}

// NewCreateFirewallPoliciesCreated creates a CreateFirewallPoliciesCreated with default headers values
func NewCreateFirewallPoliciesCreated() *CreateFirewallPoliciesCreated {
	return &CreateFirewallPoliciesCreated{}
}

/*
CreateFirewallPoliciesCreated describes a response with status code 201, with default header values.

Created
*/
type CreateFirewallPoliciesCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FirewallRespV1
}

// IsSuccess returns true when this create firewall policies created response has a 2xx status code
func (o *CreateFirewallPoliciesCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create firewall policies created response has a 3xx status code
func (o *CreateFirewallPoliciesCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create firewall policies created response has a 4xx status code
func (o *CreateFirewallPoliciesCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this create firewall policies created response has a 5xx status code
func (o *CreateFirewallPoliciesCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this create firewall policies created response a status code equal to that given
func (o *CreateFirewallPoliciesCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the create firewall policies created response
func (o *CreateFirewallPoliciesCreated) Code() int {
	return 201
}

func (o *CreateFirewallPoliciesCreated) Error() string {
	return fmt.Sprintf("[POST /policy/entities/firewall/v1][%d] createFirewallPoliciesCreated  %+v", 201, o.Payload)
}

func (o *CreateFirewallPoliciesCreated) String() string {
	return fmt.Sprintf("[POST /policy/entities/firewall/v1][%d] createFirewallPoliciesCreated  %+v", 201, o.Payload)
}

func (o *CreateFirewallPoliciesCreated) GetPayload() *models.FirewallRespV1 {
	return o.Payload
}

func (o *CreateFirewallPoliciesCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FirewallRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateFirewallPoliciesBadRequest creates a CreateFirewallPoliciesBadRequest with default headers values
func NewCreateFirewallPoliciesBadRequest() *CreateFirewallPoliciesBadRequest {
	return &CreateFirewallPoliciesBadRequest{}
}

/*
CreateFirewallPoliciesBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type CreateFirewallPoliciesBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FirewallRespV1
}

// IsSuccess returns true when this create firewall policies bad request response has a 2xx status code
func (o *CreateFirewallPoliciesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create firewall policies bad request response has a 3xx status code
func (o *CreateFirewallPoliciesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create firewall policies bad request response has a 4xx status code
func (o *CreateFirewallPoliciesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create firewall policies bad request response has a 5xx status code
func (o *CreateFirewallPoliciesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create firewall policies bad request response a status code equal to that given
func (o *CreateFirewallPoliciesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create firewall policies bad request response
func (o *CreateFirewallPoliciesBadRequest) Code() int {
	return 400
}

func (o *CreateFirewallPoliciesBadRequest) Error() string {
	return fmt.Sprintf("[POST /policy/entities/firewall/v1][%d] createFirewallPoliciesBadRequest  %+v", 400, o.Payload)
}

func (o *CreateFirewallPoliciesBadRequest) String() string {
	return fmt.Sprintf("[POST /policy/entities/firewall/v1][%d] createFirewallPoliciesBadRequest  %+v", 400, o.Payload)
}

func (o *CreateFirewallPoliciesBadRequest) GetPayload() *models.FirewallRespV1 {
	return o.Payload
}

func (o *CreateFirewallPoliciesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FirewallRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateFirewallPoliciesForbidden creates a CreateFirewallPoliciesForbidden with default headers values
func NewCreateFirewallPoliciesForbidden() *CreateFirewallPoliciesForbidden {
	return &CreateFirewallPoliciesForbidden{}
}

/*
CreateFirewallPoliciesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CreateFirewallPoliciesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this create firewall policies forbidden response has a 2xx status code
func (o *CreateFirewallPoliciesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create firewall policies forbidden response has a 3xx status code
func (o *CreateFirewallPoliciesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create firewall policies forbidden response has a 4xx status code
func (o *CreateFirewallPoliciesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create firewall policies forbidden response has a 5xx status code
func (o *CreateFirewallPoliciesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create firewall policies forbidden response a status code equal to that given
func (o *CreateFirewallPoliciesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create firewall policies forbidden response
func (o *CreateFirewallPoliciesForbidden) Code() int {
	return 403
}

func (o *CreateFirewallPoliciesForbidden) Error() string {
	return fmt.Sprintf("[POST /policy/entities/firewall/v1][%d] createFirewallPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *CreateFirewallPoliciesForbidden) String() string {
	return fmt.Sprintf("[POST /policy/entities/firewall/v1][%d] createFirewallPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *CreateFirewallPoliciesForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *CreateFirewallPoliciesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateFirewallPoliciesNotFound creates a CreateFirewallPoliciesNotFound with default headers values
func NewCreateFirewallPoliciesNotFound() *CreateFirewallPoliciesNotFound {
	return &CreateFirewallPoliciesNotFound{}
}

/*
CreateFirewallPoliciesNotFound describes a response with status code 404, with default header values.

Not Found
*/
type CreateFirewallPoliciesNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FirewallRespV1
}

// IsSuccess returns true when this create firewall policies not found response has a 2xx status code
func (o *CreateFirewallPoliciesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create firewall policies not found response has a 3xx status code
func (o *CreateFirewallPoliciesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create firewall policies not found response has a 4xx status code
func (o *CreateFirewallPoliciesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this create firewall policies not found response has a 5xx status code
func (o *CreateFirewallPoliciesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this create firewall policies not found response a status code equal to that given
func (o *CreateFirewallPoliciesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the create firewall policies not found response
func (o *CreateFirewallPoliciesNotFound) Code() int {
	return 404
}

func (o *CreateFirewallPoliciesNotFound) Error() string {
	return fmt.Sprintf("[POST /policy/entities/firewall/v1][%d] createFirewallPoliciesNotFound  %+v", 404, o.Payload)
}

func (o *CreateFirewallPoliciesNotFound) String() string {
	return fmt.Sprintf("[POST /policy/entities/firewall/v1][%d] createFirewallPoliciesNotFound  %+v", 404, o.Payload)
}

func (o *CreateFirewallPoliciesNotFound) GetPayload() *models.FirewallRespV1 {
	return o.Payload
}

func (o *CreateFirewallPoliciesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FirewallRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateFirewallPoliciesTooManyRequests creates a CreateFirewallPoliciesTooManyRequests with default headers values
func NewCreateFirewallPoliciesTooManyRequests() *CreateFirewallPoliciesTooManyRequests {
	return &CreateFirewallPoliciesTooManyRequests{}
}

/*
CreateFirewallPoliciesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CreateFirewallPoliciesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create firewall policies too many requests response has a 2xx status code
func (o *CreateFirewallPoliciesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create firewall policies too many requests response has a 3xx status code
func (o *CreateFirewallPoliciesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create firewall policies too many requests response has a 4xx status code
func (o *CreateFirewallPoliciesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this create firewall policies too many requests response has a 5xx status code
func (o *CreateFirewallPoliciesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this create firewall policies too many requests response a status code equal to that given
func (o *CreateFirewallPoliciesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the create firewall policies too many requests response
func (o *CreateFirewallPoliciesTooManyRequests) Code() int {
	return 429
}

func (o *CreateFirewallPoliciesTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /policy/entities/firewall/v1][%d] createFirewallPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateFirewallPoliciesTooManyRequests) String() string {
	return fmt.Sprintf("[POST /policy/entities/firewall/v1][%d] createFirewallPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateFirewallPoliciesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateFirewallPoliciesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateFirewallPoliciesInternalServerError creates a CreateFirewallPoliciesInternalServerError with default headers values
func NewCreateFirewallPoliciesInternalServerError() *CreateFirewallPoliciesInternalServerError {
	return &CreateFirewallPoliciesInternalServerError{}
}

/*
CreateFirewallPoliciesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type CreateFirewallPoliciesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FirewallRespV1
}

// IsSuccess returns true when this create firewall policies internal server error response has a 2xx status code
func (o *CreateFirewallPoliciesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create firewall policies internal server error response has a 3xx status code
func (o *CreateFirewallPoliciesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create firewall policies internal server error response has a 4xx status code
func (o *CreateFirewallPoliciesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create firewall policies internal server error response has a 5xx status code
func (o *CreateFirewallPoliciesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create firewall policies internal server error response a status code equal to that given
func (o *CreateFirewallPoliciesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create firewall policies internal server error response
func (o *CreateFirewallPoliciesInternalServerError) Code() int {
	return 500
}

func (o *CreateFirewallPoliciesInternalServerError) Error() string {
	return fmt.Sprintf("[POST /policy/entities/firewall/v1][%d] createFirewallPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateFirewallPoliciesInternalServerError) String() string {
	return fmt.Sprintf("[POST /policy/entities/firewall/v1][%d] createFirewallPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateFirewallPoliciesInternalServerError) GetPayload() *models.FirewallRespV1 {
	return o.Payload
}

func (o *CreateFirewallPoliciesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FirewallRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
