// Code generated by go-swagger; DO NOT EDIT.

package firewall_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new firewall policies API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for firewall policies API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	CreateFirewallPolicies(params *CreateFirewallPoliciesParams, opts ...ClientOption) (*CreateFirewallPoliciesCreated, error)

	DeleteFirewallPolicies(params *DeleteFirewallPoliciesParams, opts ...ClientOption) (*DeleteFirewallPoliciesOK, error)

	GetFirewallPolicies(params *GetFirewallPoliciesParams, opts ...ClientOption) (*GetFirewallPoliciesOK, error)

	PerformFirewallPoliciesAction(params *PerformFirewallPoliciesActionParams, opts ...ClientOption) (*PerformFirewallPoliciesActionOK, error)

	QueryCombinedFirewallPolicies(params *QueryCombinedFirewallPoliciesParams, opts ...ClientOption) (*QueryCombinedFirewallPoliciesOK, error)

	QueryCombinedFirewallPolicyMembers(params *QueryCombinedFirewallPolicyMembersParams, opts ...ClientOption) (*QueryCombinedFirewallPolicyMembersOK, error)

	QueryFirewallPolicies(params *QueryFirewallPoliciesParams, opts ...ClientOption) (*QueryFirewallPoliciesOK, error)

	QueryFirewallPolicyMembers(params *QueryFirewallPolicyMembersParams, opts ...ClientOption) (*QueryFirewallPolicyMembersOK, error)

	SetFirewallPoliciesPrecedence(params *SetFirewallPoliciesPrecedenceParams, opts ...ClientOption) (*SetFirewallPoliciesPrecedenceOK, error)

	UpdateFirewallPolicies(params *UpdateFirewallPoliciesParams, opts ...ClientOption) (*UpdateFirewallPoliciesOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
CreateFirewallPolicies creates firewall policies by specifying details about the policy to create
*/
func (a *Client) CreateFirewallPolicies(params *CreateFirewallPoliciesParams, opts ...ClientOption) (*CreateFirewallPoliciesCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateFirewallPoliciesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "createFirewallPolicies",
		Method:             "POST",
		PathPattern:        "/policy/entities/firewall/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreateFirewallPoliciesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateFirewallPoliciesCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for createFirewallPolicies: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteFirewallPolicies deletes a set of firewall policies by specifying their i ds
*/
func (a *Client) DeleteFirewallPolicies(params *DeleteFirewallPoliciesParams, opts ...ClientOption) (*DeleteFirewallPoliciesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteFirewallPoliciesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteFirewallPolicies",
		Method:             "DELETE",
		PathPattern:        "/policy/entities/firewall/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteFirewallPoliciesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteFirewallPoliciesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for deleteFirewallPolicies: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetFirewallPolicies retrieves a set of firewall policies by specifying their i ds
*/
func (a *Client) GetFirewallPolicies(params *GetFirewallPoliciesParams, opts ...ClientOption) (*GetFirewallPoliciesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetFirewallPoliciesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getFirewallPolicies",
		Method:             "GET",
		PathPattern:        "/policy/entities/firewall/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetFirewallPoliciesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetFirewallPoliciesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getFirewallPolicies: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PerformFirewallPoliciesAction performs the specified action on the firewall policies specified in the request
*/
func (a *Client) PerformFirewallPoliciesAction(params *PerformFirewallPoliciesActionParams, opts ...ClientOption) (*PerformFirewallPoliciesActionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformFirewallPoliciesActionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performFirewallPoliciesAction",
		Method:             "POST",
		PathPattern:        "/policy/entities/firewall-actions/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformFirewallPoliciesActionReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformFirewallPoliciesActionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for performFirewallPoliciesAction: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryCombinedFirewallPolicies searches for firewall policies in your environment by providing an f q l filter and paging details returns a set of firewall policies which match the filter criteria
*/
func (a *Client) QueryCombinedFirewallPolicies(params *QueryCombinedFirewallPoliciesParams, opts ...ClientOption) (*QueryCombinedFirewallPoliciesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryCombinedFirewallPoliciesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryCombinedFirewallPolicies",
		Method:             "GET",
		PathPattern:        "/policy/combined/firewall/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryCombinedFirewallPoliciesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryCombinedFirewallPoliciesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryCombinedFirewallPolicies: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryCombinedFirewallPolicyMembers searches for members of a firewall policy in your environment by providing an f q l filter and paging details returns a set of host details which match the filter criteria
*/
func (a *Client) QueryCombinedFirewallPolicyMembers(params *QueryCombinedFirewallPolicyMembersParams, opts ...ClientOption) (*QueryCombinedFirewallPolicyMembersOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryCombinedFirewallPolicyMembersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryCombinedFirewallPolicyMembers",
		Method:             "GET",
		PathPattern:        "/policy/combined/firewall-members/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryCombinedFirewallPolicyMembersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryCombinedFirewallPolicyMembersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryCombinedFirewallPolicyMembers: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryFirewallPolicies searches for firewall policies in your environment by providing an f q l filter and paging details returns a set of firewall policy i ds which match the filter criteria
*/
func (a *Client) QueryFirewallPolicies(params *QueryFirewallPoliciesParams, opts ...ClientOption) (*QueryFirewallPoliciesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryFirewallPoliciesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryFirewallPolicies",
		Method:             "GET",
		PathPattern:        "/policy/queries/firewall/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryFirewallPoliciesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryFirewallPoliciesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryFirewallPolicies: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryFirewallPolicyMembers searches for members of a firewall policy in your environment by providing an f q l filter and paging details returns a set of agent i ds which match the filter criteria
*/
func (a *Client) QueryFirewallPolicyMembers(params *QueryFirewallPolicyMembersParams, opts ...ClientOption) (*QueryFirewallPolicyMembersOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryFirewallPolicyMembersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryFirewallPolicyMembers",
		Method:             "GET",
		PathPattern:        "/policy/queries/firewall-members/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryFirewallPolicyMembersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryFirewallPolicyMembersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryFirewallPolicyMembers: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SetFirewallPoliciesPrecedence sets the precedence of firewall policies based on the order of i ds specified in the request the first ID specified will have the highest precedence and the last ID specified will have the lowest you must specify all non default policies for a platform when updating precedence
*/
func (a *Client) SetFirewallPoliciesPrecedence(params *SetFirewallPoliciesPrecedenceParams, opts ...ClientOption) (*SetFirewallPoliciesPrecedenceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSetFirewallPoliciesPrecedenceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "setFirewallPoliciesPrecedence",
		Method:             "POST",
		PathPattern:        "/policy/entities/firewall-precedence/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SetFirewallPoliciesPrecedenceReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SetFirewallPoliciesPrecedenceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for setFirewallPoliciesPrecedence: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateFirewallPolicies updates firewall policies by specifying the ID of the policy and details to update
*/
func (a *Client) UpdateFirewallPolicies(params *UpdateFirewallPoliciesParams, opts ...ClientOption) (*UpdateFirewallPoliciesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateFirewallPoliciesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateFirewallPolicies",
		Method:             "PATCH",
		PathPattern:        "/policy/entities/firewall/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdateFirewallPoliciesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateFirewallPoliciesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateFirewallPolicies: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
