// Code generated by go-swagger; DO NOT EDIT.

package firewall_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetFirewallPoliciesReader is a Reader for the GetFirewallPolicies structure.
type GetFirewallPoliciesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetFirewallPoliciesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetFirewallPoliciesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetFirewallPoliciesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetFirewallPoliciesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetFirewallPoliciesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetFirewallPoliciesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /policy/entities/firewall/v1] getFirewallPolicies", response, response.Code())
	}
}

// NewGetFirewallPoliciesOK creates a GetFirewallPoliciesOK with default headers values
func NewGetFirewallPoliciesOK() *GetFirewallPoliciesOK {
	return &GetFirewallPoliciesOK{}
}

/*
GetFirewallPoliciesOK describes a response with status code 200, with default header values.

OK
*/
type GetFirewallPoliciesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FirewallRespV1
}

// IsSuccess returns true when this get firewall policies o k response has a 2xx status code
func (o *GetFirewallPoliciesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get firewall policies o k response has a 3xx status code
func (o *GetFirewallPoliciesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get firewall policies o k response has a 4xx status code
func (o *GetFirewallPoliciesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get firewall policies o k response has a 5xx status code
func (o *GetFirewallPoliciesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get firewall policies o k response a status code equal to that given
func (o *GetFirewallPoliciesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get firewall policies o k response
func (o *GetFirewallPoliciesOK) Code() int {
	return 200
}

func (o *GetFirewallPoliciesOK) Error() string {
	return fmt.Sprintf("[GET /policy/entities/firewall/v1][%d] getFirewallPoliciesOK  %+v", 200, o.Payload)
}

func (o *GetFirewallPoliciesOK) String() string {
	return fmt.Sprintf("[GET /policy/entities/firewall/v1][%d] getFirewallPoliciesOK  %+v", 200, o.Payload)
}

func (o *GetFirewallPoliciesOK) GetPayload() *models.FirewallRespV1 {
	return o.Payload
}

func (o *GetFirewallPoliciesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FirewallRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetFirewallPoliciesForbidden creates a GetFirewallPoliciesForbidden with default headers values
func NewGetFirewallPoliciesForbidden() *GetFirewallPoliciesForbidden {
	return &GetFirewallPoliciesForbidden{}
}

/*
GetFirewallPoliciesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetFirewallPoliciesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get firewall policies forbidden response has a 2xx status code
func (o *GetFirewallPoliciesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get firewall policies forbidden response has a 3xx status code
func (o *GetFirewallPoliciesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get firewall policies forbidden response has a 4xx status code
func (o *GetFirewallPoliciesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get firewall policies forbidden response has a 5xx status code
func (o *GetFirewallPoliciesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get firewall policies forbidden response a status code equal to that given
func (o *GetFirewallPoliciesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get firewall policies forbidden response
func (o *GetFirewallPoliciesForbidden) Code() int {
	return 403
}

func (o *GetFirewallPoliciesForbidden) Error() string {
	return fmt.Sprintf("[GET /policy/entities/firewall/v1][%d] getFirewallPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *GetFirewallPoliciesForbidden) String() string {
	return fmt.Sprintf("[GET /policy/entities/firewall/v1][%d] getFirewallPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *GetFirewallPoliciesForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetFirewallPoliciesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetFirewallPoliciesNotFound creates a GetFirewallPoliciesNotFound with default headers values
func NewGetFirewallPoliciesNotFound() *GetFirewallPoliciesNotFound {
	return &GetFirewallPoliciesNotFound{}
}

/*
GetFirewallPoliciesNotFound describes a response with status code 404, with default header values.

Not Found
*/
type GetFirewallPoliciesNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FirewallRespV1
}

// IsSuccess returns true when this get firewall policies not found response has a 2xx status code
func (o *GetFirewallPoliciesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get firewall policies not found response has a 3xx status code
func (o *GetFirewallPoliciesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get firewall policies not found response has a 4xx status code
func (o *GetFirewallPoliciesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get firewall policies not found response has a 5xx status code
func (o *GetFirewallPoliciesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get firewall policies not found response a status code equal to that given
func (o *GetFirewallPoliciesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get firewall policies not found response
func (o *GetFirewallPoliciesNotFound) Code() int {
	return 404
}

func (o *GetFirewallPoliciesNotFound) Error() string {
	return fmt.Sprintf("[GET /policy/entities/firewall/v1][%d] getFirewallPoliciesNotFound  %+v", 404, o.Payload)
}

func (o *GetFirewallPoliciesNotFound) String() string {
	return fmt.Sprintf("[GET /policy/entities/firewall/v1][%d] getFirewallPoliciesNotFound  %+v", 404, o.Payload)
}

func (o *GetFirewallPoliciesNotFound) GetPayload() *models.FirewallRespV1 {
	return o.Payload
}

func (o *GetFirewallPoliciesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FirewallRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetFirewallPoliciesTooManyRequests creates a GetFirewallPoliciesTooManyRequests with default headers values
func NewGetFirewallPoliciesTooManyRequests() *GetFirewallPoliciesTooManyRequests {
	return &GetFirewallPoliciesTooManyRequests{}
}

/*
GetFirewallPoliciesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetFirewallPoliciesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get firewall policies too many requests response has a 2xx status code
func (o *GetFirewallPoliciesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get firewall policies too many requests response has a 3xx status code
func (o *GetFirewallPoliciesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get firewall policies too many requests response has a 4xx status code
func (o *GetFirewallPoliciesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get firewall policies too many requests response has a 5xx status code
func (o *GetFirewallPoliciesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get firewall policies too many requests response a status code equal to that given
func (o *GetFirewallPoliciesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get firewall policies too many requests response
func (o *GetFirewallPoliciesTooManyRequests) Code() int {
	return 429
}

func (o *GetFirewallPoliciesTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /policy/entities/firewall/v1][%d] getFirewallPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetFirewallPoliciesTooManyRequests) String() string {
	return fmt.Sprintf("[GET /policy/entities/firewall/v1][%d] getFirewallPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetFirewallPoliciesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetFirewallPoliciesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetFirewallPoliciesInternalServerError creates a GetFirewallPoliciesInternalServerError with default headers values
func NewGetFirewallPoliciesInternalServerError() *GetFirewallPoliciesInternalServerError {
	return &GetFirewallPoliciesInternalServerError{}
}

/*
GetFirewallPoliciesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetFirewallPoliciesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FirewallRespV1
}

// IsSuccess returns true when this get firewall policies internal server error response has a 2xx status code
func (o *GetFirewallPoliciesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get firewall policies internal server error response has a 3xx status code
func (o *GetFirewallPoliciesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get firewall policies internal server error response has a 4xx status code
func (o *GetFirewallPoliciesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get firewall policies internal server error response has a 5xx status code
func (o *GetFirewallPoliciesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get firewall policies internal server error response a status code equal to that given
func (o *GetFirewallPoliciesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get firewall policies internal server error response
func (o *GetFirewallPoliciesInternalServerError) Code() int {
	return 500
}

func (o *GetFirewallPoliciesInternalServerError) Error() string {
	return fmt.Sprintf("[GET /policy/entities/firewall/v1][%d] getFirewallPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *GetFirewallPoliciesInternalServerError) String() string {
	return fmt.Sprintf("[GET /policy/entities/firewall/v1][%d] getFirewallPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *GetFirewallPoliciesInternalServerError) GetPayload() *models.FirewallRespV1 {
	return o.Payload
}

func (o *GetFirewallPoliciesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FirewallRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
