// Code generated by go-swagger; DO NOT EDIT.

package firewall_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// SetFirewallPoliciesPrecedenceReader is a Reader for the SetFirewallPoliciesPrecedence structure.
type SetFirewallPoliciesPrecedenceReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SetFirewallPoliciesPrecedenceReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSetFirewallPoliciesPrecedenceOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewSetFirewallPoliciesPrecedenceBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewSetFirewallPoliciesPrecedenceForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewSetFirewallPoliciesPrecedenceTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSetFirewallPoliciesPrecedenceInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /policy/entities/firewall-precedence/v1] setFirewallPoliciesPrecedence", response, response.Code())
	}
}

// NewSetFirewallPoliciesPrecedenceOK creates a SetFirewallPoliciesPrecedenceOK with default headers values
func NewSetFirewallPoliciesPrecedenceOK() *SetFirewallPoliciesPrecedenceOK {
	return &SetFirewallPoliciesPrecedenceOK{}
}

/*
SetFirewallPoliciesPrecedenceOK describes a response with status code 200, with default header values.

OK
*/
type SetFirewallPoliciesPrecedenceOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this set firewall policies precedence o k response has a 2xx status code
func (o *SetFirewallPoliciesPrecedenceOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this set firewall policies precedence o k response has a 3xx status code
func (o *SetFirewallPoliciesPrecedenceOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set firewall policies precedence o k response has a 4xx status code
func (o *SetFirewallPoliciesPrecedenceOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this set firewall policies precedence o k response has a 5xx status code
func (o *SetFirewallPoliciesPrecedenceOK) IsServerError() bool {
	return false
}

// IsCode returns true when this set firewall policies precedence o k response a status code equal to that given
func (o *SetFirewallPoliciesPrecedenceOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the set firewall policies precedence o k response
func (o *SetFirewallPoliciesPrecedenceOK) Code() int {
	return 200
}

func (o *SetFirewallPoliciesPrecedenceOK) Error() string {
	return fmt.Sprintf("[POST /policy/entities/firewall-precedence/v1][%d] setFirewallPoliciesPrecedenceOK  %+v", 200, o.Payload)
}

func (o *SetFirewallPoliciesPrecedenceOK) String() string {
	return fmt.Sprintf("[POST /policy/entities/firewall-precedence/v1][%d] setFirewallPoliciesPrecedenceOK  %+v", 200, o.Payload)
}

func (o *SetFirewallPoliciesPrecedenceOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *SetFirewallPoliciesPrecedenceOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetFirewallPoliciesPrecedenceBadRequest creates a SetFirewallPoliciesPrecedenceBadRequest with default headers values
func NewSetFirewallPoliciesPrecedenceBadRequest() *SetFirewallPoliciesPrecedenceBadRequest {
	return &SetFirewallPoliciesPrecedenceBadRequest{}
}

/*
SetFirewallPoliciesPrecedenceBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type SetFirewallPoliciesPrecedenceBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this set firewall policies precedence bad request response has a 2xx status code
func (o *SetFirewallPoliciesPrecedenceBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set firewall policies precedence bad request response has a 3xx status code
func (o *SetFirewallPoliciesPrecedenceBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set firewall policies precedence bad request response has a 4xx status code
func (o *SetFirewallPoliciesPrecedenceBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this set firewall policies precedence bad request response has a 5xx status code
func (o *SetFirewallPoliciesPrecedenceBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this set firewall policies precedence bad request response a status code equal to that given
func (o *SetFirewallPoliciesPrecedenceBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the set firewall policies precedence bad request response
func (o *SetFirewallPoliciesPrecedenceBadRequest) Code() int {
	return 400
}

func (o *SetFirewallPoliciesPrecedenceBadRequest) Error() string {
	return fmt.Sprintf("[POST /policy/entities/firewall-precedence/v1][%d] setFirewallPoliciesPrecedenceBadRequest  %+v", 400, o.Payload)
}

func (o *SetFirewallPoliciesPrecedenceBadRequest) String() string {
	return fmt.Sprintf("[POST /policy/entities/firewall-precedence/v1][%d] setFirewallPoliciesPrecedenceBadRequest  %+v", 400, o.Payload)
}

func (o *SetFirewallPoliciesPrecedenceBadRequest) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *SetFirewallPoliciesPrecedenceBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetFirewallPoliciesPrecedenceForbidden creates a SetFirewallPoliciesPrecedenceForbidden with default headers values
func NewSetFirewallPoliciesPrecedenceForbidden() *SetFirewallPoliciesPrecedenceForbidden {
	return &SetFirewallPoliciesPrecedenceForbidden{}
}

/*
SetFirewallPoliciesPrecedenceForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type SetFirewallPoliciesPrecedenceForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this set firewall policies precedence forbidden response has a 2xx status code
func (o *SetFirewallPoliciesPrecedenceForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set firewall policies precedence forbidden response has a 3xx status code
func (o *SetFirewallPoliciesPrecedenceForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set firewall policies precedence forbidden response has a 4xx status code
func (o *SetFirewallPoliciesPrecedenceForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this set firewall policies precedence forbidden response has a 5xx status code
func (o *SetFirewallPoliciesPrecedenceForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this set firewall policies precedence forbidden response a status code equal to that given
func (o *SetFirewallPoliciesPrecedenceForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the set firewall policies precedence forbidden response
func (o *SetFirewallPoliciesPrecedenceForbidden) Code() int {
	return 403
}

func (o *SetFirewallPoliciesPrecedenceForbidden) Error() string {
	return fmt.Sprintf("[POST /policy/entities/firewall-precedence/v1][%d] setFirewallPoliciesPrecedenceForbidden  %+v", 403, o.Payload)
}

func (o *SetFirewallPoliciesPrecedenceForbidden) String() string {
	return fmt.Sprintf("[POST /policy/entities/firewall-precedence/v1][%d] setFirewallPoliciesPrecedenceForbidden  %+v", 403, o.Payload)
}

func (o *SetFirewallPoliciesPrecedenceForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *SetFirewallPoliciesPrecedenceForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetFirewallPoliciesPrecedenceTooManyRequests creates a SetFirewallPoliciesPrecedenceTooManyRequests with default headers values
func NewSetFirewallPoliciesPrecedenceTooManyRequests() *SetFirewallPoliciesPrecedenceTooManyRequests {
	return &SetFirewallPoliciesPrecedenceTooManyRequests{}
}

/*
SetFirewallPoliciesPrecedenceTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type SetFirewallPoliciesPrecedenceTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this set firewall policies precedence too many requests response has a 2xx status code
func (o *SetFirewallPoliciesPrecedenceTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set firewall policies precedence too many requests response has a 3xx status code
func (o *SetFirewallPoliciesPrecedenceTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set firewall policies precedence too many requests response has a 4xx status code
func (o *SetFirewallPoliciesPrecedenceTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this set firewall policies precedence too many requests response has a 5xx status code
func (o *SetFirewallPoliciesPrecedenceTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this set firewall policies precedence too many requests response a status code equal to that given
func (o *SetFirewallPoliciesPrecedenceTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the set firewall policies precedence too many requests response
func (o *SetFirewallPoliciesPrecedenceTooManyRequests) Code() int {
	return 429
}

func (o *SetFirewallPoliciesPrecedenceTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /policy/entities/firewall-precedence/v1][%d] setFirewallPoliciesPrecedenceTooManyRequests  %+v", 429, o.Payload)
}

func (o *SetFirewallPoliciesPrecedenceTooManyRequests) String() string {
	return fmt.Sprintf("[POST /policy/entities/firewall-precedence/v1][%d] setFirewallPoliciesPrecedenceTooManyRequests  %+v", 429, o.Payload)
}

func (o *SetFirewallPoliciesPrecedenceTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *SetFirewallPoliciesPrecedenceTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetFirewallPoliciesPrecedenceInternalServerError creates a SetFirewallPoliciesPrecedenceInternalServerError with default headers values
func NewSetFirewallPoliciesPrecedenceInternalServerError() *SetFirewallPoliciesPrecedenceInternalServerError {
	return &SetFirewallPoliciesPrecedenceInternalServerError{}
}

/*
SetFirewallPoliciesPrecedenceInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type SetFirewallPoliciesPrecedenceInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this set firewall policies precedence internal server error response has a 2xx status code
func (o *SetFirewallPoliciesPrecedenceInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set firewall policies precedence internal server error response has a 3xx status code
func (o *SetFirewallPoliciesPrecedenceInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set firewall policies precedence internal server error response has a 4xx status code
func (o *SetFirewallPoliciesPrecedenceInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this set firewall policies precedence internal server error response has a 5xx status code
func (o *SetFirewallPoliciesPrecedenceInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this set firewall policies precedence internal server error response a status code equal to that given
func (o *SetFirewallPoliciesPrecedenceInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the set firewall policies precedence internal server error response
func (o *SetFirewallPoliciesPrecedenceInternalServerError) Code() int {
	return 500
}

func (o *SetFirewallPoliciesPrecedenceInternalServerError) Error() string {
	return fmt.Sprintf("[POST /policy/entities/firewall-precedence/v1][%d] setFirewallPoliciesPrecedenceInternalServerError  %+v", 500, o.Payload)
}

func (o *SetFirewallPoliciesPrecedenceInternalServerError) String() string {
	return fmt.Sprintf("[POST /policy/entities/firewall-precedence/v1][%d] setFirewallPoliciesPrecedenceInternalServerError  %+v", 500, o.Payload)
}

func (o *SetFirewallPoliciesPrecedenceInternalServerError) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *SetFirewallPoliciesPrecedenceInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
