// Code generated by go-swagger; DO NOT EDIT.

package firewall_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateFirewallPoliciesReader is a Reader for the UpdateFirewallPolicies structure.
type UpdateFirewallPoliciesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateFirewallPoliciesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateFirewallPoliciesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateFirewallPoliciesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateFirewallPoliciesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateFirewallPoliciesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateFirewallPoliciesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateFirewallPoliciesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /policy/entities/firewall/v1] updateFirewallPolicies", response, response.Code())
	}
}

// NewUpdateFirewallPoliciesOK creates a UpdateFirewallPoliciesOK with default headers values
func NewUpdateFirewallPoliciesOK() *UpdateFirewallPoliciesOK {
	return &UpdateFirewallPoliciesOK{}
}

/*
UpdateFirewallPoliciesOK describes a response with status code 200, with default header values.

OK
*/
type UpdateFirewallPoliciesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FirewallRespV1
}

// IsSuccess returns true when this update firewall policies o k response has a 2xx status code
func (o *UpdateFirewallPoliciesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update firewall policies o k response has a 3xx status code
func (o *UpdateFirewallPoliciesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update firewall policies o k response has a 4xx status code
func (o *UpdateFirewallPoliciesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update firewall policies o k response has a 5xx status code
func (o *UpdateFirewallPoliciesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update firewall policies o k response a status code equal to that given
func (o *UpdateFirewallPoliciesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update firewall policies o k response
func (o *UpdateFirewallPoliciesOK) Code() int {
	return 200
}

func (o *UpdateFirewallPoliciesOK) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/firewall/v1][%d] updateFirewallPoliciesOK  %+v", 200, o.Payload)
}

func (o *UpdateFirewallPoliciesOK) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/firewall/v1][%d] updateFirewallPoliciesOK  %+v", 200, o.Payload)
}

func (o *UpdateFirewallPoliciesOK) GetPayload() *models.FirewallRespV1 {
	return o.Payload
}

func (o *UpdateFirewallPoliciesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FirewallRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateFirewallPoliciesBadRequest creates a UpdateFirewallPoliciesBadRequest with default headers values
func NewUpdateFirewallPoliciesBadRequest() *UpdateFirewallPoliciesBadRequest {
	return &UpdateFirewallPoliciesBadRequest{}
}

/*
UpdateFirewallPoliciesBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdateFirewallPoliciesBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FirewallRespV1
}

// IsSuccess returns true when this update firewall policies bad request response has a 2xx status code
func (o *UpdateFirewallPoliciesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update firewall policies bad request response has a 3xx status code
func (o *UpdateFirewallPoliciesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update firewall policies bad request response has a 4xx status code
func (o *UpdateFirewallPoliciesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update firewall policies bad request response has a 5xx status code
func (o *UpdateFirewallPoliciesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update firewall policies bad request response a status code equal to that given
func (o *UpdateFirewallPoliciesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update firewall policies bad request response
func (o *UpdateFirewallPoliciesBadRequest) Code() int {
	return 400
}

func (o *UpdateFirewallPoliciesBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/firewall/v1][%d] updateFirewallPoliciesBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateFirewallPoliciesBadRequest) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/firewall/v1][%d] updateFirewallPoliciesBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateFirewallPoliciesBadRequest) GetPayload() *models.FirewallRespV1 {
	return o.Payload
}

func (o *UpdateFirewallPoliciesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FirewallRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateFirewallPoliciesForbidden creates a UpdateFirewallPoliciesForbidden with default headers values
func NewUpdateFirewallPoliciesForbidden() *UpdateFirewallPoliciesForbidden {
	return &UpdateFirewallPoliciesForbidden{}
}

/*
UpdateFirewallPoliciesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateFirewallPoliciesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this update firewall policies forbidden response has a 2xx status code
func (o *UpdateFirewallPoliciesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update firewall policies forbidden response has a 3xx status code
func (o *UpdateFirewallPoliciesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update firewall policies forbidden response has a 4xx status code
func (o *UpdateFirewallPoliciesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update firewall policies forbidden response has a 5xx status code
func (o *UpdateFirewallPoliciesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update firewall policies forbidden response a status code equal to that given
func (o *UpdateFirewallPoliciesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update firewall policies forbidden response
func (o *UpdateFirewallPoliciesForbidden) Code() int {
	return 403
}

func (o *UpdateFirewallPoliciesForbidden) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/firewall/v1][%d] updateFirewallPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *UpdateFirewallPoliciesForbidden) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/firewall/v1][%d] updateFirewallPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *UpdateFirewallPoliciesForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *UpdateFirewallPoliciesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateFirewallPoliciesNotFound creates a UpdateFirewallPoliciesNotFound with default headers values
func NewUpdateFirewallPoliciesNotFound() *UpdateFirewallPoliciesNotFound {
	return &UpdateFirewallPoliciesNotFound{}
}

/*
UpdateFirewallPoliciesNotFound describes a response with status code 404, with default header values.

Not Found
*/
type UpdateFirewallPoliciesNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FirewallRespV1
}

// IsSuccess returns true when this update firewall policies not found response has a 2xx status code
func (o *UpdateFirewallPoliciesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update firewall policies not found response has a 3xx status code
func (o *UpdateFirewallPoliciesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update firewall policies not found response has a 4xx status code
func (o *UpdateFirewallPoliciesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this update firewall policies not found response has a 5xx status code
func (o *UpdateFirewallPoliciesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this update firewall policies not found response a status code equal to that given
func (o *UpdateFirewallPoliciesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the update firewall policies not found response
func (o *UpdateFirewallPoliciesNotFound) Code() int {
	return 404
}

func (o *UpdateFirewallPoliciesNotFound) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/firewall/v1][%d] updateFirewallPoliciesNotFound  %+v", 404, o.Payload)
}

func (o *UpdateFirewallPoliciesNotFound) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/firewall/v1][%d] updateFirewallPoliciesNotFound  %+v", 404, o.Payload)
}

func (o *UpdateFirewallPoliciesNotFound) GetPayload() *models.FirewallRespV1 {
	return o.Payload
}

func (o *UpdateFirewallPoliciesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FirewallRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateFirewallPoliciesTooManyRequests creates a UpdateFirewallPoliciesTooManyRequests with default headers values
func NewUpdateFirewallPoliciesTooManyRequests() *UpdateFirewallPoliciesTooManyRequests {
	return &UpdateFirewallPoliciesTooManyRequests{}
}

/*
UpdateFirewallPoliciesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateFirewallPoliciesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update firewall policies too many requests response has a 2xx status code
func (o *UpdateFirewallPoliciesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update firewall policies too many requests response has a 3xx status code
func (o *UpdateFirewallPoliciesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update firewall policies too many requests response has a 4xx status code
func (o *UpdateFirewallPoliciesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update firewall policies too many requests response has a 5xx status code
func (o *UpdateFirewallPoliciesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update firewall policies too many requests response a status code equal to that given
func (o *UpdateFirewallPoliciesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update firewall policies too many requests response
func (o *UpdateFirewallPoliciesTooManyRequests) Code() int {
	return 429
}

func (o *UpdateFirewallPoliciesTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/firewall/v1][%d] updateFirewallPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateFirewallPoliciesTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/firewall/v1][%d] updateFirewallPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateFirewallPoliciesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateFirewallPoliciesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateFirewallPoliciesInternalServerError creates a UpdateFirewallPoliciesInternalServerError with default headers values
func NewUpdateFirewallPoliciesInternalServerError() *UpdateFirewallPoliciesInternalServerError {
	return &UpdateFirewallPoliciesInternalServerError{}
}

/*
UpdateFirewallPoliciesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type UpdateFirewallPoliciesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FirewallRespV1
}

// IsSuccess returns true when this update firewall policies internal server error response has a 2xx status code
func (o *UpdateFirewallPoliciesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update firewall policies internal server error response has a 3xx status code
func (o *UpdateFirewallPoliciesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update firewall policies internal server error response has a 4xx status code
func (o *UpdateFirewallPoliciesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update firewall policies internal server error response has a 5xx status code
func (o *UpdateFirewallPoliciesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update firewall policies internal server error response a status code equal to that given
func (o *UpdateFirewallPoliciesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update firewall policies internal server error response
func (o *UpdateFirewallPoliciesInternalServerError) Code() int {
	return 500
}

func (o *UpdateFirewallPoliciesInternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/firewall/v1][%d] updateFirewallPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateFirewallPoliciesInternalServerError) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/firewall/v1][%d] updateFirewallPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateFirewallPoliciesInternalServerError) GetPayload() *models.FirewallRespV1 {
	return o.Payload
}

func (o *UpdateFirewallPoliciesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FirewallRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
