// Code generated by go-swagger; DO NOT EDIT.

package host_group

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteHostGroupsParams creates a new DeleteHostGroupsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteHostGroupsParams() *DeleteHostGroupsParams {
	return &DeleteHostGroupsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteHostGroupsParamsWithTimeout creates a new DeleteHostGroupsParams object
// with the ability to set a timeout on a request.
func NewDeleteHostGroupsParamsWithTimeout(timeout time.Duration) *DeleteHostGroupsParams {
	return &DeleteHostGroupsParams{
		timeout: timeout,
	}
}

// NewDeleteHostGroupsParamsWithContext creates a new DeleteHostGroupsParams object
// with the ability to set a context for a request.
func NewDeleteHostGroupsParamsWithContext(ctx context.Context) *DeleteHostGroupsParams {
	return &DeleteHostGroupsParams{
		Context: ctx,
	}
}

// NewDeleteHostGroupsParamsWithHTTPClient creates a new DeleteHostGroupsParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteHostGroupsParamsWithHTTPClient(client *http.Client) *DeleteHostGroupsParams {
	return &DeleteHostGroupsParams{
		HTTPClient: client,
	}
}

/*
DeleteHostGroupsParams contains all the parameters to send to the API endpoint

	for the delete host groups operation.

	Typically these are written to a http.Request.
*/
type DeleteHostGroupsParams struct {

	/* Ids.

	   The IDs of the Host Groups to delete
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete host groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteHostGroupsParams) WithDefaults() *DeleteHostGroupsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete host groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteHostGroupsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete host groups params
func (o *DeleteHostGroupsParams) WithTimeout(timeout time.Duration) *DeleteHostGroupsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete host groups params
func (o *DeleteHostGroupsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete host groups params
func (o *DeleteHostGroupsParams) WithContext(ctx context.Context) *DeleteHostGroupsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete host groups params
func (o *DeleteHostGroupsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete host groups params
func (o *DeleteHostGroupsParams) WithHTTPClient(client *http.Client) *DeleteHostGroupsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete host groups params
func (o *DeleteHostGroupsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the delete host groups params
func (o *DeleteHostGroupsParams) WithIds(ids []string) *DeleteHostGroupsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the delete host groups params
func (o *DeleteHostGroupsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteHostGroupsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDeleteHostGroups binds the parameter ids
func (o *DeleteHostGroupsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
