// Code generated by go-swagger; DO NOT EDIT.

package host_group

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// DeleteHostGroupsReader is a Reader for the DeleteHostGroups structure.
type DeleteHostGroupsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteHostGroupsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteHostGroupsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewDeleteHostGroupsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeleteHostGroupsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewDeleteHostGroupsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteHostGroupsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /devices/entities/host-groups/v1] deleteHostGroups", response, response.Code())
	}
}

// NewDeleteHostGroupsOK creates a DeleteHostGroupsOK with default headers values
func NewDeleteHostGroupsOK() *DeleteHostGroupsOK {
	return &DeleteHostGroupsOK{}
}

/*
DeleteHostGroupsOK describes a response with status code 200, with default header values.

OK
*/
type DeleteHostGroupsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this delete host groups o k response has a 2xx status code
func (o *DeleteHostGroupsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete host groups o k response has a 3xx status code
func (o *DeleteHostGroupsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete host groups o k response has a 4xx status code
func (o *DeleteHostGroupsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete host groups o k response has a 5xx status code
func (o *DeleteHostGroupsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete host groups o k response a status code equal to that given
func (o *DeleteHostGroupsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete host groups o k response
func (o *DeleteHostGroupsOK) Code() int {
	return 200
}

func (o *DeleteHostGroupsOK) Error() string {
	return fmt.Sprintf("[DELETE /devices/entities/host-groups/v1][%d] deleteHostGroupsOK  %+v", 200, o.Payload)
}

func (o *DeleteHostGroupsOK) String() string {
	return fmt.Sprintf("[DELETE /devices/entities/host-groups/v1][%d] deleteHostGroupsOK  %+v", 200, o.Payload)
}

func (o *DeleteHostGroupsOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *DeleteHostGroupsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteHostGroupsForbidden creates a DeleteHostGroupsForbidden with default headers values
func NewDeleteHostGroupsForbidden() *DeleteHostGroupsForbidden {
	return &DeleteHostGroupsForbidden{}
}

/*
DeleteHostGroupsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type DeleteHostGroupsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this delete host groups forbidden response has a 2xx status code
func (o *DeleteHostGroupsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete host groups forbidden response has a 3xx status code
func (o *DeleteHostGroupsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete host groups forbidden response has a 4xx status code
func (o *DeleteHostGroupsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete host groups forbidden response has a 5xx status code
func (o *DeleteHostGroupsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete host groups forbidden response a status code equal to that given
func (o *DeleteHostGroupsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete host groups forbidden response
func (o *DeleteHostGroupsForbidden) Code() int {
	return 403
}

func (o *DeleteHostGroupsForbidden) Error() string {
	return fmt.Sprintf("[DELETE /devices/entities/host-groups/v1][%d] deleteHostGroupsForbidden  %+v", 403, o.Payload)
}

func (o *DeleteHostGroupsForbidden) String() string {
	return fmt.Sprintf("[DELETE /devices/entities/host-groups/v1][%d] deleteHostGroupsForbidden  %+v", 403, o.Payload)
}

func (o *DeleteHostGroupsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *DeleteHostGroupsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteHostGroupsNotFound creates a DeleteHostGroupsNotFound with default headers values
func NewDeleteHostGroupsNotFound() *DeleteHostGroupsNotFound {
	return &DeleteHostGroupsNotFound{}
}

/*
DeleteHostGroupsNotFound describes a response with status code 404, with default header values.

Not Found
*/
type DeleteHostGroupsNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this delete host groups not found response has a 2xx status code
func (o *DeleteHostGroupsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete host groups not found response has a 3xx status code
func (o *DeleteHostGroupsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete host groups not found response has a 4xx status code
func (o *DeleteHostGroupsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete host groups not found response has a 5xx status code
func (o *DeleteHostGroupsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete host groups not found response a status code equal to that given
func (o *DeleteHostGroupsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the delete host groups not found response
func (o *DeleteHostGroupsNotFound) Code() int {
	return 404
}

func (o *DeleteHostGroupsNotFound) Error() string {
	return fmt.Sprintf("[DELETE /devices/entities/host-groups/v1][%d] deleteHostGroupsNotFound  %+v", 404, o.Payload)
}

func (o *DeleteHostGroupsNotFound) String() string {
	return fmt.Sprintf("[DELETE /devices/entities/host-groups/v1][%d] deleteHostGroupsNotFound  %+v", 404, o.Payload)
}

func (o *DeleteHostGroupsNotFound) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *DeleteHostGroupsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteHostGroupsTooManyRequests creates a DeleteHostGroupsTooManyRequests with default headers values
func NewDeleteHostGroupsTooManyRequests() *DeleteHostGroupsTooManyRequests {
	return &DeleteHostGroupsTooManyRequests{}
}

/*
DeleteHostGroupsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type DeleteHostGroupsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this delete host groups too many requests response has a 2xx status code
func (o *DeleteHostGroupsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete host groups too many requests response has a 3xx status code
func (o *DeleteHostGroupsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete host groups too many requests response has a 4xx status code
func (o *DeleteHostGroupsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete host groups too many requests response has a 5xx status code
func (o *DeleteHostGroupsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this delete host groups too many requests response a status code equal to that given
func (o *DeleteHostGroupsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the delete host groups too many requests response
func (o *DeleteHostGroupsTooManyRequests) Code() int {
	return 429
}

func (o *DeleteHostGroupsTooManyRequests) Error() string {
	return fmt.Sprintf("[DELETE /devices/entities/host-groups/v1][%d] deleteHostGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteHostGroupsTooManyRequests) String() string {
	return fmt.Sprintf("[DELETE /devices/entities/host-groups/v1][%d] deleteHostGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteHostGroupsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *DeleteHostGroupsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteHostGroupsInternalServerError creates a DeleteHostGroupsInternalServerError with default headers values
func NewDeleteHostGroupsInternalServerError() *DeleteHostGroupsInternalServerError {
	return &DeleteHostGroupsInternalServerError{}
}

/*
DeleteHostGroupsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type DeleteHostGroupsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this delete host groups internal server error response has a 2xx status code
func (o *DeleteHostGroupsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete host groups internal server error response has a 3xx status code
func (o *DeleteHostGroupsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete host groups internal server error response has a 4xx status code
func (o *DeleteHostGroupsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete host groups internal server error response has a 5xx status code
func (o *DeleteHostGroupsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete host groups internal server error response a status code equal to that given
func (o *DeleteHostGroupsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete host groups internal server error response
func (o *DeleteHostGroupsInternalServerError) Code() int {
	return 500
}

func (o *DeleteHostGroupsInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /devices/entities/host-groups/v1][%d] deleteHostGroupsInternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteHostGroupsInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /devices/entities/host-groups/v1][%d] deleteHostGroupsInternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteHostGroupsInternalServerError) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *DeleteHostGroupsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
