// Code generated by go-swagger; DO NOT EDIT.

package host_group

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetHostGroupsParams creates a new GetHostGroupsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetHostGroupsParams() *GetHostGroupsParams {
	return &GetHostGroupsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetHostGroupsParamsWithTimeout creates a new GetHostGroupsParams object
// with the ability to set a timeout on a request.
func NewGetHostGroupsParamsWithTimeout(timeout time.Duration) *GetHostGroupsParams {
	return &GetHostGroupsParams{
		timeout: timeout,
	}
}

// NewGetHostGroupsParamsWithContext creates a new GetHostGroupsParams object
// with the ability to set a context for a request.
func NewGetHostGroupsParamsWithContext(ctx context.Context) *GetHostGroupsParams {
	return &GetHostGroupsParams{
		Context: ctx,
	}
}

// NewGetHostGroupsParamsWithHTTPClient creates a new GetHostGroupsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetHostGroupsParamsWithHTTPClient(client *http.Client) *GetHostGroupsParams {
	return &GetHostGroupsParams{
		HTTPClient: client,
	}
}

/*
GetHostGroupsParams contains all the parameters to send to the API endpoint

	for the get host groups operation.

	Typically these are written to a http.Request.
*/
type GetHostGroupsParams struct {

	/* Ids.

	   The IDs of the Host Groups to return
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get host groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetHostGroupsParams) WithDefaults() *GetHostGroupsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get host groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetHostGroupsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get host groups params
func (o *GetHostGroupsParams) WithTimeout(timeout time.Duration) *GetHostGroupsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get host groups params
func (o *GetHostGroupsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get host groups params
func (o *GetHostGroupsParams) WithContext(ctx context.Context) *GetHostGroupsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get host groups params
func (o *GetHostGroupsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get host groups params
func (o *GetHostGroupsParams) WithHTTPClient(client *http.Client) *GetHostGroupsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get host groups params
func (o *GetHostGroupsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get host groups params
func (o *GetHostGroupsParams) WithIds(ids []string) *GetHostGroupsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get host groups params
func (o *GetHostGroupsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetHostGroupsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetHostGroups binds the parameter ids
func (o *GetHostGroupsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
