// Code generated by go-swagger; DO NOT EDIT.

package host_group

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetHostGroupsReader is a Reader for the GetHostGroups structure.
type GetHostGroupsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetHostGroupsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetHostGroupsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetHostGroupsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetHostGroupsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetHostGroupsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetHostGroupsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetHostGroupsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /devices/entities/host-groups/v1] getHostGroups", response, response.Code())
	}
}

// NewGetHostGroupsOK creates a GetHostGroupsOK with default headers values
func NewGetHostGroupsOK() *GetHostGroupsOK {
	return &GetHostGroupsOK{}
}

/*
GetHostGroupsOK describes a response with status code 200, with default header values.

OK
*/
type GetHostGroupsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.HostGroupsRespV1
}

// IsSuccess returns true when this get host groups o k response has a 2xx status code
func (o *GetHostGroupsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get host groups o k response has a 3xx status code
func (o *GetHostGroupsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get host groups o k response has a 4xx status code
func (o *GetHostGroupsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get host groups o k response has a 5xx status code
func (o *GetHostGroupsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get host groups o k response a status code equal to that given
func (o *GetHostGroupsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get host groups o k response
func (o *GetHostGroupsOK) Code() int {
	return 200
}

func (o *GetHostGroupsOK) Error() string {
	return fmt.Sprintf("[GET /devices/entities/host-groups/v1][%d] getHostGroupsOK  %+v", 200, o.Payload)
}

func (o *GetHostGroupsOK) String() string {
	return fmt.Sprintf("[GET /devices/entities/host-groups/v1][%d] getHostGroupsOK  %+v", 200, o.Payload)
}

func (o *GetHostGroupsOK) GetPayload() *models.HostGroupsRespV1 {
	return o.Payload
}

func (o *GetHostGroupsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.HostGroupsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetHostGroupsBadRequest creates a GetHostGroupsBadRequest with default headers values
func NewGetHostGroupsBadRequest() *GetHostGroupsBadRequest {
	return &GetHostGroupsBadRequest{}
}

/*
GetHostGroupsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetHostGroupsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.HostGroupsRespV1
}

// IsSuccess returns true when this get host groups bad request response has a 2xx status code
func (o *GetHostGroupsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get host groups bad request response has a 3xx status code
func (o *GetHostGroupsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get host groups bad request response has a 4xx status code
func (o *GetHostGroupsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get host groups bad request response has a 5xx status code
func (o *GetHostGroupsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get host groups bad request response a status code equal to that given
func (o *GetHostGroupsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get host groups bad request response
func (o *GetHostGroupsBadRequest) Code() int {
	return 400
}

func (o *GetHostGroupsBadRequest) Error() string {
	return fmt.Sprintf("[GET /devices/entities/host-groups/v1][%d] getHostGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *GetHostGroupsBadRequest) String() string {
	return fmt.Sprintf("[GET /devices/entities/host-groups/v1][%d] getHostGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *GetHostGroupsBadRequest) GetPayload() *models.HostGroupsRespV1 {
	return o.Payload
}

func (o *GetHostGroupsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.HostGroupsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetHostGroupsForbidden creates a GetHostGroupsForbidden with default headers values
func NewGetHostGroupsForbidden() *GetHostGroupsForbidden {
	return &GetHostGroupsForbidden{}
}

/*
GetHostGroupsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetHostGroupsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get host groups forbidden response has a 2xx status code
func (o *GetHostGroupsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get host groups forbidden response has a 3xx status code
func (o *GetHostGroupsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get host groups forbidden response has a 4xx status code
func (o *GetHostGroupsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get host groups forbidden response has a 5xx status code
func (o *GetHostGroupsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get host groups forbidden response a status code equal to that given
func (o *GetHostGroupsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get host groups forbidden response
func (o *GetHostGroupsForbidden) Code() int {
	return 403
}

func (o *GetHostGroupsForbidden) Error() string {
	return fmt.Sprintf("[GET /devices/entities/host-groups/v1][%d] getHostGroupsForbidden  %+v", 403, o.Payload)
}

func (o *GetHostGroupsForbidden) String() string {
	return fmt.Sprintf("[GET /devices/entities/host-groups/v1][%d] getHostGroupsForbidden  %+v", 403, o.Payload)
}

func (o *GetHostGroupsForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetHostGroupsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetHostGroupsNotFound creates a GetHostGroupsNotFound with default headers values
func NewGetHostGroupsNotFound() *GetHostGroupsNotFound {
	return &GetHostGroupsNotFound{}
}

/*
GetHostGroupsNotFound describes a response with status code 404, with default header values.

Not Found
*/
type GetHostGroupsNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.HostGroupsRespV1
}

// IsSuccess returns true when this get host groups not found response has a 2xx status code
func (o *GetHostGroupsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get host groups not found response has a 3xx status code
func (o *GetHostGroupsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get host groups not found response has a 4xx status code
func (o *GetHostGroupsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get host groups not found response has a 5xx status code
func (o *GetHostGroupsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get host groups not found response a status code equal to that given
func (o *GetHostGroupsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get host groups not found response
func (o *GetHostGroupsNotFound) Code() int {
	return 404
}

func (o *GetHostGroupsNotFound) Error() string {
	return fmt.Sprintf("[GET /devices/entities/host-groups/v1][%d] getHostGroupsNotFound  %+v", 404, o.Payload)
}

func (o *GetHostGroupsNotFound) String() string {
	return fmt.Sprintf("[GET /devices/entities/host-groups/v1][%d] getHostGroupsNotFound  %+v", 404, o.Payload)
}

func (o *GetHostGroupsNotFound) GetPayload() *models.HostGroupsRespV1 {
	return o.Payload
}

func (o *GetHostGroupsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.HostGroupsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetHostGroupsTooManyRequests creates a GetHostGroupsTooManyRequests with default headers values
func NewGetHostGroupsTooManyRequests() *GetHostGroupsTooManyRequests {
	return &GetHostGroupsTooManyRequests{}
}

/*
GetHostGroupsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetHostGroupsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get host groups too many requests response has a 2xx status code
func (o *GetHostGroupsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get host groups too many requests response has a 3xx status code
func (o *GetHostGroupsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get host groups too many requests response has a 4xx status code
func (o *GetHostGroupsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get host groups too many requests response has a 5xx status code
func (o *GetHostGroupsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get host groups too many requests response a status code equal to that given
func (o *GetHostGroupsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get host groups too many requests response
func (o *GetHostGroupsTooManyRequests) Code() int {
	return 429
}

func (o *GetHostGroupsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /devices/entities/host-groups/v1][%d] getHostGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetHostGroupsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /devices/entities/host-groups/v1][%d] getHostGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetHostGroupsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetHostGroupsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetHostGroupsInternalServerError creates a GetHostGroupsInternalServerError with default headers values
func NewGetHostGroupsInternalServerError() *GetHostGroupsInternalServerError {
	return &GetHostGroupsInternalServerError{}
}

/*
GetHostGroupsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetHostGroupsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.HostGroupsRespV1
}

// IsSuccess returns true when this get host groups internal server error response has a 2xx status code
func (o *GetHostGroupsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get host groups internal server error response has a 3xx status code
func (o *GetHostGroupsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get host groups internal server error response has a 4xx status code
func (o *GetHostGroupsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get host groups internal server error response has a 5xx status code
func (o *GetHostGroupsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get host groups internal server error response a status code equal to that given
func (o *GetHostGroupsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get host groups internal server error response
func (o *GetHostGroupsInternalServerError) Code() int {
	return 500
}

func (o *GetHostGroupsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /devices/entities/host-groups/v1][%d] getHostGroupsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetHostGroupsInternalServerError) String() string {
	return fmt.Sprintf("[GET /devices/entities/host-groups/v1][%d] getHostGroupsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetHostGroupsInternalServerError) GetPayload() *models.HostGroupsRespV1 {
	return o.Payload
}

func (o *GetHostGroupsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.HostGroupsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
