// Code generated by go-swagger; DO NOT EDIT.

package host_group

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// PerformGroupActionReader is a Reader for the PerformGroupAction structure.
type PerformGroupActionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PerformGroupActionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPerformGroupActionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPerformGroupActionBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewPerformGroupActionForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewPerformGroupActionNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewPerformGroupActionTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPerformGroupActionInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /devices/entities/host-group-actions/v1] performGroupAction", response, response.Code())
	}
}

// NewPerformGroupActionOK creates a PerformGroupActionOK with default headers values
func NewPerformGroupActionOK() *PerformGroupActionOK {
	return &PerformGroupActionOK{}
}

/*
PerformGroupActionOK describes a response with status code 200, with default header values.

OK
*/
type PerformGroupActionOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.HostGroupsRespV1
}

// IsSuccess returns true when this perform group action o k response has a 2xx status code
func (o *PerformGroupActionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this perform group action o k response has a 3xx status code
func (o *PerformGroupActionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform group action o k response has a 4xx status code
func (o *PerformGroupActionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this perform group action o k response has a 5xx status code
func (o *PerformGroupActionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this perform group action o k response a status code equal to that given
func (o *PerformGroupActionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the perform group action o k response
func (o *PerformGroupActionOK) Code() int {
	return 200
}

func (o *PerformGroupActionOK) Error() string {
	return fmt.Sprintf("[POST /devices/entities/host-group-actions/v1][%d] performGroupActionOK  %+v", 200, o.Payload)
}

func (o *PerformGroupActionOK) String() string {
	return fmt.Sprintf("[POST /devices/entities/host-group-actions/v1][%d] performGroupActionOK  %+v", 200, o.Payload)
}

func (o *PerformGroupActionOK) GetPayload() *models.HostGroupsRespV1 {
	return o.Payload
}

func (o *PerformGroupActionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.HostGroupsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformGroupActionBadRequest creates a PerformGroupActionBadRequest with default headers values
func NewPerformGroupActionBadRequest() *PerformGroupActionBadRequest {
	return &PerformGroupActionBadRequest{}
}

/*
PerformGroupActionBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type PerformGroupActionBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.HostGroupsRespV1
}

// IsSuccess returns true when this perform group action bad request response has a 2xx status code
func (o *PerformGroupActionBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform group action bad request response has a 3xx status code
func (o *PerformGroupActionBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform group action bad request response has a 4xx status code
func (o *PerformGroupActionBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this perform group action bad request response has a 5xx status code
func (o *PerformGroupActionBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this perform group action bad request response a status code equal to that given
func (o *PerformGroupActionBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the perform group action bad request response
func (o *PerformGroupActionBadRequest) Code() int {
	return 400
}

func (o *PerformGroupActionBadRequest) Error() string {
	return fmt.Sprintf("[POST /devices/entities/host-group-actions/v1][%d] performGroupActionBadRequest  %+v", 400, o.Payload)
}

func (o *PerformGroupActionBadRequest) String() string {
	return fmt.Sprintf("[POST /devices/entities/host-group-actions/v1][%d] performGroupActionBadRequest  %+v", 400, o.Payload)
}

func (o *PerformGroupActionBadRequest) GetPayload() *models.HostGroupsRespV1 {
	return o.Payload
}

func (o *PerformGroupActionBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.HostGroupsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformGroupActionForbidden creates a PerformGroupActionForbidden with default headers values
func NewPerformGroupActionForbidden() *PerformGroupActionForbidden {
	return &PerformGroupActionForbidden{}
}

/*
PerformGroupActionForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type PerformGroupActionForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this perform group action forbidden response has a 2xx status code
func (o *PerformGroupActionForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform group action forbidden response has a 3xx status code
func (o *PerformGroupActionForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform group action forbidden response has a 4xx status code
func (o *PerformGroupActionForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this perform group action forbidden response has a 5xx status code
func (o *PerformGroupActionForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this perform group action forbidden response a status code equal to that given
func (o *PerformGroupActionForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the perform group action forbidden response
func (o *PerformGroupActionForbidden) Code() int {
	return 403
}

func (o *PerformGroupActionForbidden) Error() string {
	return fmt.Sprintf("[POST /devices/entities/host-group-actions/v1][%d] performGroupActionForbidden  %+v", 403, o.Payload)
}

func (o *PerformGroupActionForbidden) String() string {
	return fmt.Sprintf("[POST /devices/entities/host-group-actions/v1][%d] performGroupActionForbidden  %+v", 403, o.Payload)
}

func (o *PerformGroupActionForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *PerformGroupActionForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformGroupActionNotFound creates a PerformGroupActionNotFound with default headers values
func NewPerformGroupActionNotFound() *PerformGroupActionNotFound {
	return &PerformGroupActionNotFound{}
}

/*
PerformGroupActionNotFound describes a response with status code 404, with default header values.

Not Found
*/
type PerformGroupActionNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.HostGroupsRespV1
}

// IsSuccess returns true when this perform group action not found response has a 2xx status code
func (o *PerformGroupActionNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform group action not found response has a 3xx status code
func (o *PerformGroupActionNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform group action not found response has a 4xx status code
func (o *PerformGroupActionNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this perform group action not found response has a 5xx status code
func (o *PerformGroupActionNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this perform group action not found response a status code equal to that given
func (o *PerformGroupActionNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the perform group action not found response
func (o *PerformGroupActionNotFound) Code() int {
	return 404
}

func (o *PerformGroupActionNotFound) Error() string {
	return fmt.Sprintf("[POST /devices/entities/host-group-actions/v1][%d] performGroupActionNotFound  %+v", 404, o.Payload)
}

func (o *PerformGroupActionNotFound) String() string {
	return fmt.Sprintf("[POST /devices/entities/host-group-actions/v1][%d] performGroupActionNotFound  %+v", 404, o.Payload)
}

func (o *PerformGroupActionNotFound) GetPayload() *models.HostGroupsRespV1 {
	return o.Payload
}

func (o *PerformGroupActionNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.HostGroupsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformGroupActionTooManyRequests creates a PerformGroupActionTooManyRequests with default headers values
func NewPerformGroupActionTooManyRequests() *PerformGroupActionTooManyRequests {
	return &PerformGroupActionTooManyRequests{}
}

/*
PerformGroupActionTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type PerformGroupActionTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this perform group action too many requests response has a 2xx status code
func (o *PerformGroupActionTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform group action too many requests response has a 3xx status code
func (o *PerformGroupActionTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform group action too many requests response has a 4xx status code
func (o *PerformGroupActionTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this perform group action too many requests response has a 5xx status code
func (o *PerformGroupActionTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this perform group action too many requests response a status code equal to that given
func (o *PerformGroupActionTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the perform group action too many requests response
func (o *PerformGroupActionTooManyRequests) Code() int {
	return 429
}

func (o *PerformGroupActionTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /devices/entities/host-group-actions/v1][%d] performGroupActionTooManyRequests  %+v", 429, o.Payload)
}

func (o *PerformGroupActionTooManyRequests) String() string {
	return fmt.Sprintf("[POST /devices/entities/host-group-actions/v1][%d] performGroupActionTooManyRequests  %+v", 429, o.Payload)
}

func (o *PerformGroupActionTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *PerformGroupActionTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformGroupActionInternalServerError creates a PerformGroupActionInternalServerError with default headers values
func NewPerformGroupActionInternalServerError() *PerformGroupActionInternalServerError {
	return &PerformGroupActionInternalServerError{}
}

/*
PerformGroupActionInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type PerformGroupActionInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.HostGroupsRespV1
}

// IsSuccess returns true when this perform group action internal server error response has a 2xx status code
func (o *PerformGroupActionInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform group action internal server error response has a 3xx status code
func (o *PerformGroupActionInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform group action internal server error response has a 4xx status code
func (o *PerformGroupActionInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this perform group action internal server error response has a 5xx status code
func (o *PerformGroupActionInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this perform group action internal server error response a status code equal to that given
func (o *PerformGroupActionInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the perform group action internal server error response
func (o *PerformGroupActionInternalServerError) Code() int {
	return 500
}

func (o *PerformGroupActionInternalServerError) Error() string {
	return fmt.Sprintf("[POST /devices/entities/host-group-actions/v1][%d] performGroupActionInternalServerError  %+v", 500, o.Payload)
}

func (o *PerformGroupActionInternalServerError) String() string {
	return fmt.Sprintf("[POST /devices/entities/host-group-actions/v1][%d] performGroupActionInternalServerError  %+v", 500, o.Payload)
}

func (o *PerformGroupActionInternalServerError) GetPayload() *models.HostGroupsRespV1 {
	return o.Payload
}

func (o *PerformGroupActionInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.HostGroupsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
