// Code generated by go-swagger; DO NOT EDIT.

package host_group

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryCombinedGroupMembersParams creates a new QueryCombinedGroupMembersParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryCombinedGroupMembersParams() *QueryCombinedGroupMembersParams {
	return &QueryCombinedGroupMembersParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryCombinedGroupMembersParamsWithTimeout creates a new QueryCombinedGroupMembersParams object
// with the ability to set a timeout on a request.
func NewQueryCombinedGroupMembersParamsWithTimeout(timeout time.Duration) *QueryCombinedGroupMembersParams {
	return &QueryCombinedGroupMembersParams{
		timeout: timeout,
	}
}

// NewQueryCombinedGroupMembersParamsWithContext creates a new QueryCombinedGroupMembersParams object
// with the ability to set a context for a request.
func NewQueryCombinedGroupMembersParamsWithContext(ctx context.Context) *QueryCombinedGroupMembersParams {
	return &QueryCombinedGroupMembersParams{
		Context: ctx,
	}
}

// NewQueryCombinedGroupMembersParamsWithHTTPClient creates a new QueryCombinedGroupMembersParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryCombinedGroupMembersParamsWithHTTPClient(client *http.Client) *QueryCombinedGroupMembersParams {
	return &QueryCombinedGroupMembersParams{
		HTTPClient: client,
	}
}

/*
QueryCombinedGroupMembersParams contains all the parameters to send to the API endpoint

	for the query combined group members operation.

	Typically these are written to a http.Request.
*/
type QueryCombinedGroupMembersParams struct {

	/* Filter.

	   The filter expression that should be used to limit the results
	*/
	Filter *string

	/* ID.

	   The ID of the Host Group to search for members of
	*/
	ID *string

	/* Limit.

	   The maximum records to return. [1-5000]
	*/
	Limit *int64

	/* Offset.

	   The offset to start retrieving records from
	*/
	Offset *int64

	/* Sort.

	   The property to sort by
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query combined group members params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryCombinedGroupMembersParams) WithDefaults() *QueryCombinedGroupMembersParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query combined group members params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryCombinedGroupMembersParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query combined group members params
func (o *QueryCombinedGroupMembersParams) WithTimeout(timeout time.Duration) *QueryCombinedGroupMembersParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query combined group members params
func (o *QueryCombinedGroupMembersParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query combined group members params
func (o *QueryCombinedGroupMembersParams) WithContext(ctx context.Context) *QueryCombinedGroupMembersParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query combined group members params
func (o *QueryCombinedGroupMembersParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query combined group members params
func (o *QueryCombinedGroupMembersParams) WithHTTPClient(client *http.Client) *QueryCombinedGroupMembersParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query combined group members params
func (o *QueryCombinedGroupMembersParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query combined group members params
func (o *QueryCombinedGroupMembersParams) WithFilter(filter *string) *QueryCombinedGroupMembersParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query combined group members params
func (o *QueryCombinedGroupMembersParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithID adds the id to the query combined group members params
func (o *QueryCombinedGroupMembersParams) WithID(id *string) *QueryCombinedGroupMembersParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the query combined group members params
func (o *QueryCombinedGroupMembersParams) SetID(id *string) {
	o.ID = id
}

// WithLimit adds the limit to the query combined group members params
func (o *QueryCombinedGroupMembersParams) WithLimit(limit *int64) *QueryCombinedGroupMembersParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query combined group members params
func (o *QueryCombinedGroupMembersParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query combined group members params
func (o *QueryCombinedGroupMembersParams) WithOffset(offset *int64) *QueryCombinedGroupMembersParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query combined group members params
func (o *QueryCombinedGroupMembersParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithSort adds the sort to the query combined group members params
func (o *QueryCombinedGroupMembersParams) WithSort(sort *string) *QueryCombinedGroupMembersParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query combined group members params
func (o *QueryCombinedGroupMembersParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryCombinedGroupMembersParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.ID != nil {

		// query param id
		var qrID string

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := qrID
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
