// Code generated by go-swagger; DO NOT EDIT.

package host_group

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryCombinedHostGroupsReader is a Reader for the QueryCombinedHostGroups structure.
type QueryCombinedHostGroupsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryCombinedHostGroupsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryCombinedHostGroupsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryCombinedHostGroupsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryCombinedHostGroupsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryCombinedHostGroupsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryCombinedHostGroupsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /devices/combined/host-groups/v1] queryCombinedHostGroups", response, response.Code())
	}
}

// NewQueryCombinedHostGroupsOK creates a QueryCombinedHostGroupsOK with default headers values
func NewQueryCombinedHostGroupsOK() *QueryCombinedHostGroupsOK {
	return &QueryCombinedHostGroupsOK{}
}

/*
QueryCombinedHostGroupsOK describes a response with status code 200, with default header values.

OK
*/
type QueryCombinedHostGroupsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.HostGroupsRespV1
}

// IsSuccess returns true when this query combined host groups o k response has a 2xx status code
func (o *QueryCombinedHostGroupsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query combined host groups o k response has a 3xx status code
func (o *QueryCombinedHostGroupsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined host groups o k response has a 4xx status code
func (o *QueryCombinedHostGroupsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query combined host groups o k response has a 5xx status code
func (o *QueryCombinedHostGroupsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined host groups o k response a status code equal to that given
func (o *QueryCombinedHostGroupsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query combined host groups o k response
func (o *QueryCombinedHostGroupsOK) Code() int {
	return 200
}

func (o *QueryCombinedHostGroupsOK) Error() string {
	return fmt.Sprintf("[GET /devices/combined/host-groups/v1][%d] queryCombinedHostGroupsOK  %+v", 200, o.Payload)
}

func (o *QueryCombinedHostGroupsOK) String() string {
	return fmt.Sprintf("[GET /devices/combined/host-groups/v1][%d] queryCombinedHostGroupsOK  %+v", 200, o.Payload)
}

func (o *QueryCombinedHostGroupsOK) GetPayload() *models.HostGroupsRespV1 {
	return o.Payload
}

func (o *QueryCombinedHostGroupsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.HostGroupsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedHostGroupsBadRequest creates a QueryCombinedHostGroupsBadRequest with default headers values
func NewQueryCombinedHostGroupsBadRequest() *QueryCombinedHostGroupsBadRequest {
	return &QueryCombinedHostGroupsBadRequest{}
}

/*
QueryCombinedHostGroupsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryCombinedHostGroupsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.HostGroupsRespV1
}

// IsSuccess returns true when this query combined host groups bad request response has a 2xx status code
func (o *QueryCombinedHostGroupsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined host groups bad request response has a 3xx status code
func (o *QueryCombinedHostGroupsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined host groups bad request response has a 4xx status code
func (o *QueryCombinedHostGroupsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined host groups bad request response has a 5xx status code
func (o *QueryCombinedHostGroupsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined host groups bad request response a status code equal to that given
func (o *QueryCombinedHostGroupsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query combined host groups bad request response
func (o *QueryCombinedHostGroupsBadRequest) Code() int {
	return 400
}

func (o *QueryCombinedHostGroupsBadRequest) Error() string {
	return fmt.Sprintf("[GET /devices/combined/host-groups/v1][%d] queryCombinedHostGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryCombinedHostGroupsBadRequest) String() string {
	return fmt.Sprintf("[GET /devices/combined/host-groups/v1][%d] queryCombinedHostGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryCombinedHostGroupsBadRequest) GetPayload() *models.HostGroupsRespV1 {
	return o.Payload
}

func (o *QueryCombinedHostGroupsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.HostGroupsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedHostGroupsForbidden creates a QueryCombinedHostGroupsForbidden with default headers values
func NewQueryCombinedHostGroupsForbidden() *QueryCombinedHostGroupsForbidden {
	return &QueryCombinedHostGroupsForbidden{}
}

/*
QueryCombinedHostGroupsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryCombinedHostGroupsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query combined host groups forbidden response has a 2xx status code
func (o *QueryCombinedHostGroupsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined host groups forbidden response has a 3xx status code
func (o *QueryCombinedHostGroupsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined host groups forbidden response has a 4xx status code
func (o *QueryCombinedHostGroupsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined host groups forbidden response has a 5xx status code
func (o *QueryCombinedHostGroupsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined host groups forbidden response a status code equal to that given
func (o *QueryCombinedHostGroupsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query combined host groups forbidden response
func (o *QueryCombinedHostGroupsForbidden) Code() int {
	return 403
}

func (o *QueryCombinedHostGroupsForbidden) Error() string {
	return fmt.Sprintf("[GET /devices/combined/host-groups/v1][%d] queryCombinedHostGroupsForbidden  %+v", 403, o.Payload)
}

func (o *QueryCombinedHostGroupsForbidden) String() string {
	return fmt.Sprintf("[GET /devices/combined/host-groups/v1][%d] queryCombinedHostGroupsForbidden  %+v", 403, o.Payload)
}

func (o *QueryCombinedHostGroupsForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryCombinedHostGroupsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedHostGroupsTooManyRequests creates a QueryCombinedHostGroupsTooManyRequests with default headers values
func NewQueryCombinedHostGroupsTooManyRequests() *QueryCombinedHostGroupsTooManyRequests {
	return &QueryCombinedHostGroupsTooManyRequests{}
}

/*
QueryCombinedHostGroupsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryCombinedHostGroupsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query combined host groups too many requests response has a 2xx status code
func (o *QueryCombinedHostGroupsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined host groups too many requests response has a 3xx status code
func (o *QueryCombinedHostGroupsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined host groups too many requests response has a 4xx status code
func (o *QueryCombinedHostGroupsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined host groups too many requests response has a 5xx status code
func (o *QueryCombinedHostGroupsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined host groups too many requests response a status code equal to that given
func (o *QueryCombinedHostGroupsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query combined host groups too many requests response
func (o *QueryCombinedHostGroupsTooManyRequests) Code() int {
	return 429
}

func (o *QueryCombinedHostGroupsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /devices/combined/host-groups/v1][%d] queryCombinedHostGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCombinedHostGroupsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /devices/combined/host-groups/v1][%d] queryCombinedHostGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCombinedHostGroupsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryCombinedHostGroupsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedHostGroupsInternalServerError creates a QueryCombinedHostGroupsInternalServerError with default headers values
func NewQueryCombinedHostGroupsInternalServerError() *QueryCombinedHostGroupsInternalServerError {
	return &QueryCombinedHostGroupsInternalServerError{}
}

/*
QueryCombinedHostGroupsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryCombinedHostGroupsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.HostGroupsRespV1
}

// IsSuccess returns true when this query combined host groups internal server error response has a 2xx status code
func (o *QueryCombinedHostGroupsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined host groups internal server error response has a 3xx status code
func (o *QueryCombinedHostGroupsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined host groups internal server error response has a 4xx status code
func (o *QueryCombinedHostGroupsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query combined host groups internal server error response has a 5xx status code
func (o *QueryCombinedHostGroupsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query combined host groups internal server error response a status code equal to that given
func (o *QueryCombinedHostGroupsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query combined host groups internal server error response
func (o *QueryCombinedHostGroupsInternalServerError) Code() int {
	return 500
}

func (o *QueryCombinedHostGroupsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /devices/combined/host-groups/v1][%d] queryCombinedHostGroupsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryCombinedHostGroupsInternalServerError) String() string {
	return fmt.Sprintf("[GET /devices/combined/host-groups/v1][%d] queryCombinedHostGroupsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryCombinedHostGroupsInternalServerError) GetPayload() *models.HostGroupsRespV1 {
	return o.Payload
}

func (o *QueryCombinedHostGroupsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.HostGroupsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
