// Code generated by go-swagger; DO NOT EDIT.

package host_group

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateHostGroupsReader is a Reader for the UpdateHostGroups structure.
type UpdateHostGroupsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateHostGroupsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateHostGroupsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateHostGroupsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateHostGroupsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateHostGroupsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateHostGroupsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateHostGroupsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /devices/entities/host-groups/v1] updateHostGroups", response, response.Code())
	}
}

// NewUpdateHostGroupsOK creates a UpdateHostGroupsOK with default headers values
func NewUpdateHostGroupsOK() *UpdateHostGroupsOK {
	return &UpdateHostGroupsOK{}
}

/*
UpdateHostGroupsOK describes a response with status code 200, with default header values.

OK
*/
type UpdateHostGroupsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.HostGroupsRespV1
}

// IsSuccess returns true when this update host groups o k response has a 2xx status code
func (o *UpdateHostGroupsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update host groups o k response has a 3xx status code
func (o *UpdateHostGroupsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update host groups o k response has a 4xx status code
func (o *UpdateHostGroupsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update host groups o k response has a 5xx status code
func (o *UpdateHostGroupsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update host groups o k response a status code equal to that given
func (o *UpdateHostGroupsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update host groups o k response
func (o *UpdateHostGroupsOK) Code() int {
	return 200
}

func (o *UpdateHostGroupsOK) Error() string {
	return fmt.Sprintf("[PATCH /devices/entities/host-groups/v1][%d] updateHostGroupsOK  %+v", 200, o.Payload)
}

func (o *UpdateHostGroupsOK) String() string {
	return fmt.Sprintf("[PATCH /devices/entities/host-groups/v1][%d] updateHostGroupsOK  %+v", 200, o.Payload)
}

func (o *UpdateHostGroupsOK) GetPayload() *models.HostGroupsRespV1 {
	return o.Payload
}

func (o *UpdateHostGroupsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.HostGroupsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateHostGroupsBadRequest creates a UpdateHostGroupsBadRequest with default headers values
func NewUpdateHostGroupsBadRequest() *UpdateHostGroupsBadRequest {
	return &UpdateHostGroupsBadRequest{}
}

/*
UpdateHostGroupsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdateHostGroupsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.HostGroupsRespV1
}

// IsSuccess returns true when this update host groups bad request response has a 2xx status code
func (o *UpdateHostGroupsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update host groups bad request response has a 3xx status code
func (o *UpdateHostGroupsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update host groups bad request response has a 4xx status code
func (o *UpdateHostGroupsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update host groups bad request response has a 5xx status code
func (o *UpdateHostGroupsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update host groups bad request response a status code equal to that given
func (o *UpdateHostGroupsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update host groups bad request response
func (o *UpdateHostGroupsBadRequest) Code() int {
	return 400
}

func (o *UpdateHostGroupsBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /devices/entities/host-groups/v1][%d] updateHostGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateHostGroupsBadRequest) String() string {
	return fmt.Sprintf("[PATCH /devices/entities/host-groups/v1][%d] updateHostGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateHostGroupsBadRequest) GetPayload() *models.HostGroupsRespV1 {
	return o.Payload
}

func (o *UpdateHostGroupsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.HostGroupsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateHostGroupsForbidden creates a UpdateHostGroupsForbidden with default headers values
func NewUpdateHostGroupsForbidden() *UpdateHostGroupsForbidden {
	return &UpdateHostGroupsForbidden{}
}

/*
UpdateHostGroupsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateHostGroupsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this update host groups forbidden response has a 2xx status code
func (o *UpdateHostGroupsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update host groups forbidden response has a 3xx status code
func (o *UpdateHostGroupsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update host groups forbidden response has a 4xx status code
func (o *UpdateHostGroupsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update host groups forbidden response has a 5xx status code
func (o *UpdateHostGroupsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update host groups forbidden response a status code equal to that given
func (o *UpdateHostGroupsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update host groups forbidden response
func (o *UpdateHostGroupsForbidden) Code() int {
	return 403
}

func (o *UpdateHostGroupsForbidden) Error() string {
	return fmt.Sprintf("[PATCH /devices/entities/host-groups/v1][%d] updateHostGroupsForbidden  %+v", 403, o.Payload)
}

func (o *UpdateHostGroupsForbidden) String() string {
	return fmt.Sprintf("[PATCH /devices/entities/host-groups/v1][%d] updateHostGroupsForbidden  %+v", 403, o.Payload)
}

func (o *UpdateHostGroupsForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *UpdateHostGroupsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateHostGroupsNotFound creates a UpdateHostGroupsNotFound with default headers values
func NewUpdateHostGroupsNotFound() *UpdateHostGroupsNotFound {
	return &UpdateHostGroupsNotFound{}
}

/*
UpdateHostGroupsNotFound describes a response with status code 404, with default header values.

Not Found
*/
type UpdateHostGroupsNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.HostGroupsRespV1
}

// IsSuccess returns true when this update host groups not found response has a 2xx status code
func (o *UpdateHostGroupsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update host groups not found response has a 3xx status code
func (o *UpdateHostGroupsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update host groups not found response has a 4xx status code
func (o *UpdateHostGroupsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this update host groups not found response has a 5xx status code
func (o *UpdateHostGroupsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this update host groups not found response a status code equal to that given
func (o *UpdateHostGroupsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the update host groups not found response
func (o *UpdateHostGroupsNotFound) Code() int {
	return 404
}

func (o *UpdateHostGroupsNotFound) Error() string {
	return fmt.Sprintf("[PATCH /devices/entities/host-groups/v1][%d] updateHostGroupsNotFound  %+v", 404, o.Payload)
}

func (o *UpdateHostGroupsNotFound) String() string {
	return fmt.Sprintf("[PATCH /devices/entities/host-groups/v1][%d] updateHostGroupsNotFound  %+v", 404, o.Payload)
}

func (o *UpdateHostGroupsNotFound) GetPayload() *models.HostGroupsRespV1 {
	return o.Payload
}

func (o *UpdateHostGroupsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.HostGroupsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateHostGroupsTooManyRequests creates a UpdateHostGroupsTooManyRequests with default headers values
func NewUpdateHostGroupsTooManyRequests() *UpdateHostGroupsTooManyRequests {
	return &UpdateHostGroupsTooManyRequests{}
}

/*
UpdateHostGroupsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateHostGroupsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update host groups too many requests response has a 2xx status code
func (o *UpdateHostGroupsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update host groups too many requests response has a 3xx status code
func (o *UpdateHostGroupsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update host groups too many requests response has a 4xx status code
func (o *UpdateHostGroupsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update host groups too many requests response has a 5xx status code
func (o *UpdateHostGroupsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update host groups too many requests response a status code equal to that given
func (o *UpdateHostGroupsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update host groups too many requests response
func (o *UpdateHostGroupsTooManyRequests) Code() int {
	return 429
}

func (o *UpdateHostGroupsTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /devices/entities/host-groups/v1][%d] updateHostGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateHostGroupsTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /devices/entities/host-groups/v1][%d] updateHostGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateHostGroupsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateHostGroupsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateHostGroupsInternalServerError creates a UpdateHostGroupsInternalServerError with default headers values
func NewUpdateHostGroupsInternalServerError() *UpdateHostGroupsInternalServerError {
	return &UpdateHostGroupsInternalServerError{}
}

/*
UpdateHostGroupsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type UpdateHostGroupsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.HostGroupsRespV1
}

// IsSuccess returns true when this update host groups internal server error response has a 2xx status code
func (o *UpdateHostGroupsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update host groups internal server error response has a 3xx status code
func (o *UpdateHostGroupsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update host groups internal server error response has a 4xx status code
func (o *UpdateHostGroupsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update host groups internal server error response has a 5xx status code
func (o *UpdateHostGroupsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update host groups internal server error response a status code equal to that given
func (o *UpdateHostGroupsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update host groups internal server error response
func (o *UpdateHostGroupsInternalServerError) Code() int {
	return 500
}

func (o *UpdateHostGroupsInternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /devices/entities/host-groups/v1][%d] updateHostGroupsInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateHostGroupsInternalServerError) String() string {
	return fmt.Sprintf("[PATCH /devices/entities/host-groups/v1][%d] updateHostGroupsInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateHostGroupsInternalServerError) GetPayload() *models.HostGroupsRespV1 {
	return o.Payload
}

func (o *UpdateHostGroupsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.HostGroupsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
