// Code generated by go-swagger; DO NOT EDIT.

package hosts

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewEntitiesPerformActionParams creates a new EntitiesPerformActionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewEntitiesPerformActionParams() *EntitiesPerformActionParams {
	return &EntitiesPerformActionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewEntitiesPerformActionParamsWithTimeout creates a new EntitiesPerformActionParams object
// with the ability to set a timeout on a request.
func NewEntitiesPerformActionParamsWithTimeout(timeout time.Duration) *EntitiesPerformActionParams {
	return &EntitiesPerformActionParams{
		timeout: timeout,
	}
}

// NewEntitiesPerformActionParamsWithContext creates a new EntitiesPerformActionParams object
// with the ability to set a context for a request.
func NewEntitiesPerformActionParamsWithContext(ctx context.Context) *EntitiesPerformActionParams {
	return &EntitiesPerformActionParams{
		Context: ctx,
	}
}

// NewEntitiesPerformActionParamsWithHTTPClient creates a new EntitiesPerformActionParams object
// with the ability to set a custom HTTPClient for a request.
func NewEntitiesPerformActionParamsWithHTTPClient(client *http.Client) *EntitiesPerformActionParams {
	return &EntitiesPerformActionParams{
		HTTPClient: client,
	}
}

/*
EntitiesPerformActionParams contains all the parameters to send to the API endpoint

	for the entities perform action operation.

	Typically these are written to a http.Request.
*/
type EntitiesPerformActionParams struct {

	/* ActionName.

	   The action to perform.
	*/
	ActionName string

	// Body.
	Body *models.MsaEntityActionRequest

	/* DisableHostnameCheck.

	   Bool to disable hostname check on add-member
	*/
	DisableHostnameCheck *bool

	/* Ids.

	   The group ids to act on
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the entities perform action params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EntitiesPerformActionParams) WithDefaults() *EntitiesPerformActionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the entities perform action params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EntitiesPerformActionParams) SetDefaults() {
	var (
		disableHostnameCheckDefault = bool(false)
	)

	val := EntitiesPerformActionParams{
		DisableHostnameCheck: &disableHostnameCheckDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the entities perform action params
func (o *EntitiesPerformActionParams) WithTimeout(timeout time.Duration) *EntitiesPerformActionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the entities perform action params
func (o *EntitiesPerformActionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the entities perform action params
func (o *EntitiesPerformActionParams) WithContext(ctx context.Context) *EntitiesPerformActionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the entities perform action params
func (o *EntitiesPerformActionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the entities perform action params
func (o *EntitiesPerformActionParams) WithHTTPClient(client *http.Client) *EntitiesPerformActionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the entities perform action params
func (o *EntitiesPerformActionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithActionName adds the actionName to the entities perform action params
func (o *EntitiesPerformActionParams) WithActionName(actionName string) *EntitiesPerformActionParams {
	o.SetActionName(actionName)
	return o
}

// SetActionName adds the actionName to the entities perform action params
func (o *EntitiesPerformActionParams) SetActionName(actionName string) {
	o.ActionName = actionName
}

// WithBody adds the body to the entities perform action params
func (o *EntitiesPerformActionParams) WithBody(body *models.MsaEntityActionRequest) *EntitiesPerformActionParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the entities perform action params
func (o *EntitiesPerformActionParams) SetBody(body *models.MsaEntityActionRequest) {
	o.Body = body
}

// WithDisableHostnameCheck adds the disableHostnameCheck to the entities perform action params
func (o *EntitiesPerformActionParams) WithDisableHostnameCheck(disableHostnameCheck *bool) *EntitiesPerformActionParams {
	o.SetDisableHostnameCheck(disableHostnameCheck)
	return o
}

// SetDisableHostnameCheck adds the disableHostnameCheck to the entities perform action params
func (o *EntitiesPerformActionParams) SetDisableHostnameCheck(disableHostnameCheck *bool) {
	o.DisableHostnameCheck = disableHostnameCheck
}

// WithIds adds the ids to the entities perform action params
func (o *EntitiesPerformActionParams) WithIds(ids []string) *EntitiesPerformActionParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the entities perform action params
func (o *EntitiesPerformActionParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *EntitiesPerformActionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param action_name
	qrActionName := o.ActionName
	qActionName := qrActionName
	if qActionName != "" {

		if err := r.SetQueryParam("action_name", qActionName); err != nil {
			return err
		}
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.DisableHostnameCheck != nil {

		// query param disable_hostname_check
		var qrDisableHostnameCheck bool

		if o.DisableHostnameCheck != nil {
			qrDisableHostnameCheck = *o.DisableHostnameCheck
		}
		qDisableHostnameCheck := swag.FormatBool(qrDisableHostnameCheck)
		if qDisableHostnameCheck != "" {

			if err := r.SetQueryParam("disable_hostname_check", qDisableHostnameCheck); err != nil {
				return err
			}
		}
	}

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamEntitiesPerformAction binds the parameter ids
func (o *EntitiesPerformActionParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
