// Code generated by go-swagger; DO NOT EDIT.

package hosts

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// EntitiesPerformActionReader is a Reader for the EntitiesPerformAction structure.
type EntitiesPerformActionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *EntitiesPerformActionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewEntitiesPerformActionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewEntitiesPerformActionForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewEntitiesPerformActionTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /devices/entities/group-actions/v1] entities.perform_action", response, response.Code())
	}
}

// NewEntitiesPerformActionOK creates a EntitiesPerformActionOK with default headers values
func NewEntitiesPerformActionOK() *EntitiesPerformActionOK {
	return &EntitiesPerformActionOK{}
}

/*
EntitiesPerformActionOK describes a response with status code 200, with default header values.

OK
*/
type EntitiesPerformActionOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DeviceapiGroupsResponseV1
}

// IsSuccess returns true when this entities perform action o k response has a 2xx status code
func (o *EntitiesPerformActionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this entities perform action o k response has a 3xx status code
func (o *EntitiesPerformActionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this entities perform action o k response has a 4xx status code
func (o *EntitiesPerformActionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this entities perform action o k response has a 5xx status code
func (o *EntitiesPerformActionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this entities perform action o k response a status code equal to that given
func (o *EntitiesPerformActionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the entities perform action o k response
func (o *EntitiesPerformActionOK) Code() int {
	return 200
}

func (o *EntitiesPerformActionOK) Error() string {
	return fmt.Sprintf("[POST /devices/entities/group-actions/v1][%d] entitiesPerformActionOK  %+v", 200, o.Payload)
}

func (o *EntitiesPerformActionOK) String() string {
	return fmt.Sprintf("[POST /devices/entities/group-actions/v1][%d] entitiesPerformActionOK  %+v", 200, o.Payload)
}

func (o *EntitiesPerformActionOK) GetPayload() *models.DeviceapiGroupsResponseV1 {
	return o.Payload
}

func (o *EntitiesPerformActionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DeviceapiGroupsResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewEntitiesPerformActionForbidden creates a EntitiesPerformActionForbidden with default headers values
func NewEntitiesPerformActionForbidden() *EntitiesPerformActionForbidden {
	return &EntitiesPerformActionForbidden{}
}

/*
EntitiesPerformActionForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type EntitiesPerformActionForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this entities perform action forbidden response has a 2xx status code
func (o *EntitiesPerformActionForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this entities perform action forbidden response has a 3xx status code
func (o *EntitiesPerformActionForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this entities perform action forbidden response has a 4xx status code
func (o *EntitiesPerformActionForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this entities perform action forbidden response has a 5xx status code
func (o *EntitiesPerformActionForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this entities perform action forbidden response a status code equal to that given
func (o *EntitiesPerformActionForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the entities perform action forbidden response
func (o *EntitiesPerformActionForbidden) Code() int {
	return 403
}

func (o *EntitiesPerformActionForbidden) Error() string {
	return fmt.Sprintf("[POST /devices/entities/group-actions/v1][%d] entitiesPerformActionForbidden  %+v", 403, o.Payload)
}

func (o *EntitiesPerformActionForbidden) String() string {
	return fmt.Sprintf("[POST /devices/entities/group-actions/v1][%d] entitiesPerformActionForbidden  %+v", 403, o.Payload)
}

func (o *EntitiesPerformActionForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *EntitiesPerformActionForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewEntitiesPerformActionTooManyRequests creates a EntitiesPerformActionTooManyRequests with default headers values
func NewEntitiesPerformActionTooManyRequests() *EntitiesPerformActionTooManyRequests {
	return &EntitiesPerformActionTooManyRequests{}
}

/*
EntitiesPerformActionTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type EntitiesPerformActionTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this entities perform action too many requests response has a 2xx status code
func (o *EntitiesPerformActionTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this entities perform action too many requests response has a 3xx status code
func (o *EntitiesPerformActionTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this entities perform action too many requests response has a 4xx status code
func (o *EntitiesPerformActionTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this entities perform action too many requests response has a 5xx status code
func (o *EntitiesPerformActionTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this entities perform action too many requests response a status code equal to that given
func (o *EntitiesPerformActionTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the entities perform action too many requests response
func (o *EntitiesPerformActionTooManyRequests) Code() int {
	return 429
}

func (o *EntitiesPerformActionTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /devices/entities/group-actions/v1][%d] entitiesPerformActionTooManyRequests  %+v", 429, o.Payload)
}

func (o *EntitiesPerformActionTooManyRequests) String() string {
	return fmt.Sprintf("[POST /devices/entities/group-actions/v1][%d] entitiesPerformActionTooManyRequests  %+v", 429, o.Payload)
}

func (o *EntitiesPerformActionTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *EntitiesPerformActionTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
