// Code generated by go-swagger; DO NOT EDIT.

package hosts

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetOnlineStateV1Params creates a new GetOnlineStateV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetOnlineStateV1Params() *GetOnlineStateV1Params {
	return &GetOnlineStateV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetOnlineStateV1ParamsWithTimeout creates a new GetOnlineStateV1Params object
// with the ability to set a timeout on a request.
func NewGetOnlineStateV1ParamsWithTimeout(timeout time.Duration) *GetOnlineStateV1Params {
	return &GetOnlineStateV1Params{
		timeout: timeout,
	}
}

// NewGetOnlineStateV1ParamsWithContext creates a new GetOnlineStateV1Params object
// with the ability to set a context for a request.
func NewGetOnlineStateV1ParamsWithContext(ctx context.Context) *GetOnlineStateV1Params {
	return &GetOnlineStateV1Params{
		Context: ctx,
	}
}

// NewGetOnlineStateV1ParamsWithHTTPClient creates a new GetOnlineStateV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewGetOnlineStateV1ParamsWithHTTPClient(client *http.Client) *GetOnlineStateV1Params {
	return &GetOnlineStateV1Params{
		HTTPClient: client,
	}
}

/*
GetOnlineStateV1Params contains all the parameters to send to the API endpoint

	for the get online state v1 operation.

	Typically these are written to a http.Request.
*/
type GetOnlineStateV1Params struct {

	/* Ids.

	   The unique ID of the host to get the online status of.
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get online state v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetOnlineStateV1Params) WithDefaults() *GetOnlineStateV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get online state v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetOnlineStateV1Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get online state v1 params
func (o *GetOnlineStateV1Params) WithTimeout(timeout time.Duration) *GetOnlineStateV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get online state v1 params
func (o *GetOnlineStateV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get online state v1 params
func (o *GetOnlineStateV1Params) WithContext(ctx context.Context) *GetOnlineStateV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get online state v1 params
func (o *GetOnlineStateV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get online state v1 params
func (o *GetOnlineStateV1Params) WithHTTPClient(client *http.Client) *GetOnlineStateV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get online state v1 params
func (o *GetOnlineStateV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get online state v1 params
func (o *GetOnlineStateV1Params) WithIds(ids []string) *GetOnlineStateV1Params {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get online state v1 params
func (o *GetOnlineStateV1Params) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetOnlineStateV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetOnlineStateV1 binds the parameter ids
func (o *GetOnlineStateV1Params) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
