// Code generated by go-swagger; DO NOT EDIT.

package hosts

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// PerformActionV2Reader is a Reader for the PerformActionV2 structure.
type PerformActionV2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PerformActionV2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 202:
		result := NewPerformActionV2Accepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPerformActionV2BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewPerformActionV2Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewPerformActionV2Conflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewPerformActionV2TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPerformActionV2InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /devices/entities/devices-actions/v2] PerformActionV2", response, response.Code())
	}
}

// NewPerformActionV2Accepted creates a PerformActionV2Accepted with default headers values
func NewPerformActionV2Accepted() *PerformActionV2Accepted {
	return &PerformActionV2Accepted{}
}

/*
PerformActionV2Accepted describes a response with status code 202, with default header values.

Accepted
*/
type PerformActionV2Accepted struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyAffectedEntities
}

// IsSuccess returns true when this perform action v2 accepted response has a 2xx status code
func (o *PerformActionV2Accepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this perform action v2 accepted response has a 3xx status code
func (o *PerformActionV2Accepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform action v2 accepted response has a 4xx status code
func (o *PerformActionV2Accepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this perform action v2 accepted response has a 5xx status code
func (o *PerformActionV2Accepted) IsServerError() bool {
	return false
}

// IsCode returns true when this perform action v2 accepted response a status code equal to that given
func (o *PerformActionV2Accepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the perform action v2 accepted response
func (o *PerformActionV2Accepted) Code() int {
	return 202
}

func (o *PerformActionV2Accepted) Error() string {
	return fmt.Sprintf("[POST /devices/entities/devices-actions/v2][%d] performActionV2Accepted  %+v", 202, o.Payload)
}

func (o *PerformActionV2Accepted) String() string {
	return fmt.Sprintf("[POST /devices/entities/devices-actions/v2][%d] performActionV2Accepted  %+v", 202, o.Payload)
}

func (o *PerformActionV2Accepted) GetPayload() *models.MsaReplyAffectedEntities {
	return o.Payload
}

func (o *PerformActionV2Accepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyAffectedEntities)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformActionV2BadRequest creates a PerformActionV2BadRequest with default headers values
func NewPerformActionV2BadRequest() *PerformActionV2BadRequest {
	return &PerformActionV2BadRequest{}
}

/*
PerformActionV2BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type PerformActionV2BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyAffectedEntities
}

// IsSuccess returns true when this perform action v2 bad request response has a 2xx status code
func (o *PerformActionV2BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform action v2 bad request response has a 3xx status code
func (o *PerformActionV2BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform action v2 bad request response has a 4xx status code
func (o *PerformActionV2BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this perform action v2 bad request response has a 5xx status code
func (o *PerformActionV2BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this perform action v2 bad request response a status code equal to that given
func (o *PerformActionV2BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the perform action v2 bad request response
func (o *PerformActionV2BadRequest) Code() int {
	return 400
}

func (o *PerformActionV2BadRequest) Error() string {
	return fmt.Sprintf("[POST /devices/entities/devices-actions/v2][%d] performActionV2BadRequest  %+v", 400, o.Payload)
}

func (o *PerformActionV2BadRequest) String() string {
	return fmt.Sprintf("[POST /devices/entities/devices-actions/v2][%d] performActionV2BadRequest  %+v", 400, o.Payload)
}

func (o *PerformActionV2BadRequest) GetPayload() *models.MsaReplyAffectedEntities {
	return o.Payload
}

func (o *PerformActionV2BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyAffectedEntities)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformActionV2Forbidden creates a PerformActionV2Forbidden with default headers values
func NewPerformActionV2Forbidden() *PerformActionV2Forbidden {
	return &PerformActionV2Forbidden{}
}

/*
PerformActionV2Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type PerformActionV2Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this perform action v2 forbidden response has a 2xx status code
func (o *PerformActionV2Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform action v2 forbidden response has a 3xx status code
func (o *PerformActionV2Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform action v2 forbidden response has a 4xx status code
func (o *PerformActionV2Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this perform action v2 forbidden response has a 5xx status code
func (o *PerformActionV2Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this perform action v2 forbidden response a status code equal to that given
func (o *PerformActionV2Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the perform action v2 forbidden response
func (o *PerformActionV2Forbidden) Code() int {
	return 403
}

func (o *PerformActionV2Forbidden) Error() string {
	return fmt.Sprintf("[POST /devices/entities/devices-actions/v2][%d] performActionV2Forbidden  %+v", 403, o.Payload)
}

func (o *PerformActionV2Forbidden) String() string {
	return fmt.Sprintf("[POST /devices/entities/devices-actions/v2][%d] performActionV2Forbidden  %+v", 403, o.Payload)
}

func (o *PerformActionV2Forbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *PerformActionV2Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformActionV2Conflict creates a PerformActionV2Conflict with default headers values
func NewPerformActionV2Conflict() *PerformActionV2Conflict {
	return &PerformActionV2Conflict{}
}

/*
PerformActionV2Conflict describes a response with status code 409, with default header values.

Conflict
*/
type PerformActionV2Conflict struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyAffectedEntities
}

// IsSuccess returns true when this perform action v2 conflict response has a 2xx status code
func (o *PerformActionV2Conflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform action v2 conflict response has a 3xx status code
func (o *PerformActionV2Conflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform action v2 conflict response has a 4xx status code
func (o *PerformActionV2Conflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this perform action v2 conflict response has a 5xx status code
func (o *PerformActionV2Conflict) IsServerError() bool {
	return false
}

// IsCode returns true when this perform action v2 conflict response a status code equal to that given
func (o *PerformActionV2Conflict) IsCode(code int) bool {
	return code == 409
}

// Code gets the status code for the perform action v2 conflict response
func (o *PerformActionV2Conflict) Code() int {
	return 409
}

func (o *PerformActionV2Conflict) Error() string {
	return fmt.Sprintf("[POST /devices/entities/devices-actions/v2][%d] performActionV2Conflict  %+v", 409, o.Payload)
}

func (o *PerformActionV2Conflict) String() string {
	return fmt.Sprintf("[POST /devices/entities/devices-actions/v2][%d] performActionV2Conflict  %+v", 409, o.Payload)
}

func (o *PerformActionV2Conflict) GetPayload() *models.MsaReplyAffectedEntities {
	return o.Payload
}

func (o *PerformActionV2Conflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyAffectedEntities)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformActionV2TooManyRequests creates a PerformActionV2TooManyRequests with default headers values
func NewPerformActionV2TooManyRequests() *PerformActionV2TooManyRequests {
	return &PerformActionV2TooManyRequests{}
}

/*
PerformActionV2TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type PerformActionV2TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this perform action v2 too many requests response has a 2xx status code
func (o *PerformActionV2TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform action v2 too many requests response has a 3xx status code
func (o *PerformActionV2TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform action v2 too many requests response has a 4xx status code
func (o *PerformActionV2TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this perform action v2 too many requests response has a 5xx status code
func (o *PerformActionV2TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this perform action v2 too many requests response a status code equal to that given
func (o *PerformActionV2TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the perform action v2 too many requests response
func (o *PerformActionV2TooManyRequests) Code() int {
	return 429
}

func (o *PerformActionV2TooManyRequests) Error() string {
	return fmt.Sprintf("[POST /devices/entities/devices-actions/v2][%d] performActionV2TooManyRequests  %+v", 429, o.Payload)
}

func (o *PerformActionV2TooManyRequests) String() string {
	return fmt.Sprintf("[POST /devices/entities/devices-actions/v2][%d] performActionV2TooManyRequests  %+v", 429, o.Payload)
}

func (o *PerformActionV2TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *PerformActionV2TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformActionV2InternalServerError creates a PerformActionV2InternalServerError with default headers values
func NewPerformActionV2InternalServerError() *PerformActionV2InternalServerError {
	return &PerformActionV2InternalServerError{}
}

/*
PerformActionV2InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type PerformActionV2InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyAffectedEntities
}

// IsSuccess returns true when this perform action v2 internal server error response has a 2xx status code
func (o *PerformActionV2InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform action v2 internal server error response has a 3xx status code
func (o *PerformActionV2InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform action v2 internal server error response has a 4xx status code
func (o *PerformActionV2InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this perform action v2 internal server error response has a 5xx status code
func (o *PerformActionV2InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this perform action v2 internal server error response a status code equal to that given
func (o *PerformActionV2InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the perform action v2 internal server error response
func (o *PerformActionV2InternalServerError) Code() int {
	return 500
}

func (o *PerformActionV2InternalServerError) Error() string {
	return fmt.Sprintf("[POST /devices/entities/devices-actions/v2][%d] performActionV2InternalServerError  %+v", 500, o.Payload)
}

func (o *PerformActionV2InternalServerError) String() string {
	return fmt.Sprintf("[POST /devices/entities/devices-actions/v2][%d] performActionV2InternalServerError  %+v", 500, o.Payload)
}

func (o *PerformActionV2InternalServerError) GetPayload() *models.MsaReplyAffectedEntities {
	return o.Payload
}

func (o *PerformActionV2InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyAffectedEntities)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
