// Code generated by go-swagger; DO NOT EDIT.

package hosts

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryDevicesByFilterScrollParams creates a new QueryDevicesByFilterScrollParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryDevicesByFilterScrollParams() *QueryDevicesByFilterScrollParams {
	return &QueryDevicesByFilterScrollParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryDevicesByFilterScrollParamsWithTimeout creates a new QueryDevicesByFilterScrollParams object
// with the ability to set a timeout on a request.
func NewQueryDevicesByFilterScrollParamsWithTimeout(timeout time.Duration) *QueryDevicesByFilterScrollParams {
	return &QueryDevicesByFilterScrollParams{
		timeout: timeout,
	}
}

// NewQueryDevicesByFilterScrollParamsWithContext creates a new QueryDevicesByFilterScrollParams object
// with the ability to set a context for a request.
func NewQueryDevicesByFilterScrollParamsWithContext(ctx context.Context) *QueryDevicesByFilterScrollParams {
	return &QueryDevicesByFilterScrollParams{
		Context: ctx,
	}
}

// NewQueryDevicesByFilterScrollParamsWithHTTPClient creates a new QueryDevicesByFilterScrollParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryDevicesByFilterScrollParamsWithHTTPClient(client *http.Client) *QueryDevicesByFilterScrollParams {
	return &QueryDevicesByFilterScrollParams{
		HTTPClient: client,
	}
}

/*
QueryDevicesByFilterScrollParams contains all the parameters to send to the API endpoint

	for the query devices by filter scroll operation.

	Typically these are written to a http.Request.
*/
type QueryDevicesByFilterScrollParams struct {

	/* Filter.

	   The filter expression that should be used to limit the results
	*/
	Filter *string

	/* Limit.

	   The maximum records to return. [1-5000]
	*/
	Limit *int64

	/* Offset.

	   The offset to page from, for the next result set
	*/
	Offset *string

	/* Sort.

	   The property to sort by (e.g. status.desc or hostname.asc)
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query devices by filter scroll params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryDevicesByFilterScrollParams) WithDefaults() *QueryDevicesByFilterScrollParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query devices by filter scroll params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryDevicesByFilterScrollParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query devices by filter scroll params
func (o *QueryDevicesByFilterScrollParams) WithTimeout(timeout time.Duration) *QueryDevicesByFilterScrollParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query devices by filter scroll params
func (o *QueryDevicesByFilterScrollParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query devices by filter scroll params
func (o *QueryDevicesByFilterScrollParams) WithContext(ctx context.Context) *QueryDevicesByFilterScrollParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query devices by filter scroll params
func (o *QueryDevicesByFilterScrollParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query devices by filter scroll params
func (o *QueryDevicesByFilterScrollParams) WithHTTPClient(client *http.Client) *QueryDevicesByFilterScrollParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query devices by filter scroll params
func (o *QueryDevicesByFilterScrollParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query devices by filter scroll params
func (o *QueryDevicesByFilterScrollParams) WithFilter(filter *string) *QueryDevicesByFilterScrollParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query devices by filter scroll params
func (o *QueryDevicesByFilterScrollParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query devices by filter scroll params
func (o *QueryDevicesByFilterScrollParams) WithLimit(limit *int64) *QueryDevicesByFilterScrollParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query devices by filter scroll params
func (o *QueryDevicesByFilterScrollParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query devices by filter scroll params
func (o *QueryDevicesByFilterScrollParams) WithOffset(offset *string) *QueryDevicesByFilterScrollParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query devices by filter scroll params
func (o *QueryDevicesByFilterScrollParams) SetOffset(offset *string) {
	o.Offset = offset
}

// WithSort adds the sort to the query devices by filter scroll params
func (o *QueryDevicesByFilterScrollParams) WithSort(sort *string) *QueryDevicesByFilterScrollParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query devices by filter scroll params
func (o *QueryDevicesByFilterScrollParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryDevicesByFilterScrollParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset string

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := qrOffset
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
