// Code generated by go-swagger; DO NOT EDIT.

package identity_entities

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetSensorAggregatesReader is a Reader for the GetSensorAggregates structure.
type GetSensorAggregatesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetSensorAggregatesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetSensorAggregatesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetSensorAggregatesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetSensorAggregatesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /identity-protection/aggregates/devices/GET/v1] GetSensorAggregates", response, response.Code())
	}
}

// NewGetSensorAggregatesOK creates a GetSensorAggregatesOK with default headers values
func NewGetSensorAggregatesOK() *GetSensorAggregatesOK {
	return &GetSensorAggregatesOK{}
}

/*
GetSensorAggregatesOK describes a response with status code 200, with default header values.

OK
*/
type GetSensorAggregatesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaAggregatesResponse
}

// IsSuccess returns true when this get sensor aggregates o k response has a 2xx status code
func (o *GetSensorAggregatesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get sensor aggregates o k response has a 3xx status code
func (o *GetSensorAggregatesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sensor aggregates o k response has a 4xx status code
func (o *GetSensorAggregatesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get sensor aggregates o k response has a 5xx status code
func (o *GetSensorAggregatesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get sensor aggregates o k response a status code equal to that given
func (o *GetSensorAggregatesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get sensor aggregates o k response
func (o *GetSensorAggregatesOK) Code() int {
	return 200
}

func (o *GetSensorAggregatesOK) Error() string {
	return fmt.Sprintf("[POST /identity-protection/aggregates/devices/GET/v1][%d] getSensorAggregatesOK  %+v", 200, o.Payload)
}

func (o *GetSensorAggregatesOK) String() string {
	return fmt.Sprintf("[POST /identity-protection/aggregates/devices/GET/v1][%d] getSensorAggregatesOK  %+v", 200, o.Payload)
}

func (o *GetSensorAggregatesOK) GetPayload() *models.MsaAggregatesResponse {
	return o.Payload
}

func (o *GetSensorAggregatesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaAggregatesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSensorAggregatesForbidden creates a GetSensorAggregatesForbidden with default headers values
func NewGetSensorAggregatesForbidden() *GetSensorAggregatesForbidden {
	return &GetSensorAggregatesForbidden{}
}

/*
GetSensorAggregatesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetSensorAggregatesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get sensor aggregates forbidden response has a 2xx status code
func (o *GetSensorAggregatesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get sensor aggregates forbidden response has a 3xx status code
func (o *GetSensorAggregatesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sensor aggregates forbidden response has a 4xx status code
func (o *GetSensorAggregatesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get sensor aggregates forbidden response has a 5xx status code
func (o *GetSensorAggregatesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get sensor aggregates forbidden response a status code equal to that given
func (o *GetSensorAggregatesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get sensor aggregates forbidden response
func (o *GetSensorAggregatesForbidden) Code() int {
	return 403
}

func (o *GetSensorAggregatesForbidden) Error() string {
	return fmt.Sprintf("[POST /identity-protection/aggregates/devices/GET/v1][%d] getSensorAggregatesForbidden  %+v", 403, o.Payload)
}

func (o *GetSensorAggregatesForbidden) String() string {
	return fmt.Sprintf("[POST /identity-protection/aggregates/devices/GET/v1][%d] getSensorAggregatesForbidden  %+v", 403, o.Payload)
}

func (o *GetSensorAggregatesForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetSensorAggregatesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSensorAggregatesTooManyRequests creates a GetSensorAggregatesTooManyRequests with default headers values
func NewGetSensorAggregatesTooManyRequests() *GetSensorAggregatesTooManyRequests {
	return &GetSensorAggregatesTooManyRequests{}
}

/*
GetSensorAggregatesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetSensorAggregatesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get sensor aggregates too many requests response has a 2xx status code
func (o *GetSensorAggregatesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get sensor aggregates too many requests response has a 3xx status code
func (o *GetSensorAggregatesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sensor aggregates too many requests response has a 4xx status code
func (o *GetSensorAggregatesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get sensor aggregates too many requests response has a 5xx status code
func (o *GetSensorAggregatesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get sensor aggregates too many requests response a status code equal to that given
func (o *GetSensorAggregatesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get sensor aggregates too many requests response
func (o *GetSensorAggregatesTooManyRequests) Code() int {
	return 429
}

func (o *GetSensorAggregatesTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /identity-protection/aggregates/devices/GET/v1][%d] getSensorAggregatesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetSensorAggregatesTooManyRequests) String() string {
	return fmt.Sprintf("[POST /identity-protection/aggregates/devices/GET/v1][%d] getSensorAggregatesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetSensorAggregatesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetSensorAggregatesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
