// Code generated by go-swagger; DO NOT EDIT.

package identity_entities

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new identity entities API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for identity entities API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	GetSensorAggregates(params *GetSensorAggregatesParams, opts ...ClientOption) (*GetSensorAggregatesOK, error)

	GetSensorDetails(params *GetSensorDetailsParams, opts ...ClientOption) (*GetSensorDetailsOK, error)

	QuerySensorsByFilter(params *QuerySensorsByFilterParams, opts ...ClientOption) (*QuerySensorsByFilterOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
GetSensorAggregates gets sensor aggregates as specified via json in request body
*/
func (a *Client) GetSensorAggregates(params *GetSensorAggregatesParams, opts ...ClientOption) (*GetSensorAggregatesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetSensorAggregatesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetSensorAggregates",
		Method:             "POST",
		PathPattern:        "/identity-protection/aggregates/devices/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetSensorAggregatesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSensorAggregatesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetSensorAggregates: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetSensorDetails gets details on one or more sensors by providing device i ds in a p o s t body supports up to a maximum of 5000 i ds
*/
func (a *Client) GetSensorDetails(params *GetSensorDetailsParams, opts ...ClientOption) (*GetSensorDetailsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetSensorDetailsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetSensorDetails",
		Method:             "POST",
		PathPattern:        "/identity-protection/entities/devices/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetSensorDetailsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSensorDetailsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetSensorDetails: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QuerySensorsByFilter searches for sensors in your environment by hostname IP and other criteria
*/
func (a *Client) QuerySensorsByFilter(params *QuerySensorsByFilterParams, opts ...ClientOption) (*QuerySensorsByFilterOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQuerySensorsByFilterParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "QuerySensorsByFilter",
		Method:             "GET",
		PathPattern:        "/identity-protection/queries/devices/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QuerySensorsByFilterReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QuerySensorsByFilterOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QuerySensorsByFilter: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
