// Code generated by go-swagger; DO NOT EDIT.

package identity_protection

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// APIPreemptProxyPostGraphqlReader is a Reader for the APIPreemptProxyPostGraphql structure.
type APIPreemptProxyPostGraphqlReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *APIPreemptProxyPostGraphqlReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAPIPreemptProxyPostGraphqlOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewAPIPreemptProxyPostGraphqlForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewAPIPreemptProxyPostGraphqlTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /identity-protection/combined/graphql/v1] api.preempt.proxy.post.graphql", response, response.Code())
	}
}

// NewAPIPreemptProxyPostGraphqlOK creates a APIPreemptProxyPostGraphqlOK with default headers values
func NewAPIPreemptProxyPostGraphqlOK() *APIPreemptProxyPostGraphqlOK {
	return &APIPreemptProxyPostGraphqlOK{}
}

/*
APIPreemptProxyPostGraphqlOK describes a response with status code 200, with default header values.

OK
*/
type APIPreemptProxyPostGraphqlOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64
}

// IsSuccess returns true when this api preempt proxy post graphql o k response has a 2xx status code
func (o *APIPreemptProxyPostGraphqlOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this api preempt proxy post graphql o k response has a 3xx status code
func (o *APIPreemptProxyPostGraphqlOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this api preempt proxy post graphql o k response has a 4xx status code
func (o *APIPreemptProxyPostGraphqlOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this api preempt proxy post graphql o k response has a 5xx status code
func (o *APIPreemptProxyPostGraphqlOK) IsServerError() bool {
	return false
}

// IsCode returns true when this api preempt proxy post graphql o k response a status code equal to that given
func (o *APIPreemptProxyPostGraphqlOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the api preempt proxy post graphql o k response
func (o *APIPreemptProxyPostGraphqlOK) Code() int {
	return 200
}

func (o *APIPreemptProxyPostGraphqlOK) Error() string {
	return fmt.Sprintf("[POST /identity-protection/combined/graphql/v1][%d] apiPreemptProxyPostGraphqlOK ", 200)
}

func (o *APIPreemptProxyPostGraphqlOK) String() string {
	return fmt.Sprintf("[POST /identity-protection/combined/graphql/v1][%d] apiPreemptProxyPostGraphqlOK ", 200)
}

func (o *APIPreemptProxyPostGraphqlOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	return nil
}

// NewAPIPreemptProxyPostGraphqlForbidden creates a APIPreemptProxyPostGraphqlForbidden with default headers values
func NewAPIPreemptProxyPostGraphqlForbidden() *APIPreemptProxyPostGraphqlForbidden {
	return &APIPreemptProxyPostGraphqlForbidden{}
}

/*
APIPreemptProxyPostGraphqlForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type APIPreemptProxyPostGraphqlForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this api preempt proxy post graphql forbidden response has a 2xx status code
func (o *APIPreemptProxyPostGraphqlForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this api preempt proxy post graphql forbidden response has a 3xx status code
func (o *APIPreemptProxyPostGraphqlForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this api preempt proxy post graphql forbidden response has a 4xx status code
func (o *APIPreemptProxyPostGraphqlForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this api preempt proxy post graphql forbidden response has a 5xx status code
func (o *APIPreemptProxyPostGraphqlForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this api preempt proxy post graphql forbidden response a status code equal to that given
func (o *APIPreemptProxyPostGraphqlForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the api preempt proxy post graphql forbidden response
func (o *APIPreemptProxyPostGraphqlForbidden) Code() int {
	return 403
}

func (o *APIPreemptProxyPostGraphqlForbidden) Error() string {
	return fmt.Sprintf("[POST /identity-protection/combined/graphql/v1][%d] apiPreemptProxyPostGraphqlForbidden  %+v", 403, o.Payload)
}

func (o *APIPreemptProxyPostGraphqlForbidden) String() string {
	return fmt.Sprintf("[POST /identity-protection/combined/graphql/v1][%d] apiPreemptProxyPostGraphqlForbidden  %+v", 403, o.Payload)
}

func (o *APIPreemptProxyPostGraphqlForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *APIPreemptProxyPostGraphqlForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAPIPreemptProxyPostGraphqlTooManyRequests creates a APIPreemptProxyPostGraphqlTooManyRequests with default headers values
func NewAPIPreemptProxyPostGraphqlTooManyRequests() *APIPreemptProxyPostGraphqlTooManyRequests {
	return &APIPreemptProxyPostGraphqlTooManyRequests{}
}

/*
APIPreemptProxyPostGraphqlTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type APIPreemptProxyPostGraphqlTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this api preempt proxy post graphql too many requests response has a 2xx status code
func (o *APIPreemptProxyPostGraphqlTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this api preempt proxy post graphql too many requests response has a 3xx status code
func (o *APIPreemptProxyPostGraphqlTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this api preempt proxy post graphql too many requests response has a 4xx status code
func (o *APIPreemptProxyPostGraphqlTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this api preempt proxy post graphql too many requests response has a 5xx status code
func (o *APIPreemptProxyPostGraphqlTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this api preempt proxy post graphql too many requests response a status code equal to that given
func (o *APIPreemptProxyPostGraphqlTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the api preempt proxy post graphql too many requests response
func (o *APIPreemptProxyPostGraphqlTooManyRequests) Code() int {
	return 429
}

func (o *APIPreemptProxyPostGraphqlTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /identity-protection/combined/graphql/v1][%d] apiPreemptProxyPostGraphqlTooManyRequests  %+v", 429, o.Payload)
}

func (o *APIPreemptProxyPostGraphqlTooManyRequests) String() string {
	return fmt.Sprintf("[POST /identity-protection/combined/graphql/v1][%d] apiPreemptProxyPostGraphqlTooManyRequests  %+v", 429, o.Payload)
}

func (o *APIPreemptProxyPostGraphqlTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *APIPreemptProxyPostGraphqlTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
