// Code generated by go-swagger; DO NOT EDIT.

package incidents

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CrowdScoreReader is a Reader for the CrowdScore structure.
type CrowdScoreReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CrowdScoreReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCrowdScoreOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCrowdScoreBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCrowdScoreForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCrowdScoreTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCrowdScoreInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /incidents/combined/crowdscores/v1] CrowdScore", response, response.Code())
	}
}

// NewCrowdScoreOK creates a CrowdScoreOK with default headers values
func NewCrowdScoreOK() *CrowdScoreOK {
	return &CrowdScoreOK{}
}

/*
CrowdScoreOK describes a response with status code 200, with default header values.

OK
*/
type CrowdScoreOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainMsaEnvironmentScoreResponse
}

// IsSuccess returns true when this crowd score o k response has a 2xx status code
func (o *CrowdScoreOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this crowd score o k response has a 3xx status code
func (o *CrowdScoreOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this crowd score o k response has a 4xx status code
func (o *CrowdScoreOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this crowd score o k response has a 5xx status code
func (o *CrowdScoreOK) IsServerError() bool {
	return false
}

// IsCode returns true when this crowd score o k response a status code equal to that given
func (o *CrowdScoreOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the crowd score o k response
func (o *CrowdScoreOK) Code() int {
	return 200
}

func (o *CrowdScoreOK) Error() string {
	return fmt.Sprintf("[GET /incidents/combined/crowdscores/v1][%d] crowdScoreOK  %+v", 200, o.Payload)
}

func (o *CrowdScoreOK) String() string {
	return fmt.Sprintf("[GET /incidents/combined/crowdscores/v1][%d] crowdScoreOK  %+v", 200, o.Payload)
}

func (o *CrowdScoreOK) GetPayload() *models.DomainMsaEnvironmentScoreResponse {
	return o.Payload
}

func (o *CrowdScoreOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainMsaEnvironmentScoreResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCrowdScoreBadRequest creates a CrowdScoreBadRequest with default headers values
func NewCrowdScoreBadRequest() *CrowdScoreBadRequest {
	return &CrowdScoreBadRequest{}
}

/*
CrowdScoreBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type CrowdScoreBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this crowd score bad request response has a 2xx status code
func (o *CrowdScoreBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this crowd score bad request response has a 3xx status code
func (o *CrowdScoreBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this crowd score bad request response has a 4xx status code
func (o *CrowdScoreBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this crowd score bad request response has a 5xx status code
func (o *CrowdScoreBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this crowd score bad request response a status code equal to that given
func (o *CrowdScoreBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the crowd score bad request response
func (o *CrowdScoreBadRequest) Code() int {
	return 400
}

func (o *CrowdScoreBadRequest) Error() string {
	return fmt.Sprintf("[GET /incidents/combined/crowdscores/v1][%d] crowdScoreBadRequest  %+v", 400, o.Payload)
}

func (o *CrowdScoreBadRequest) String() string {
	return fmt.Sprintf("[GET /incidents/combined/crowdscores/v1][%d] crowdScoreBadRequest  %+v", 400, o.Payload)
}

func (o *CrowdScoreBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CrowdScoreBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCrowdScoreForbidden creates a CrowdScoreForbidden with default headers values
func NewCrowdScoreForbidden() *CrowdScoreForbidden {
	return &CrowdScoreForbidden{}
}

/*
CrowdScoreForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CrowdScoreForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this crowd score forbidden response has a 2xx status code
func (o *CrowdScoreForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this crowd score forbidden response has a 3xx status code
func (o *CrowdScoreForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this crowd score forbidden response has a 4xx status code
func (o *CrowdScoreForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this crowd score forbidden response has a 5xx status code
func (o *CrowdScoreForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this crowd score forbidden response a status code equal to that given
func (o *CrowdScoreForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the crowd score forbidden response
func (o *CrowdScoreForbidden) Code() int {
	return 403
}

func (o *CrowdScoreForbidden) Error() string {
	return fmt.Sprintf("[GET /incidents/combined/crowdscores/v1][%d] crowdScoreForbidden  %+v", 403, o.Payload)
}

func (o *CrowdScoreForbidden) String() string {
	return fmt.Sprintf("[GET /incidents/combined/crowdscores/v1][%d] crowdScoreForbidden  %+v", 403, o.Payload)
}

func (o *CrowdScoreForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CrowdScoreForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCrowdScoreTooManyRequests creates a CrowdScoreTooManyRequests with default headers values
func NewCrowdScoreTooManyRequests() *CrowdScoreTooManyRequests {
	return &CrowdScoreTooManyRequests{}
}

/*
CrowdScoreTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CrowdScoreTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this crowd score too many requests response has a 2xx status code
func (o *CrowdScoreTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this crowd score too many requests response has a 3xx status code
func (o *CrowdScoreTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this crowd score too many requests response has a 4xx status code
func (o *CrowdScoreTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this crowd score too many requests response has a 5xx status code
func (o *CrowdScoreTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this crowd score too many requests response a status code equal to that given
func (o *CrowdScoreTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the crowd score too many requests response
func (o *CrowdScoreTooManyRequests) Code() int {
	return 429
}

func (o *CrowdScoreTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /incidents/combined/crowdscores/v1][%d] crowdScoreTooManyRequests  %+v", 429, o.Payload)
}

func (o *CrowdScoreTooManyRequests) String() string {
	return fmt.Sprintf("[GET /incidents/combined/crowdscores/v1][%d] crowdScoreTooManyRequests  %+v", 429, o.Payload)
}

func (o *CrowdScoreTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CrowdScoreTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCrowdScoreInternalServerError creates a CrowdScoreInternalServerError with default headers values
func NewCrowdScoreInternalServerError() *CrowdScoreInternalServerError {
	return &CrowdScoreInternalServerError{}
}

/*
CrowdScoreInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type CrowdScoreInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this crowd score internal server error response has a 2xx status code
func (o *CrowdScoreInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this crowd score internal server error response has a 3xx status code
func (o *CrowdScoreInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this crowd score internal server error response has a 4xx status code
func (o *CrowdScoreInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this crowd score internal server error response has a 5xx status code
func (o *CrowdScoreInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this crowd score internal server error response a status code equal to that given
func (o *CrowdScoreInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the crowd score internal server error response
func (o *CrowdScoreInternalServerError) Code() int {
	return 500
}

func (o *CrowdScoreInternalServerError) Error() string {
	return fmt.Sprintf("[GET /incidents/combined/crowdscores/v1][%d] crowdScoreInternalServerError  %+v", 500, o.Payload)
}

func (o *CrowdScoreInternalServerError) String() string {
	return fmt.Sprintf("[GET /incidents/combined/crowdscores/v1][%d] crowdScoreInternalServerError  %+v", 500, o.Payload)
}

func (o *CrowdScoreInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CrowdScoreInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
