// Code generated by go-swagger; DO NOT EDIT.

package incidents

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetBehaviorsReader is a Reader for the GetBehaviors structure.
type GetBehaviorsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetBehaviorsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetBehaviorsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetBehaviorsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetBehaviorsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetBehaviorsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetBehaviorsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /incidents/entities/behaviors/GET/v1] GetBehaviors", response, response.Code())
	}
}

// NewGetBehaviorsOK creates a GetBehaviorsOK with default headers values
func NewGetBehaviorsOK() *GetBehaviorsOK {
	return &GetBehaviorsOK{}
}

/*
GetBehaviorsOK describes a response with status code 200, with default header values.

OK
*/
type GetBehaviorsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainMsaExternalBehaviorResponse
}

// IsSuccess returns true when this get behaviors o k response has a 2xx status code
func (o *GetBehaviorsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get behaviors o k response has a 3xx status code
func (o *GetBehaviorsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get behaviors o k response has a 4xx status code
func (o *GetBehaviorsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get behaviors o k response has a 5xx status code
func (o *GetBehaviorsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get behaviors o k response a status code equal to that given
func (o *GetBehaviorsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get behaviors o k response
func (o *GetBehaviorsOK) Code() int {
	return 200
}

func (o *GetBehaviorsOK) Error() string {
	return fmt.Sprintf("[POST /incidents/entities/behaviors/GET/v1][%d] getBehaviorsOK  %+v", 200, o.Payload)
}

func (o *GetBehaviorsOK) String() string {
	return fmt.Sprintf("[POST /incidents/entities/behaviors/GET/v1][%d] getBehaviorsOK  %+v", 200, o.Payload)
}

func (o *GetBehaviorsOK) GetPayload() *models.DomainMsaExternalBehaviorResponse {
	return o.Payload
}

func (o *GetBehaviorsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainMsaExternalBehaviorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetBehaviorsBadRequest creates a GetBehaviorsBadRequest with default headers values
func NewGetBehaviorsBadRequest() *GetBehaviorsBadRequest {
	return &GetBehaviorsBadRequest{}
}

/*
GetBehaviorsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetBehaviorsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get behaviors bad request response has a 2xx status code
func (o *GetBehaviorsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get behaviors bad request response has a 3xx status code
func (o *GetBehaviorsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get behaviors bad request response has a 4xx status code
func (o *GetBehaviorsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get behaviors bad request response has a 5xx status code
func (o *GetBehaviorsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get behaviors bad request response a status code equal to that given
func (o *GetBehaviorsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get behaviors bad request response
func (o *GetBehaviorsBadRequest) Code() int {
	return 400
}

func (o *GetBehaviorsBadRequest) Error() string {
	return fmt.Sprintf("[POST /incidents/entities/behaviors/GET/v1][%d] getBehaviorsBadRequest  %+v", 400, o.Payload)
}

func (o *GetBehaviorsBadRequest) String() string {
	return fmt.Sprintf("[POST /incidents/entities/behaviors/GET/v1][%d] getBehaviorsBadRequest  %+v", 400, o.Payload)
}

func (o *GetBehaviorsBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetBehaviorsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetBehaviorsForbidden creates a GetBehaviorsForbidden with default headers values
func NewGetBehaviorsForbidden() *GetBehaviorsForbidden {
	return &GetBehaviorsForbidden{}
}

/*
GetBehaviorsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetBehaviorsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get behaviors forbidden response has a 2xx status code
func (o *GetBehaviorsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get behaviors forbidden response has a 3xx status code
func (o *GetBehaviorsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get behaviors forbidden response has a 4xx status code
func (o *GetBehaviorsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get behaviors forbidden response has a 5xx status code
func (o *GetBehaviorsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get behaviors forbidden response a status code equal to that given
func (o *GetBehaviorsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get behaviors forbidden response
func (o *GetBehaviorsForbidden) Code() int {
	return 403
}

func (o *GetBehaviorsForbidden) Error() string {
	return fmt.Sprintf("[POST /incidents/entities/behaviors/GET/v1][%d] getBehaviorsForbidden  %+v", 403, o.Payload)
}

func (o *GetBehaviorsForbidden) String() string {
	return fmt.Sprintf("[POST /incidents/entities/behaviors/GET/v1][%d] getBehaviorsForbidden  %+v", 403, o.Payload)
}

func (o *GetBehaviorsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetBehaviorsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetBehaviorsTooManyRequests creates a GetBehaviorsTooManyRequests with default headers values
func NewGetBehaviorsTooManyRequests() *GetBehaviorsTooManyRequests {
	return &GetBehaviorsTooManyRequests{}
}

/*
GetBehaviorsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetBehaviorsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get behaviors too many requests response has a 2xx status code
func (o *GetBehaviorsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get behaviors too many requests response has a 3xx status code
func (o *GetBehaviorsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get behaviors too many requests response has a 4xx status code
func (o *GetBehaviorsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get behaviors too many requests response has a 5xx status code
func (o *GetBehaviorsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get behaviors too many requests response a status code equal to that given
func (o *GetBehaviorsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get behaviors too many requests response
func (o *GetBehaviorsTooManyRequests) Code() int {
	return 429
}

func (o *GetBehaviorsTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /incidents/entities/behaviors/GET/v1][%d] getBehaviorsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetBehaviorsTooManyRequests) String() string {
	return fmt.Sprintf("[POST /incidents/entities/behaviors/GET/v1][%d] getBehaviorsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetBehaviorsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetBehaviorsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetBehaviorsInternalServerError creates a GetBehaviorsInternalServerError with default headers values
func NewGetBehaviorsInternalServerError() *GetBehaviorsInternalServerError {
	return &GetBehaviorsInternalServerError{}
}

/*
GetBehaviorsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetBehaviorsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get behaviors internal server error response has a 2xx status code
func (o *GetBehaviorsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get behaviors internal server error response has a 3xx status code
func (o *GetBehaviorsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get behaviors internal server error response has a 4xx status code
func (o *GetBehaviorsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get behaviors internal server error response has a 5xx status code
func (o *GetBehaviorsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get behaviors internal server error response a status code equal to that given
func (o *GetBehaviorsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get behaviors internal server error response
func (o *GetBehaviorsInternalServerError) Code() int {
	return 500
}

func (o *GetBehaviorsInternalServerError) Error() string {
	return fmt.Sprintf("[POST /incidents/entities/behaviors/GET/v1][%d] getBehaviorsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetBehaviorsInternalServerError) String() string {
	return fmt.Sprintf("[POST /incidents/entities/behaviors/GET/v1][%d] getBehaviorsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetBehaviorsInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetBehaviorsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
