// Code generated by go-swagger; DO NOT EDIT.

package incidents

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetIncidentsReader is a Reader for the GetIncidents structure.
type GetIncidentsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetIncidentsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetIncidentsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetIncidentsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetIncidentsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetIncidentsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetIncidentsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /incidents/entities/incidents/GET/v1] GetIncidents", response, response.Code())
	}
}

// NewGetIncidentsOK creates a GetIncidentsOK with default headers values
func NewGetIncidentsOK() *GetIncidentsOK {
	return &GetIncidentsOK{}
}

/*
GetIncidentsOK describes a response with status code 200, with default header values.

OK
*/
type GetIncidentsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainMsaExternalIncidentResponse
}

// IsSuccess returns true when this get incidents o k response has a 2xx status code
func (o *GetIncidentsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get incidents o k response has a 3xx status code
func (o *GetIncidentsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get incidents o k response has a 4xx status code
func (o *GetIncidentsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get incidents o k response has a 5xx status code
func (o *GetIncidentsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get incidents o k response a status code equal to that given
func (o *GetIncidentsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get incidents o k response
func (o *GetIncidentsOK) Code() int {
	return 200
}

func (o *GetIncidentsOK) Error() string {
	return fmt.Sprintf("[POST /incidents/entities/incidents/GET/v1][%d] getIncidentsOK  %+v", 200, o.Payload)
}

func (o *GetIncidentsOK) String() string {
	return fmt.Sprintf("[POST /incidents/entities/incidents/GET/v1][%d] getIncidentsOK  %+v", 200, o.Payload)
}

func (o *GetIncidentsOK) GetPayload() *models.DomainMsaExternalIncidentResponse {
	return o.Payload
}

func (o *GetIncidentsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainMsaExternalIncidentResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIncidentsBadRequest creates a GetIncidentsBadRequest with default headers values
func NewGetIncidentsBadRequest() *GetIncidentsBadRequest {
	return &GetIncidentsBadRequest{}
}

/*
GetIncidentsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetIncidentsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get incidents bad request response has a 2xx status code
func (o *GetIncidentsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get incidents bad request response has a 3xx status code
func (o *GetIncidentsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get incidents bad request response has a 4xx status code
func (o *GetIncidentsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get incidents bad request response has a 5xx status code
func (o *GetIncidentsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get incidents bad request response a status code equal to that given
func (o *GetIncidentsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get incidents bad request response
func (o *GetIncidentsBadRequest) Code() int {
	return 400
}

func (o *GetIncidentsBadRequest) Error() string {
	return fmt.Sprintf("[POST /incidents/entities/incidents/GET/v1][%d] getIncidentsBadRequest  %+v", 400, o.Payload)
}

func (o *GetIncidentsBadRequest) String() string {
	return fmt.Sprintf("[POST /incidents/entities/incidents/GET/v1][%d] getIncidentsBadRequest  %+v", 400, o.Payload)
}

func (o *GetIncidentsBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetIncidentsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIncidentsForbidden creates a GetIncidentsForbidden with default headers values
func NewGetIncidentsForbidden() *GetIncidentsForbidden {
	return &GetIncidentsForbidden{}
}

/*
GetIncidentsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetIncidentsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get incidents forbidden response has a 2xx status code
func (o *GetIncidentsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get incidents forbidden response has a 3xx status code
func (o *GetIncidentsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get incidents forbidden response has a 4xx status code
func (o *GetIncidentsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get incidents forbidden response has a 5xx status code
func (o *GetIncidentsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get incidents forbidden response a status code equal to that given
func (o *GetIncidentsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get incidents forbidden response
func (o *GetIncidentsForbidden) Code() int {
	return 403
}

func (o *GetIncidentsForbidden) Error() string {
	return fmt.Sprintf("[POST /incidents/entities/incidents/GET/v1][%d] getIncidentsForbidden  %+v", 403, o.Payload)
}

func (o *GetIncidentsForbidden) String() string {
	return fmt.Sprintf("[POST /incidents/entities/incidents/GET/v1][%d] getIncidentsForbidden  %+v", 403, o.Payload)
}

func (o *GetIncidentsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetIncidentsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIncidentsTooManyRequests creates a GetIncidentsTooManyRequests with default headers values
func NewGetIncidentsTooManyRequests() *GetIncidentsTooManyRequests {
	return &GetIncidentsTooManyRequests{}
}

/*
GetIncidentsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetIncidentsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get incidents too many requests response has a 2xx status code
func (o *GetIncidentsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get incidents too many requests response has a 3xx status code
func (o *GetIncidentsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get incidents too many requests response has a 4xx status code
func (o *GetIncidentsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get incidents too many requests response has a 5xx status code
func (o *GetIncidentsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get incidents too many requests response a status code equal to that given
func (o *GetIncidentsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get incidents too many requests response
func (o *GetIncidentsTooManyRequests) Code() int {
	return 429
}

func (o *GetIncidentsTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /incidents/entities/incidents/GET/v1][%d] getIncidentsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetIncidentsTooManyRequests) String() string {
	return fmt.Sprintf("[POST /incidents/entities/incidents/GET/v1][%d] getIncidentsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetIncidentsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetIncidentsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIncidentsInternalServerError creates a GetIncidentsInternalServerError with default headers values
func NewGetIncidentsInternalServerError() *GetIncidentsInternalServerError {
	return &GetIncidentsInternalServerError{}
}

/*
GetIncidentsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetIncidentsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get incidents internal server error response has a 2xx status code
func (o *GetIncidentsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get incidents internal server error response has a 3xx status code
func (o *GetIncidentsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get incidents internal server error response has a 4xx status code
func (o *GetIncidentsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get incidents internal server error response has a 5xx status code
func (o *GetIncidentsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get incidents internal server error response a status code equal to that given
func (o *GetIncidentsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get incidents internal server error response
func (o *GetIncidentsInternalServerError) Code() int {
	return 500
}

func (o *GetIncidentsInternalServerError) Error() string {
	return fmt.Sprintf("[POST /incidents/entities/incidents/GET/v1][%d] getIncidentsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetIncidentsInternalServerError) String() string {
	return fmt.Sprintf("[POST /incidents/entities/incidents/GET/v1][%d] getIncidentsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetIncidentsInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetIncidentsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
