// Code generated by go-swagger; DO NOT EDIT.

package incidents

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new incidents API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for incidents API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	CrowdScore(params *CrowdScoreParams, opts ...ClientOption) (*CrowdScoreOK, error)

	GetBehaviors(params *GetBehaviorsParams, opts ...ClientOption) (*GetBehaviorsOK, error)

	GetIncidents(params *GetIncidentsParams, opts ...ClientOption) (*GetIncidentsOK, error)

	PerformIncidentAction(params *PerformIncidentActionParams, opts ...ClientOption) (*PerformIncidentActionOK, error)

	QueryBehaviors(params *QueryBehaviorsParams, opts ...ClientOption) (*QueryBehaviorsOK, error)

	QueryIncidents(params *QueryIncidentsParams, opts ...ClientOption) (*QueryIncidentsOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
CrowdScore queries environment wide crowd score and return the entity data
*/
func (a *Client) CrowdScore(params *CrowdScoreParams, opts ...ClientOption) (*CrowdScoreOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCrowdScoreParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CrowdScore",
		Method:             "GET",
		PathPattern:        "/incidents/combined/crowdscores/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CrowdScoreReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CrowdScoreOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for CrowdScore: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetBehaviors gets details on behaviors by providing behavior i ds
*/
func (a *Client) GetBehaviors(params *GetBehaviorsParams, opts ...ClientOption) (*GetBehaviorsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetBehaviorsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetBehaviors",
		Method:             "POST",
		PathPattern:        "/incidents/entities/behaviors/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetBehaviorsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetBehaviorsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetBehaviors: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetIncidents gets details on incidents by providing incident i ds
*/
func (a *Client) GetIncidents(params *GetIncidentsParams, opts ...ClientOption) (*GetIncidentsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetIncidentsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetIncidents",
		Method:             "POST",
		PathPattern:        "/incidents/entities/incidents/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetIncidentsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetIncidentsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetIncidents: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PerformIncidentAction performs a set of actions on one or more incidents such as adding tags or comments or updating the incident name or description
*/
func (a *Client) PerformIncidentAction(params *PerformIncidentActionParams, opts ...ClientOption) (*PerformIncidentActionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformIncidentActionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PerformIncidentAction",
		Method:             "POST",
		PathPattern:        "/incidents/entities/incident-actions/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformIncidentActionReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformIncidentActionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PerformIncidentAction: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryBehaviors searches for behaviors by providing an f q l filter sorting and paging details
*/
func (a *Client) QueryBehaviors(params *QueryBehaviorsParams, opts ...ClientOption) (*QueryBehaviorsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryBehaviorsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryBehaviors",
		Method:             "GET",
		PathPattern:        "/incidents/queries/behaviors/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryBehaviorsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryBehaviorsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryBehaviors: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryIncidents searches for incidents by providing an f q l filter sorting and paging details
*/
func (a *Client) QueryIncidents(params *QueryIncidentsParams, opts ...ClientOption) (*QueryIncidentsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryIncidentsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryIncidents",
		Method:             "GET",
		PathPattern:        "/incidents/queries/incidents/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryIncidentsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryIncidentsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryIncidents: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
