// Code generated by go-swagger; DO NOT EDIT.

package incidents

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// PerformIncidentActionReader is a Reader for the PerformIncidentAction structure.
type PerformIncidentActionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PerformIncidentActionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPerformIncidentActionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPerformIncidentActionBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewPerformIncidentActionForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewPerformIncidentActionConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewPerformIncidentActionTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPerformIncidentActionInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /incidents/entities/incident-actions/v1] PerformIncidentAction", response, response.Code())
	}
}

// NewPerformIncidentActionOK creates a PerformIncidentActionOK with default headers values
func NewPerformIncidentActionOK() *PerformIncidentActionOK {
	return &PerformIncidentActionOK{}
}

/*
PerformIncidentActionOK describes a response with status code 200, with default header values.

OK
*/
type PerformIncidentActionOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainMsaIncidentPerformActionResponse
}

// IsSuccess returns true when this perform incident action o k response has a 2xx status code
func (o *PerformIncidentActionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this perform incident action o k response has a 3xx status code
func (o *PerformIncidentActionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform incident action o k response has a 4xx status code
func (o *PerformIncidentActionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this perform incident action o k response has a 5xx status code
func (o *PerformIncidentActionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this perform incident action o k response a status code equal to that given
func (o *PerformIncidentActionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the perform incident action o k response
func (o *PerformIncidentActionOK) Code() int {
	return 200
}

func (o *PerformIncidentActionOK) Error() string {
	return fmt.Sprintf("[POST /incidents/entities/incident-actions/v1][%d] performIncidentActionOK  %+v", 200, o.Payload)
}

func (o *PerformIncidentActionOK) String() string {
	return fmt.Sprintf("[POST /incidents/entities/incident-actions/v1][%d] performIncidentActionOK  %+v", 200, o.Payload)
}

func (o *PerformIncidentActionOK) GetPayload() *models.DomainMsaIncidentPerformActionResponse {
	return o.Payload
}

func (o *PerformIncidentActionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainMsaIncidentPerformActionResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformIncidentActionBadRequest creates a PerformIncidentActionBadRequest with default headers values
func NewPerformIncidentActionBadRequest() *PerformIncidentActionBadRequest {
	return &PerformIncidentActionBadRequest{}
}

/*
PerformIncidentActionBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type PerformIncidentActionBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this perform incident action bad request response has a 2xx status code
func (o *PerformIncidentActionBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform incident action bad request response has a 3xx status code
func (o *PerformIncidentActionBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform incident action bad request response has a 4xx status code
func (o *PerformIncidentActionBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this perform incident action bad request response has a 5xx status code
func (o *PerformIncidentActionBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this perform incident action bad request response a status code equal to that given
func (o *PerformIncidentActionBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the perform incident action bad request response
func (o *PerformIncidentActionBadRequest) Code() int {
	return 400
}

func (o *PerformIncidentActionBadRequest) Error() string {
	return fmt.Sprintf("[POST /incidents/entities/incident-actions/v1][%d] performIncidentActionBadRequest  %+v", 400, o.Payload)
}

func (o *PerformIncidentActionBadRequest) String() string {
	return fmt.Sprintf("[POST /incidents/entities/incident-actions/v1][%d] performIncidentActionBadRequest  %+v", 400, o.Payload)
}

func (o *PerformIncidentActionBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *PerformIncidentActionBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformIncidentActionForbidden creates a PerformIncidentActionForbidden with default headers values
func NewPerformIncidentActionForbidden() *PerformIncidentActionForbidden {
	return &PerformIncidentActionForbidden{}
}

/*
PerformIncidentActionForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type PerformIncidentActionForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this perform incident action forbidden response has a 2xx status code
func (o *PerformIncidentActionForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform incident action forbidden response has a 3xx status code
func (o *PerformIncidentActionForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform incident action forbidden response has a 4xx status code
func (o *PerformIncidentActionForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this perform incident action forbidden response has a 5xx status code
func (o *PerformIncidentActionForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this perform incident action forbidden response a status code equal to that given
func (o *PerformIncidentActionForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the perform incident action forbidden response
func (o *PerformIncidentActionForbidden) Code() int {
	return 403
}

func (o *PerformIncidentActionForbidden) Error() string {
	return fmt.Sprintf("[POST /incidents/entities/incident-actions/v1][%d] performIncidentActionForbidden  %+v", 403, o.Payload)
}

func (o *PerformIncidentActionForbidden) String() string {
	return fmt.Sprintf("[POST /incidents/entities/incident-actions/v1][%d] performIncidentActionForbidden  %+v", 403, o.Payload)
}

func (o *PerformIncidentActionForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *PerformIncidentActionForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformIncidentActionConflict creates a PerformIncidentActionConflict with default headers values
func NewPerformIncidentActionConflict() *PerformIncidentActionConflict {
	return &PerformIncidentActionConflict{}
}

/*
PerformIncidentActionConflict describes a response with status code 409, with default header values.

Conflict
*/
type PerformIncidentActionConflict struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this perform incident action conflict response has a 2xx status code
func (o *PerformIncidentActionConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform incident action conflict response has a 3xx status code
func (o *PerformIncidentActionConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform incident action conflict response has a 4xx status code
func (o *PerformIncidentActionConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this perform incident action conflict response has a 5xx status code
func (o *PerformIncidentActionConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this perform incident action conflict response a status code equal to that given
func (o *PerformIncidentActionConflict) IsCode(code int) bool {
	return code == 409
}

// Code gets the status code for the perform incident action conflict response
func (o *PerformIncidentActionConflict) Code() int {
	return 409
}

func (o *PerformIncidentActionConflict) Error() string {
	return fmt.Sprintf("[POST /incidents/entities/incident-actions/v1][%d] performIncidentActionConflict  %+v", 409, o.Payload)
}

func (o *PerformIncidentActionConflict) String() string {
	return fmt.Sprintf("[POST /incidents/entities/incident-actions/v1][%d] performIncidentActionConflict  %+v", 409, o.Payload)
}

func (o *PerformIncidentActionConflict) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *PerformIncidentActionConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformIncidentActionTooManyRequests creates a PerformIncidentActionTooManyRequests with default headers values
func NewPerformIncidentActionTooManyRequests() *PerformIncidentActionTooManyRequests {
	return &PerformIncidentActionTooManyRequests{}
}

/*
PerformIncidentActionTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type PerformIncidentActionTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this perform incident action too many requests response has a 2xx status code
func (o *PerformIncidentActionTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform incident action too many requests response has a 3xx status code
func (o *PerformIncidentActionTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform incident action too many requests response has a 4xx status code
func (o *PerformIncidentActionTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this perform incident action too many requests response has a 5xx status code
func (o *PerformIncidentActionTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this perform incident action too many requests response a status code equal to that given
func (o *PerformIncidentActionTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the perform incident action too many requests response
func (o *PerformIncidentActionTooManyRequests) Code() int {
	return 429
}

func (o *PerformIncidentActionTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /incidents/entities/incident-actions/v1][%d] performIncidentActionTooManyRequests  %+v", 429, o.Payload)
}

func (o *PerformIncidentActionTooManyRequests) String() string {
	return fmt.Sprintf("[POST /incidents/entities/incident-actions/v1][%d] performIncidentActionTooManyRequests  %+v", 429, o.Payload)
}

func (o *PerformIncidentActionTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *PerformIncidentActionTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformIncidentActionInternalServerError creates a PerformIncidentActionInternalServerError with default headers values
func NewPerformIncidentActionInternalServerError() *PerformIncidentActionInternalServerError {
	return &PerformIncidentActionInternalServerError{}
}

/*
PerformIncidentActionInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type PerformIncidentActionInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this perform incident action internal server error response has a 2xx status code
func (o *PerformIncidentActionInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform incident action internal server error response has a 3xx status code
func (o *PerformIncidentActionInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform incident action internal server error response has a 4xx status code
func (o *PerformIncidentActionInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this perform incident action internal server error response has a 5xx status code
func (o *PerformIncidentActionInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this perform incident action internal server error response a status code equal to that given
func (o *PerformIncidentActionInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the perform incident action internal server error response
func (o *PerformIncidentActionInternalServerError) Code() int {
	return 500
}

func (o *PerformIncidentActionInternalServerError) Error() string {
	return fmt.Sprintf("[POST /incidents/entities/incident-actions/v1][%d] performIncidentActionInternalServerError  %+v", 500, o.Payload)
}

func (o *PerformIncidentActionInternalServerError) String() string {
	return fmt.Sprintf("[POST /incidents/entities/incident-actions/v1][%d] performIncidentActionInternalServerError  %+v", 500, o.Payload)
}

func (o *PerformIncidentActionInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *PerformIncidentActionInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
