// Code generated by go-swagger; DO NOT EDIT.

package incidents

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryIncidentsReader is a Reader for the QueryIncidents structure.
type QueryIncidentsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryIncidentsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryIncidentsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryIncidentsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryIncidentsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryIncidentsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryIncidentsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /incidents/queries/incidents/v1] QueryIncidents", response, response.Code())
	}
}

// NewQueryIncidentsOK creates a QueryIncidentsOK with default headers values
func NewQueryIncidentsOK() *QueryIncidentsOK {
	return &QueryIncidentsOK{}
}

/*
QueryIncidentsOK describes a response with status code 200, with default header values.

OK
*/
type QueryIncidentsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainMsaIncidentQueryResponse
}

// IsSuccess returns true when this query incidents o k response has a 2xx status code
func (o *QueryIncidentsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query incidents o k response has a 3xx status code
func (o *QueryIncidentsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query incidents o k response has a 4xx status code
func (o *QueryIncidentsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query incidents o k response has a 5xx status code
func (o *QueryIncidentsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query incidents o k response a status code equal to that given
func (o *QueryIncidentsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query incidents o k response
func (o *QueryIncidentsOK) Code() int {
	return 200
}

func (o *QueryIncidentsOK) Error() string {
	return fmt.Sprintf("[GET /incidents/queries/incidents/v1][%d] queryIncidentsOK  %+v", 200, o.Payload)
}

func (o *QueryIncidentsOK) String() string {
	return fmt.Sprintf("[GET /incidents/queries/incidents/v1][%d] queryIncidentsOK  %+v", 200, o.Payload)
}

func (o *QueryIncidentsOK) GetPayload() *models.DomainMsaIncidentQueryResponse {
	return o.Payload
}

func (o *QueryIncidentsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainMsaIncidentQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIncidentsBadRequest creates a QueryIncidentsBadRequest with default headers values
func NewQueryIncidentsBadRequest() *QueryIncidentsBadRequest {
	return &QueryIncidentsBadRequest{}
}

/*
QueryIncidentsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryIncidentsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query incidents bad request response has a 2xx status code
func (o *QueryIncidentsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query incidents bad request response has a 3xx status code
func (o *QueryIncidentsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query incidents bad request response has a 4xx status code
func (o *QueryIncidentsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query incidents bad request response has a 5xx status code
func (o *QueryIncidentsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query incidents bad request response a status code equal to that given
func (o *QueryIncidentsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query incidents bad request response
func (o *QueryIncidentsBadRequest) Code() int {
	return 400
}

func (o *QueryIncidentsBadRequest) Error() string {
	return fmt.Sprintf("[GET /incidents/queries/incidents/v1][%d] queryIncidentsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryIncidentsBadRequest) String() string {
	return fmt.Sprintf("[GET /incidents/queries/incidents/v1][%d] queryIncidentsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryIncidentsBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryIncidentsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIncidentsForbidden creates a QueryIncidentsForbidden with default headers values
func NewQueryIncidentsForbidden() *QueryIncidentsForbidden {
	return &QueryIncidentsForbidden{}
}

/*
QueryIncidentsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryIncidentsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query incidents forbidden response has a 2xx status code
func (o *QueryIncidentsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query incidents forbidden response has a 3xx status code
func (o *QueryIncidentsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query incidents forbidden response has a 4xx status code
func (o *QueryIncidentsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query incidents forbidden response has a 5xx status code
func (o *QueryIncidentsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query incidents forbidden response a status code equal to that given
func (o *QueryIncidentsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query incidents forbidden response
func (o *QueryIncidentsForbidden) Code() int {
	return 403
}

func (o *QueryIncidentsForbidden) Error() string {
	return fmt.Sprintf("[GET /incidents/queries/incidents/v1][%d] queryIncidentsForbidden  %+v", 403, o.Payload)
}

func (o *QueryIncidentsForbidden) String() string {
	return fmt.Sprintf("[GET /incidents/queries/incidents/v1][%d] queryIncidentsForbidden  %+v", 403, o.Payload)
}

func (o *QueryIncidentsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryIncidentsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIncidentsTooManyRequests creates a QueryIncidentsTooManyRequests with default headers values
func NewQueryIncidentsTooManyRequests() *QueryIncidentsTooManyRequests {
	return &QueryIncidentsTooManyRequests{}
}

/*
QueryIncidentsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryIncidentsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query incidents too many requests response has a 2xx status code
func (o *QueryIncidentsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query incidents too many requests response has a 3xx status code
func (o *QueryIncidentsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query incidents too many requests response has a 4xx status code
func (o *QueryIncidentsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query incidents too many requests response has a 5xx status code
func (o *QueryIncidentsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query incidents too many requests response a status code equal to that given
func (o *QueryIncidentsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query incidents too many requests response
func (o *QueryIncidentsTooManyRequests) Code() int {
	return 429
}

func (o *QueryIncidentsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /incidents/queries/incidents/v1][%d] queryIncidentsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryIncidentsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /incidents/queries/incidents/v1][%d] queryIncidentsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryIncidentsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryIncidentsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIncidentsInternalServerError creates a QueryIncidentsInternalServerError with default headers values
func NewQueryIncidentsInternalServerError() *QueryIncidentsInternalServerError {
	return &QueryIncidentsInternalServerError{}
}

/*
QueryIncidentsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryIncidentsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query incidents internal server error response has a 2xx status code
func (o *QueryIncidentsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query incidents internal server error response has a 3xx status code
func (o *QueryIncidentsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query incidents internal server error response has a 4xx status code
func (o *QueryIncidentsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query incidents internal server error response has a 5xx status code
func (o *QueryIncidentsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query incidents internal server error response a status code equal to that given
func (o *QueryIncidentsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query incidents internal server error response
func (o *QueryIncidentsInternalServerError) Code() int {
	return 500
}

func (o *QueryIncidentsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /incidents/queries/incidents/v1][%d] queryIncidentsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryIncidentsInternalServerError) String() string {
	return fmt.Sprintf("[GET /incidents/queries/incidents/v1][%d] queryIncidentsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryIncidentsInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryIncidentsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
