// Code generated by go-swagger; DO NOT EDIT.

package installation_tokens

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAuditEventsQueryParams creates a new AuditEventsQueryParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAuditEventsQueryParams() *AuditEventsQueryParams {
	return &AuditEventsQueryParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAuditEventsQueryParamsWithTimeout creates a new AuditEventsQueryParams object
// with the ability to set a timeout on a request.
func NewAuditEventsQueryParamsWithTimeout(timeout time.Duration) *AuditEventsQueryParams {
	return &AuditEventsQueryParams{
		timeout: timeout,
	}
}

// NewAuditEventsQueryParamsWithContext creates a new AuditEventsQueryParams object
// with the ability to set a context for a request.
func NewAuditEventsQueryParamsWithContext(ctx context.Context) *AuditEventsQueryParams {
	return &AuditEventsQueryParams{
		Context: ctx,
	}
}

// NewAuditEventsQueryParamsWithHTTPClient creates a new AuditEventsQueryParams object
// with the ability to set a custom HTTPClient for a request.
func NewAuditEventsQueryParamsWithHTTPClient(client *http.Client) *AuditEventsQueryParams {
	return &AuditEventsQueryParams{
		HTTPClient: client,
	}
}

/*
AuditEventsQueryParams contains all the parameters to send to the API endpoint

	for the audit events query operation.

	Typically these are written to a http.Request.
*/
type AuditEventsQueryParams struct {

	/* Filter.

	   The filter expression that should be used to limit the results (e.g., `action:'token_create'`).
	*/
	Filter *string

	/* Limit.

	   The maximum records to return. [1-1000]. Defaults to 50.
	*/
	Limit *int64

	/* Offset.

	   The offset to start retrieving records from.
	*/
	Offset *int64

	/* Sort.

	   The property to sort by (e.g. timestamp.desc).
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the audit events query params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AuditEventsQueryParams) WithDefaults() *AuditEventsQueryParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the audit events query params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AuditEventsQueryParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the audit events query params
func (o *AuditEventsQueryParams) WithTimeout(timeout time.Duration) *AuditEventsQueryParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the audit events query params
func (o *AuditEventsQueryParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the audit events query params
func (o *AuditEventsQueryParams) WithContext(ctx context.Context) *AuditEventsQueryParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the audit events query params
func (o *AuditEventsQueryParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the audit events query params
func (o *AuditEventsQueryParams) WithHTTPClient(client *http.Client) *AuditEventsQueryParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the audit events query params
func (o *AuditEventsQueryParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the audit events query params
func (o *AuditEventsQueryParams) WithFilter(filter *string) *AuditEventsQueryParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the audit events query params
func (o *AuditEventsQueryParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the audit events query params
func (o *AuditEventsQueryParams) WithLimit(limit *int64) *AuditEventsQueryParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the audit events query params
func (o *AuditEventsQueryParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the audit events query params
func (o *AuditEventsQueryParams) WithOffset(offset *int64) *AuditEventsQueryParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the audit events query params
func (o *AuditEventsQueryParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithSort adds the sort to the audit events query params
func (o *AuditEventsQueryParams) WithSort(sort *string) *AuditEventsQueryParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the audit events query params
func (o *AuditEventsQueryParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *AuditEventsQueryParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
