// Code generated by go-swagger; DO NOT EDIT.

package installation_tokens

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAuditEventsReadParams creates a new AuditEventsReadParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAuditEventsReadParams() *AuditEventsReadParams {
	return &AuditEventsReadParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAuditEventsReadParamsWithTimeout creates a new AuditEventsReadParams object
// with the ability to set a timeout on a request.
func NewAuditEventsReadParamsWithTimeout(timeout time.Duration) *AuditEventsReadParams {
	return &AuditEventsReadParams{
		timeout: timeout,
	}
}

// NewAuditEventsReadParamsWithContext creates a new AuditEventsReadParams object
// with the ability to set a context for a request.
func NewAuditEventsReadParamsWithContext(ctx context.Context) *AuditEventsReadParams {
	return &AuditEventsReadParams{
		Context: ctx,
	}
}

// NewAuditEventsReadParamsWithHTTPClient creates a new AuditEventsReadParams object
// with the ability to set a custom HTTPClient for a request.
func NewAuditEventsReadParamsWithHTTPClient(client *http.Client) *AuditEventsReadParams {
	return &AuditEventsReadParams{
		HTTPClient: client,
	}
}

/*
AuditEventsReadParams contains all the parameters to send to the API endpoint

	for the audit events read operation.

	Typically these are written to a http.Request.
*/
type AuditEventsReadParams struct {

	/* Ids.

	   IDs of audit events to retrieve details for
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the audit events read params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AuditEventsReadParams) WithDefaults() *AuditEventsReadParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the audit events read params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AuditEventsReadParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the audit events read params
func (o *AuditEventsReadParams) WithTimeout(timeout time.Duration) *AuditEventsReadParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the audit events read params
func (o *AuditEventsReadParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the audit events read params
func (o *AuditEventsReadParams) WithContext(ctx context.Context) *AuditEventsReadParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the audit events read params
func (o *AuditEventsReadParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the audit events read params
func (o *AuditEventsReadParams) WithHTTPClient(client *http.Client) *AuditEventsReadParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the audit events read params
func (o *AuditEventsReadParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the audit events read params
func (o *AuditEventsReadParams) WithIds(ids []string) *AuditEventsReadParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the audit events read params
func (o *AuditEventsReadParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *AuditEventsReadParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamAuditEventsRead binds the parameter ids
func (o *AuditEventsReadParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
