// Code generated by go-swagger; DO NOT EDIT.

package installation_tokens

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// AuditEventsReadReader is a Reader for the AuditEventsRead structure.
type AuditEventsReadReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AuditEventsReadReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAuditEventsReadOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewAuditEventsReadBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewAuditEventsReadForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewAuditEventsReadTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewAuditEventsReadInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /installation-tokens/entities/audit-events/v1] audit-events-read", response, response.Code())
	}
}

// NewAuditEventsReadOK creates a AuditEventsReadOK with default headers values
func NewAuditEventsReadOK() *AuditEventsReadOK {
	return &AuditEventsReadOK{}
}

/*
AuditEventsReadOK describes a response with status code 200, with default header values.

OK
*/
type AuditEventsReadOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.APIAuditEventDetailsResponseV1
}

// IsSuccess returns true when this audit events read o k response has a 2xx status code
func (o *AuditEventsReadOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this audit events read o k response has a 3xx status code
func (o *AuditEventsReadOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this audit events read o k response has a 4xx status code
func (o *AuditEventsReadOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this audit events read o k response has a 5xx status code
func (o *AuditEventsReadOK) IsServerError() bool {
	return false
}

// IsCode returns true when this audit events read o k response a status code equal to that given
func (o *AuditEventsReadOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the audit events read o k response
func (o *AuditEventsReadOK) Code() int {
	return 200
}

func (o *AuditEventsReadOK) Error() string {
	return fmt.Sprintf("[GET /installation-tokens/entities/audit-events/v1][%d] auditEventsReadOK  %+v", 200, o.Payload)
}

func (o *AuditEventsReadOK) String() string {
	return fmt.Sprintf("[GET /installation-tokens/entities/audit-events/v1][%d] auditEventsReadOK  %+v", 200, o.Payload)
}

func (o *AuditEventsReadOK) GetPayload() *models.APIAuditEventDetailsResponseV1 {
	return o.Payload
}

func (o *AuditEventsReadOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.APIAuditEventDetailsResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAuditEventsReadBadRequest creates a AuditEventsReadBadRequest with default headers values
func NewAuditEventsReadBadRequest() *AuditEventsReadBadRequest {
	return &AuditEventsReadBadRequest{}
}

/*
AuditEventsReadBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type AuditEventsReadBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this audit events read bad request response has a 2xx status code
func (o *AuditEventsReadBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this audit events read bad request response has a 3xx status code
func (o *AuditEventsReadBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this audit events read bad request response has a 4xx status code
func (o *AuditEventsReadBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this audit events read bad request response has a 5xx status code
func (o *AuditEventsReadBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this audit events read bad request response a status code equal to that given
func (o *AuditEventsReadBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the audit events read bad request response
func (o *AuditEventsReadBadRequest) Code() int {
	return 400
}

func (o *AuditEventsReadBadRequest) Error() string {
	return fmt.Sprintf("[GET /installation-tokens/entities/audit-events/v1][%d] auditEventsReadBadRequest  %+v", 400, o.Payload)
}

func (o *AuditEventsReadBadRequest) String() string {
	return fmt.Sprintf("[GET /installation-tokens/entities/audit-events/v1][%d] auditEventsReadBadRequest  %+v", 400, o.Payload)
}

func (o *AuditEventsReadBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AuditEventsReadBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAuditEventsReadForbidden creates a AuditEventsReadForbidden with default headers values
func NewAuditEventsReadForbidden() *AuditEventsReadForbidden {
	return &AuditEventsReadForbidden{}
}

/*
AuditEventsReadForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type AuditEventsReadForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this audit events read forbidden response has a 2xx status code
func (o *AuditEventsReadForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this audit events read forbidden response has a 3xx status code
func (o *AuditEventsReadForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this audit events read forbidden response has a 4xx status code
func (o *AuditEventsReadForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this audit events read forbidden response has a 5xx status code
func (o *AuditEventsReadForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this audit events read forbidden response a status code equal to that given
func (o *AuditEventsReadForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the audit events read forbidden response
func (o *AuditEventsReadForbidden) Code() int {
	return 403
}

func (o *AuditEventsReadForbidden) Error() string {
	return fmt.Sprintf("[GET /installation-tokens/entities/audit-events/v1][%d] auditEventsReadForbidden  %+v", 403, o.Payload)
}

func (o *AuditEventsReadForbidden) String() string {
	return fmt.Sprintf("[GET /installation-tokens/entities/audit-events/v1][%d] auditEventsReadForbidden  %+v", 403, o.Payload)
}

func (o *AuditEventsReadForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AuditEventsReadForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAuditEventsReadTooManyRequests creates a AuditEventsReadTooManyRequests with default headers values
func NewAuditEventsReadTooManyRequests() *AuditEventsReadTooManyRequests {
	return &AuditEventsReadTooManyRequests{}
}

/*
AuditEventsReadTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type AuditEventsReadTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this audit events read too many requests response has a 2xx status code
func (o *AuditEventsReadTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this audit events read too many requests response has a 3xx status code
func (o *AuditEventsReadTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this audit events read too many requests response has a 4xx status code
func (o *AuditEventsReadTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this audit events read too many requests response has a 5xx status code
func (o *AuditEventsReadTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this audit events read too many requests response a status code equal to that given
func (o *AuditEventsReadTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the audit events read too many requests response
func (o *AuditEventsReadTooManyRequests) Code() int {
	return 429
}

func (o *AuditEventsReadTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /installation-tokens/entities/audit-events/v1][%d] auditEventsReadTooManyRequests  %+v", 429, o.Payload)
}

func (o *AuditEventsReadTooManyRequests) String() string {
	return fmt.Sprintf("[GET /installation-tokens/entities/audit-events/v1][%d] auditEventsReadTooManyRequests  %+v", 429, o.Payload)
}

func (o *AuditEventsReadTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AuditEventsReadTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAuditEventsReadInternalServerError creates a AuditEventsReadInternalServerError with default headers values
func NewAuditEventsReadInternalServerError() *AuditEventsReadInternalServerError {
	return &AuditEventsReadInternalServerError{}
}

/*
AuditEventsReadInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type AuditEventsReadInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this audit events read internal server error response has a 2xx status code
func (o *AuditEventsReadInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this audit events read internal server error response has a 3xx status code
func (o *AuditEventsReadInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this audit events read internal server error response has a 4xx status code
func (o *AuditEventsReadInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this audit events read internal server error response has a 5xx status code
func (o *AuditEventsReadInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this audit events read internal server error response a status code equal to that given
func (o *AuditEventsReadInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the audit events read internal server error response
func (o *AuditEventsReadInternalServerError) Code() int {
	return 500
}

func (o *AuditEventsReadInternalServerError) Error() string {
	return fmt.Sprintf("[GET /installation-tokens/entities/audit-events/v1][%d] auditEventsReadInternalServerError  %+v", 500, o.Payload)
}

func (o *AuditEventsReadInternalServerError) String() string {
	return fmt.Sprintf("[GET /installation-tokens/entities/audit-events/v1][%d] auditEventsReadInternalServerError  %+v", 500, o.Payload)
}

func (o *AuditEventsReadInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AuditEventsReadInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
