// Code generated by go-swagger; DO NOT EDIT.

package installation_tokens

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new installation tokens API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for installation tokens API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AuditEventsQuery(params *AuditEventsQueryParams, opts ...ClientOption) (*AuditEventsQueryOK, error)

	AuditEventsRead(params *AuditEventsReadParams, opts ...ClientOption) (*AuditEventsReadOK, error)

	CustomerSettingsRead(params *CustomerSettingsReadParams, opts ...ClientOption) (*CustomerSettingsReadOK, error)

	TokensCreate(params *TokensCreateParams, opts ...ClientOption) (*TokensCreateCreated, error)

	TokensDelete(params *TokensDeleteParams, opts ...ClientOption) (*TokensDeleteOK, error)

	TokensQuery(params *TokensQueryParams, opts ...ClientOption) (*TokensQueryOK, error)

	TokensRead(params *TokensReadParams, opts ...ClientOption) (*TokensReadOK, error)

	TokensUpdate(params *TokensUpdateParams, opts ...ClientOption) (*TokensUpdateOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AuditEventsQuery searches for audit events by providing an f q l filter and paging details
*/
func (a *Client) AuditEventsQuery(params *AuditEventsQueryParams, opts ...ClientOption) (*AuditEventsQueryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAuditEventsQueryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "audit-events-query",
		Method:             "GET",
		PathPattern:        "/installation-tokens/queries/audit-events/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AuditEventsQueryReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AuditEventsQueryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for audit-events-query: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AuditEventsRead gets the details of one or more audit events by id
*/
func (a *Client) AuditEventsRead(params *AuditEventsReadParams, opts ...ClientOption) (*AuditEventsReadOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAuditEventsReadParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "audit-events-read",
		Method:             "GET",
		PathPattern:        "/installation-tokens/entities/audit-events/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AuditEventsReadReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AuditEventsReadOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for audit-events-read: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CustomerSettingsRead checks current installation token settings
*/
func (a *Client) CustomerSettingsRead(params *CustomerSettingsReadParams, opts ...ClientOption) (*CustomerSettingsReadOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCustomerSettingsReadParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "customer-settings-read",
		Method:             "GET",
		PathPattern:        "/installation-tokens/entities/customer-settings/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CustomerSettingsReadReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CustomerSettingsReadOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for customer-settings-read: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
TokensCreate creates a token
*/
func (a *Client) TokensCreate(params *TokensCreateParams, opts ...ClientOption) (*TokensCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTokensCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "tokens-create",
		Method:             "POST",
		PathPattern:        "/installation-tokens/entities/tokens/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TokensCreateReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TokensCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for tokens-create: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
TokensDelete deletes a token immediately to revoke a token use p a t c h installation tokens entities tokens v1 instead
*/
func (a *Client) TokensDelete(params *TokensDeleteParams, opts ...ClientOption) (*TokensDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTokensDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "tokens-delete",
		Method:             "DELETE",
		PathPattern:        "/installation-tokens/entities/tokens/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TokensDeleteReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TokensDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for tokens-delete: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
TokensQuery searches for tokens by providing an f q l filter and paging details
*/
func (a *Client) TokensQuery(params *TokensQueryParams, opts ...ClientOption) (*TokensQueryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTokensQueryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "tokens-query",
		Method:             "GET",
		PathPattern:        "/installation-tokens/queries/tokens/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TokensQueryReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TokensQueryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for tokens-query: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
TokensRead gets the details of one or more tokens by id
*/
func (a *Client) TokensRead(params *TokensReadParams, opts ...ClientOption) (*TokensReadOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTokensReadParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "tokens-read",
		Method:             "GET",
		PathPattern:        "/installation-tokens/entities/tokens/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TokensReadReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TokensReadOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for tokens-read: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
TokensUpdate updates one or more tokens use this endpoint to edit labels change expiration revoke or restore
*/
func (a *Client) TokensUpdate(params *TokensUpdateParams, opts ...ClientOption) (*TokensUpdateOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTokensUpdateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "tokens-update",
		Method:             "PATCH",
		PathPattern:        "/installation-tokens/entities/tokens/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TokensUpdateReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TokensUpdateOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for tokens-update: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
