// Code generated by go-swagger; DO NOT EDIT.

package installation_tokens

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// TokensCreateReader is a Reader for the TokensCreate structure.
type TokensCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TokensCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewTokensCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewTokensCreateBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewTokensCreateForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewTokensCreateTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewTokensCreateInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /installation-tokens/entities/tokens/v1] tokens-create", response, response.Code())
	}
}

// NewTokensCreateCreated creates a TokensCreateCreated with default headers values
func NewTokensCreateCreated() *TokensCreateCreated {
	return &TokensCreateCreated{}
}

/*
TokensCreateCreated describes a response with status code 201, with default header values.

Created
*/
type TokensCreateCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.APITokenDetailsResponseV1
}

// IsSuccess returns true when this tokens create created response has a 2xx status code
func (o *TokensCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this tokens create created response has a 3xx status code
func (o *TokensCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tokens create created response has a 4xx status code
func (o *TokensCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this tokens create created response has a 5xx status code
func (o *TokensCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this tokens create created response a status code equal to that given
func (o *TokensCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the tokens create created response
func (o *TokensCreateCreated) Code() int {
	return 201
}

func (o *TokensCreateCreated) Error() string {
	return fmt.Sprintf("[POST /installation-tokens/entities/tokens/v1][%d] tokensCreateCreated  %+v", 201, o.Payload)
}

func (o *TokensCreateCreated) String() string {
	return fmt.Sprintf("[POST /installation-tokens/entities/tokens/v1][%d] tokensCreateCreated  %+v", 201, o.Payload)
}

func (o *TokensCreateCreated) GetPayload() *models.APITokenDetailsResponseV1 {
	return o.Payload
}

func (o *TokensCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.APITokenDetailsResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTokensCreateBadRequest creates a TokensCreateBadRequest with default headers values
func NewTokensCreateBadRequest() *TokensCreateBadRequest {
	return &TokensCreateBadRequest{}
}

/*
TokensCreateBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type TokensCreateBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this tokens create bad request response has a 2xx status code
func (o *TokensCreateBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tokens create bad request response has a 3xx status code
func (o *TokensCreateBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tokens create bad request response has a 4xx status code
func (o *TokensCreateBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this tokens create bad request response has a 5xx status code
func (o *TokensCreateBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this tokens create bad request response a status code equal to that given
func (o *TokensCreateBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the tokens create bad request response
func (o *TokensCreateBadRequest) Code() int {
	return 400
}

func (o *TokensCreateBadRequest) Error() string {
	return fmt.Sprintf("[POST /installation-tokens/entities/tokens/v1][%d] tokensCreateBadRequest  %+v", 400, o.Payload)
}

func (o *TokensCreateBadRequest) String() string {
	return fmt.Sprintf("[POST /installation-tokens/entities/tokens/v1][%d] tokensCreateBadRequest  %+v", 400, o.Payload)
}

func (o *TokensCreateBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *TokensCreateBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTokensCreateForbidden creates a TokensCreateForbidden with default headers values
func NewTokensCreateForbidden() *TokensCreateForbidden {
	return &TokensCreateForbidden{}
}

/*
TokensCreateForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type TokensCreateForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this tokens create forbidden response has a 2xx status code
func (o *TokensCreateForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tokens create forbidden response has a 3xx status code
func (o *TokensCreateForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tokens create forbidden response has a 4xx status code
func (o *TokensCreateForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this tokens create forbidden response has a 5xx status code
func (o *TokensCreateForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this tokens create forbidden response a status code equal to that given
func (o *TokensCreateForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the tokens create forbidden response
func (o *TokensCreateForbidden) Code() int {
	return 403
}

func (o *TokensCreateForbidden) Error() string {
	return fmt.Sprintf("[POST /installation-tokens/entities/tokens/v1][%d] tokensCreateForbidden  %+v", 403, o.Payload)
}

func (o *TokensCreateForbidden) String() string {
	return fmt.Sprintf("[POST /installation-tokens/entities/tokens/v1][%d] tokensCreateForbidden  %+v", 403, o.Payload)
}

func (o *TokensCreateForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *TokensCreateForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTokensCreateTooManyRequests creates a TokensCreateTooManyRequests with default headers values
func NewTokensCreateTooManyRequests() *TokensCreateTooManyRequests {
	return &TokensCreateTooManyRequests{}
}

/*
TokensCreateTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type TokensCreateTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this tokens create too many requests response has a 2xx status code
func (o *TokensCreateTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tokens create too many requests response has a 3xx status code
func (o *TokensCreateTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tokens create too many requests response has a 4xx status code
func (o *TokensCreateTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this tokens create too many requests response has a 5xx status code
func (o *TokensCreateTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this tokens create too many requests response a status code equal to that given
func (o *TokensCreateTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the tokens create too many requests response
func (o *TokensCreateTooManyRequests) Code() int {
	return 429
}

func (o *TokensCreateTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /installation-tokens/entities/tokens/v1][%d] tokensCreateTooManyRequests  %+v", 429, o.Payload)
}

func (o *TokensCreateTooManyRequests) String() string {
	return fmt.Sprintf("[POST /installation-tokens/entities/tokens/v1][%d] tokensCreateTooManyRequests  %+v", 429, o.Payload)
}

func (o *TokensCreateTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *TokensCreateTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTokensCreateInternalServerError creates a TokensCreateInternalServerError with default headers values
func NewTokensCreateInternalServerError() *TokensCreateInternalServerError {
	return &TokensCreateInternalServerError{}
}

/*
TokensCreateInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type TokensCreateInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this tokens create internal server error response has a 2xx status code
func (o *TokensCreateInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tokens create internal server error response has a 3xx status code
func (o *TokensCreateInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tokens create internal server error response has a 4xx status code
func (o *TokensCreateInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this tokens create internal server error response has a 5xx status code
func (o *TokensCreateInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this tokens create internal server error response a status code equal to that given
func (o *TokensCreateInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the tokens create internal server error response
func (o *TokensCreateInternalServerError) Code() int {
	return 500
}

func (o *TokensCreateInternalServerError) Error() string {
	return fmt.Sprintf("[POST /installation-tokens/entities/tokens/v1][%d] tokensCreateInternalServerError  %+v", 500, o.Payload)
}

func (o *TokensCreateInternalServerError) String() string {
	return fmt.Sprintf("[POST /installation-tokens/entities/tokens/v1][%d] tokensCreateInternalServerError  %+v", 500, o.Payload)
}

func (o *TokensCreateInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *TokensCreateInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
