// Code generated by go-swagger; DO NOT EDIT.

package installation_tokens

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewTokensQueryParams creates a new TokensQueryParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTokensQueryParams() *TokensQueryParams {
	return &TokensQueryParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTokensQueryParamsWithTimeout creates a new TokensQueryParams object
// with the ability to set a timeout on a request.
func NewTokensQueryParamsWithTimeout(timeout time.Duration) *TokensQueryParams {
	return &TokensQueryParams{
		timeout: timeout,
	}
}

// NewTokensQueryParamsWithContext creates a new TokensQueryParams object
// with the ability to set a context for a request.
func NewTokensQueryParamsWithContext(ctx context.Context) *TokensQueryParams {
	return &TokensQueryParams{
		Context: ctx,
	}
}

// NewTokensQueryParamsWithHTTPClient creates a new TokensQueryParams object
// with the ability to set a custom HTTPClient for a request.
func NewTokensQueryParamsWithHTTPClient(client *http.Client) *TokensQueryParams {
	return &TokensQueryParams{
		HTTPClient: client,
	}
}

/*
TokensQueryParams contains all the parameters to send to the API endpoint

	for the tokens query operation.

	Typically these are written to a http.Request.
*/
type TokensQueryParams struct {

	/* Filter.

	   The filter expression that should be used to limit the results (e.g., `status:'valid'`).
	*/
	Filter *string

	/* Limit.

	   The maximum records to return. [1-1000]. Defaults to 50.
	*/
	Limit *int64

	/* Offset.

	   The offset to start retrieving records from.
	*/
	Offset *int64

	/* Sort.

	   The property to sort by (e.g. created_timestamp.desc).
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the tokens query params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TokensQueryParams) WithDefaults() *TokensQueryParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the tokens query params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TokensQueryParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the tokens query params
func (o *TokensQueryParams) WithTimeout(timeout time.Duration) *TokensQueryParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the tokens query params
func (o *TokensQueryParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the tokens query params
func (o *TokensQueryParams) WithContext(ctx context.Context) *TokensQueryParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the tokens query params
func (o *TokensQueryParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the tokens query params
func (o *TokensQueryParams) WithHTTPClient(client *http.Client) *TokensQueryParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the tokens query params
func (o *TokensQueryParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the tokens query params
func (o *TokensQueryParams) WithFilter(filter *string) *TokensQueryParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the tokens query params
func (o *TokensQueryParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the tokens query params
func (o *TokensQueryParams) WithLimit(limit *int64) *TokensQueryParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the tokens query params
func (o *TokensQueryParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the tokens query params
func (o *TokensQueryParams) WithOffset(offset *int64) *TokensQueryParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the tokens query params
func (o *TokensQueryParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithSort adds the sort to the tokens query params
func (o *TokensQueryParams) WithSort(sort *string) *TokensQueryParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the tokens query params
func (o *TokensQueryParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *TokensQueryParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
