// Code generated by go-swagger; DO NOT EDIT.

package installation_tokens

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewTokensUpdateParams creates a new TokensUpdateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTokensUpdateParams() *TokensUpdateParams {
	return &TokensUpdateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTokensUpdateParamsWithTimeout creates a new TokensUpdateParams object
// with the ability to set a timeout on a request.
func NewTokensUpdateParamsWithTimeout(timeout time.Duration) *TokensUpdateParams {
	return &TokensUpdateParams{
		timeout: timeout,
	}
}

// NewTokensUpdateParamsWithContext creates a new TokensUpdateParams object
// with the ability to set a context for a request.
func NewTokensUpdateParamsWithContext(ctx context.Context) *TokensUpdateParams {
	return &TokensUpdateParams{
		Context: ctx,
	}
}

// NewTokensUpdateParamsWithHTTPClient creates a new TokensUpdateParams object
// with the ability to set a custom HTTPClient for a request.
func NewTokensUpdateParamsWithHTTPClient(client *http.Client) *TokensUpdateParams {
	return &TokensUpdateParams{
		HTTPClient: client,
	}
}

/*
TokensUpdateParams contains all the parameters to send to the API endpoint

	for the tokens update operation.

	Typically these are written to a http.Request.
*/
type TokensUpdateParams struct {

	// Body.
	Body *models.APITokenPatchRequestV1

	/* Ids.

	   The token ids to update.
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the tokens update params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TokensUpdateParams) WithDefaults() *TokensUpdateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the tokens update params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TokensUpdateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the tokens update params
func (o *TokensUpdateParams) WithTimeout(timeout time.Duration) *TokensUpdateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the tokens update params
func (o *TokensUpdateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the tokens update params
func (o *TokensUpdateParams) WithContext(ctx context.Context) *TokensUpdateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the tokens update params
func (o *TokensUpdateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the tokens update params
func (o *TokensUpdateParams) WithHTTPClient(client *http.Client) *TokensUpdateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the tokens update params
func (o *TokensUpdateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the tokens update params
func (o *TokensUpdateParams) WithBody(body *models.APITokenPatchRequestV1) *TokensUpdateParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the tokens update params
func (o *TokensUpdateParams) SetBody(body *models.APITokenPatchRequestV1) {
	o.Body = body
}

// WithIds adds the ids to the tokens update params
func (o *TokensUpdateParams) WithIds(ids []string) *TokensUpdateParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the tokens update params
func (o *TokensUpdateParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *TokensUpdateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamTokensUpdate binds the parameter ids
func (o *TokensUpdateParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "csv"
	idsIS := swag.JoinByFormat(idsIC, "csv")

	return idsIS
}
