// Code generated by go-swagger; DO NOT EDIT.

package installation_tokens

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// TokensUpdateReader is a Reader for the TokensUpdate structure.
type TokensUpdateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TokensUpdateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewTokensUpdateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewTokensUpdateBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewTokensUpdateForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewTokensUpdateNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewTokensUpdateTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewTokensUpdateInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /installation-tokens/entities/tokens/v1] tokens-update", response, response.Code())
	}
}

// NewTokensUpdateOK creates a TokensUpdateOK with default headers values
func NewTokensUpdateOK() *TokensUpdateOK {
	return &TokensUpdateOK{}
}

/*
TokensUpdateOK describes a response with status code 200, with default header values.

OK
*/
type TokensUpdateOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this tokens update o k response has a 2xx status code
func (o *TokensUpdateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this tokens update o k response has a 3xx status code
func (o *TokensUpdateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tokens update o k response has a 4xx status code
func (o *TokensUpdateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this tokens update o k response has a 5xx status code
func (o *TokensUpdateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this tokens update o k response a status code equal to that given
func (o *TokensUpdateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the tokens update o k response
func (o *TokensUpdateOK) Code() int {
	return 200
}

func (o *TokensUpdateOK) Error() string {
	return fmt.Sprintf("[PATCH /installation-tokens/entities/tokens/v1][%d] tokensUpdateOK  %+v", 200, o.Payload)
}

func (o *TokensUpdateOK) String() string {
	return fmt.Sprintf("[PATCH /installation-tokens/entities/tokens/v1][%d] tokensUpdateOK  %+v", 200, o.Payload)
}

func (o *TokensUpdateOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *TokensUpdateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTokensUpdateBadRequest creates a TokensUpdateBadRequest with default headers values
func NewTokensUpdateBadRequest() *TokensUpdateBadRequest {
	return &TokensUpdateBadRequest{}
}

/*
TokensUpdateBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type TokensUpdateBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this tokens update bad request response has a 2xx status code
func (o *TokensUpdateBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tokens update bad request response has a 3xx status code
func (o *TokensUpdateBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tokens update bad request response has a 4xx status code
func (o *TokensUpdateBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this tokens update bad request response has a 5xx status code
func (o *TokensUpdateBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this tokens update bad request response a status code equal to that given
func (o *TokensUpdateBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the tokens update bad request response
func (o *TokensUpdateBadRequest) Code() int {
	return 400
}

func (o *TokensUpdateBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /installation-tokens/entities/tokens/v1][%d] tokensUpdateBadRequest  %+v", 400, o.Payload)
}

func (o *TokensUpdateBadRequest) String() string {
	return fmt.Sprintf("[PATCH /installation-tokens/entities/tokens/v1][%d] tokensUpdateBadRequest  %+v", 400, o.Payload)
}

func (o *TokensUpdateBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *TokensUpdateBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTokensUpdateForbidden creates a TokensUpdateForbidden with default headers values
func NewTokensUpdateForbidden() *TokensUpdateForbidden {
	return &TokensUpdateForbidden{}
}

/*
TokensUpdateForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type TokensUpdateForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this tokens update forbidden response has a 2xx status code
func (o *TokensUpdateForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tokens update forbidden response has a 3xx status code
func (o *TokensUpdateForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tokens update forbidden response has a 4xx status code
func (o *TokensUpdateForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this tokens update forbidden response has a 5xx status code
func (o *TokensUpdateForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this tokens update forbidden response a status code equal to that given
func (o *TokensUpdateForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the tokens update forbidden response
func (o *TokensUpdateForbidden) Code() int {
	return 403
}

func (o *TokensUpdateForbidden) Error() string {
	return fmt.Sprintf("[PATCH /installation-tokens/entities/tokens/v1][%d] tokensUpdateForbidden  %+v", 403, o.Payload)
}

func (o *TokensUpdateForbidden) String() string {
	return fmt.Sprintf("[PATCH /installation-tokens/entities/tokens/v1][%d] tokensUpdateForbidden  %+v", 403, o.Payload)
}

func (o *TokensUpdateForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *TokensUpdateForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTokensUpdateNotFound creates a TokensUpdateNotFound with default headers values
func NewTokensUpdateNotFound() *TokensUpdateNotFound {
	return &TokensUpdateNotFound{}
}

/*
TokensUpdateNotFound describes a response with status code 404, with default header values.

Not Found
*/
type TokensUpdateNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this tokens update not found response has a 2xx status code
func (o *TokensUpdateNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tokens update not found response has a 3xx status code
func (o *TokensUpdateNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tokens update not found response has a 4xx status code
func (o *TokensUpdateNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this tokens update not found response has a 5xx status code
func (o *TokensUpdateNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this tokens update not found response a status code equal to that given
func (o *TokensUpdateNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the tokens update not found response
func (o *TokensUpdateNotFound) Code() int {
	return 404
}

func (o *TokensUpdateNotFound) Error() string {
	return fmt.Sprintf("[PATCH /installation-tokens/entities/tokens/v1][%d] tokensUpdateNotFound  %+v", 404, o.Payload)
}

func (o *TokensUpdateNotFound) String() string {
	return fmt.Sprintf("[PATCH /installation-tokens/entities/tokens/v1][%d] tokensUpdateNotFound  %+v", 404, o.Payload)
}

func (o *TokensUpdateNotFound) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *TokensUpdateNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTokensUpdateTooManyRequests creates a TokensUpdateTooManyRequests with default headers values
func NewTokensUpdateTooManyRequests() *TokensUpdateTooManyRequests {
	return &TokensUpdateTooManyRequests{}
}

/*
TokensUpdateTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type TokensUpdateTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this tokens update too many requests response has a 2xx status code
func (o *TokensUpdateTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tokens update too many requests response has a 3xx status code
func (o *TokensUpdateTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tokens update too many requests response has a 4xx status code
func (o *TokensUpdateTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this tokens update too many requests response has a 5xx status code
func (o *TokensUpdateTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this tokens update too many requests response a status code equal to that given
func (o *TokensUpdateTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the tokens update too many requests response
func (o *TokensUpdateTooManyRequests) Code() int {
	return 429
}

func (o *TokensUpdateTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /installation-tokens/entities/tokens/v1][%d] tokensUpdateTooManyRequests  %+v", 429, o.Payload)
}

func (o *TokensUpdateTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /installation-tokens/entities/tokens/v1][%d] tokensUpdateTooManyRequests  %+v", 429, o.Payload)
}

func (o *TokensUpdateTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *TokensUpdateTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTokensUpdateInternalServerError creates a TokensUpdateInternalServerError with default headers values
func NewTokensUpdateInternalServerError() *TokensUpdateInternalServerError {
	return &TokensUpdateInternalServerError{}
}

/*
TokensUpdateInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type TokensUpdateInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this tokens update internal server error response has a 2xx status code
func (o *TokensUpdateInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tokens update internal server error response has a 3xx status code
func (o *TokensUpdateInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tokens update internal server error response has a 4xx status code
func (o *TokensUpdateInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this tokens update internal server error response has a 5xx status code
func (o *TokensUpdateInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this tokens update internal server error response a status code equal to that given
func (o *TokensUpdateInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the tokens update internal server error response
func (o *TokensUpdateInternalServerError) Code() int {
	return 500
}

func (o *TokensUpdateInternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /installation-tokens/entities/tokens/v1][%d] tokensUpdateInternalServerError  %+v", 500, o.Payload)
}

func (o *TokensUpdateInternalServerError) String() string {
	return fmt.Sprintf("[PATCH /installation-tokens/entities/tokens/v1][%d] tokensUpdateInternalServerError  %+v", 500, o.Payload)
}

func (o *TokensUpdateInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *TokensUpdateInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
