// Code generated by go-swagger; DO NOT EDIT.

package installation_tokens_settings

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewCustomerSettingsUpdateParams creates a new CustomerSettingsUpdateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCustomerSettingsUpdateParams() *CustomerSettingsUpdateParams {
	return &CustomerSettingsUpdateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCustomerSettingsUpdateParamsWithTimeout creates a new CustomerSettingsUpdateParams object
// with the ability to set a timeout on a request.
func NewCustomerSettingsUpdateParamsWithTimeout(timeout time.Duration) *CustomerSettingsUpdateParams {
	return &CustomerSettingsUpdateParams{
		timeout: timeout,
	}
}

// NewCustomerSettingsUpdateParamsWithContext creates a new CustomerSettingsUpdateParams object
// with the ability to set a context for a request.
func NewCustomerSettingsUpdateParamsWithContext(ctx context.Context) *CustomerSettingsUpdateParams {
	return &CustomerSettingsUpdateParams{
		Context: ctx,
	}
}

// NewCustomerSettingsUpdateParamsWithHTTPClient creates a new CustomerSettingsUpdateParams object
// with the ability to set a custom HTTPClient for a request.
func NewCustomerSettingsUpdateParamsWithHTTPClient(client *http.Client) *CustomerSettingsUpdateParams {
	return &CustomerSettingsUpdateParams{
		HTTPClient: client,
	}
}

/*
CustomerSettingsUpdateParams contains all the parameters to send to the API endpoint

	for the customer settings update operation.

	Typically these are written to a http.Request.
*/
type CustomerSettingsUpdateParams struct {

	// Body.
	Body *models.APICustomerSettingsPatchRequestV1

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the customer settings update params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CustomerSettingsUpdateParams) WithDefaults() *CustomerSettingsUpdateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the customer settings update params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CustomerSettingsUpdateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the customer settings update params
func (o *CustomerSettingsUpdateParams) WithTimeout(timeout time.Duration) *CustomerSettingsUpdateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the customer settings update params
func (o *CustomerSettingsUpdateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the customer settings update params
func (o *CustomerSettingsUpdateParams) WithContext(ctx context.Context) *CustomerSettingsUpdateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the customer settings update params
func (o *CustomerSettingsUpdateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the customer settings update params
func (o *CustomerSettingsUpdateParams) WithHTTPClient(client *http.Client) *CustomerSettingsUpdateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the customer settings update params
func (o *CustomerSettingsUpdateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the customer settings update params
func (o *CustomerSettingsUpdateParams) WithBody(body *models.APICustomerSettingsPatchRequestV1) *CustomerSettingsUpdateParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the customer settings update params
func (o *CustomerSettingsUpdateParams) SetBody(body *models.APICustomerSettingsPatchRequestV1) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *CustomerSettingsUpdateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
