// Code generated by go-swagger; DO NOT EDIT.

package intel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetIntelActorEntitiesReader is a Reader for the GetIntelActorEntities structure.
type GetIntelActorEntitiesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetIntelActorEntitiesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetIntelActorEntitiesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetIntelActorEntitiesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetIntelActorEntitiesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetIntelActorEntitiesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /intel/entities/actors/v1] GetIntelActorEntities", response, response.Code())
	}
}

// NewGetIntelActorEntitiesOK creates a GetIntelActorEntitiesOK with default headers values
func NewGetIntelActorEntitiesOK() *GetIntelActorEntitiesOK {
	return &GetIntelActorEntitiesOK{}
}

/*
GetIntelActorEntitiesOK describes a response with status code 200, with default header values.

OK
*/
type GetIntelActorEntitiesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainActorsResponse
}

// IsSuccess returns true when this get intel actor entities o k response has a 2xx status code
func (o *GetIntelActorEntitiesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get intel actor entities o k response has a 3xx status code
func (o *GetIntelActorEntitiesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get intel actor entities o k response has a 4xx status code
func (o *GetIntelActorEntitiesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get intel actor entities o k response has a 5xx status code
func (o *GetIntelActorEntitiesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get intel actor entities o k response a status code equal to that given
func (o *GetIntelActorEntitiesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get intel actor entities o k response
func (o *GetIntelActorEntitiesOK) Code() int {
	return 200
}

func (o *GetIntelActorEntitiesOK) Error() string {
	return fmt.Sprintf("[GET /intel/entities/actors/v1][%d] getIntelActorEntitiesOK  %+v", 200, o.Payload)
}

func (o *GetIntelActorEntitiesOK) String() string {
	return fmt.Sprintf("[GET /intel/entities/actors/v1][%d] getIntelActorEntitiesOK  %+v", 200, o.Payload)
}

func (o *GetIntelActorEntitiesOK) GetPayload() *models.DomainActorsResponse {
	return o.Payload
}

func (o *GetIntelActorEntitiesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainActorsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIntelActorEntitiesForbidden creates a GetIntelActorEntitiesForbidden with default headers values
func NewGetIntelActorEntitiesForbidden() *GetIntelActorEntitiesForbidden {
	return &GetIntelActorEntitiesForbidden{}
}

/*
GetIntelActorEntitiesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetIntelActorEntitiesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get intel actor entities forbidden response has a 2xx status code
func (o *GetIntelActorEntitiesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get intel actor entities forbidden response has a 3xx status code
func (o *GetIntelActorEntitiesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get intel actor entities forbidden response has a 4xx status code
func (o *GetIntelActorEntitiesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get intel actor entities forbidden response has a 5xx status code
func (o *GetIntelActorEntitiesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get intel actor entities forbidden response a status code equal to that given
func (o *GetIntelActorEntitiesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get intel actor entities forbidden response
func (o *GetIntelActorEntitiesForbidden) Code() int {
	return 403
}

func (o *GetIntelActorEntitiesForbidden) Error() string {
	return fmt.Sprintf("[GET /intel/entities/actors/v1][%d] getIntelActorEntitiesForbidden  %+v", 403, o.Payload)
}

func (o *GetIntelActorEntitiesForbidden) String() string {
	return fmt.Sprintf("[GET /intel/entities/actors/v1][%d] getIntelActorEntitiesForbidden  %+v", 403, o.Payload)
}

func (o *GetIntelActorEntitiesForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetIntelActorEntitiesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIntelActorEntitiesTooManyRequests creates a GetIntelActorEntitiesTooManyRequests with default headers values
func NewGetIntelActorEntitiesTooManyRequests() *GetIntelActorEntitiesTooManyRequests {
	return &GetIntelActorEntitiesTooManyRequests{}
}

/*
GetIntelActorEntitiesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetIntelActorEntitiesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get intel actor entities too many requests response has a 2xx status code
func (o *GetIntelActorEntitiesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get intel actor entities too many requests response has a 3xx status code
func (o *GetIntelActorEntitiesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get intel actor entities too many requests response has a 4xx status code
func (o *GetIntelActorEntitiesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get intel actor entities too many requests response has a 5xx status code
func (o *GetIntelActorEntitiesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get intel actor entities too many requests response a status code equal to that given
func (o *GetIntelActorEntitiesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get intel actor entities too many requests response
func (o *GetIntelActorEntitiesTooManyRequests) Code() int {
	return 429
}

func (o *GetIntelActorEntitiesTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /intel/entities/actors/v1][%d] getIntelActorEntitiesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetIntelActorEntitiesTooManyRequests) String() string {
	return fmt.Sprintf("[GET /intel/entities/actors/v1][%d] getIntelActorEntitiesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetIntelActorEntitiesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetIntelActorEntitiesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIntelActorEntitiesInternalServerError creates a GetIntelActorEntitiesInternalServerError with default headers values
func NewGetIntelActorEntitiesInternalServerError() *GetIntelActorEntitiesInternalServerError {
	return &GetIntelActorEntitiesInternalServerError{}
}

/*
GetIntelActorEntitiesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetIntelActorEntitiesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get intel actor entities internal server error response has a 2xx status code
func (o *GetIntelActorEntitiesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get intel actor entities internal server error response has a 3xx status code
func (o *GetIntelActorEntitiesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get intel actor entities internal server error response has a 4xx status code
func (o *GetIntelActorEntitiesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get intel actor entities internal server error response has a 5xx status code
func (o *GetIntelActorEntitiesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get intel actor entities internal server error response a status code equal to that given
func (o *GetIntelActorEntitiesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get intel actor entities internal server error response
func (o *GetIntelActorEntitiesInternalServerError) Code() int {
	return 500
}

func (o *GetIntelActorEntitiesInternalServerError) Error() string {
	return fmt.Sprintf("[GET /intel/entities/actors/v1][%d] getIntelActorEntitiesInternalServerError  %+v", 500, o.Payload)
}

func (o *GetIntelActorEntitiesInternalServerError) String() string {
	return fmt.Sprintf("[GET /intel/entities/actors/v1][%d] getIntelActorEntitiesInternalServerError  %+v", 500, o.Payload)
}

func (o *GetIntelActorEntitiesInternalServerError) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetIntelActorEntitiesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
