// Code generated by go-swagger; DO NOT EDIT.

package intel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetIntelIndicatorEntitiesReader is a Reader for the GetIntelIndicatorEntities structure.
type GetIntelIndicatorEntitiesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetIntelIndicatorEntitiesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetIntelIndicatorEntitiesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetIntelIndicatorEntitiesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetIntelIndicatorEntitiesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetIntelIndicatorEntitiesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /intel/entities/indicators/GET/v1] GetIntelIndicatorEntities", response, response.Code())
	}
}

// NewGetIntelIndicatorEntitiesOK creates a GetIntelIndicatorEntitiesOK with default headers values
func NewGetIntelIndicatorEntitiesOK() *GetIntelIndicatorEntitiesOK {
	return &GetIntelIndicatorEntitiesOK{}
}

/*
GetIntelIndicatorEntitiesOK describes a response with status code 200, with default header values.

OK
*/
type GetIntelIndicatorEntitiesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainPublicIndicatorsV3Response
}

// IsSuccess returns true when this get intel indicator entities o k response has a 2xx status code
func (o *GetIntelIndicatorEntitiesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get intel indicator entities o k response has a 3xx status code
func (o *GetIntelIndicatorEntitiesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get intel indicator entities o k response has a 4xx status code
func (o *GetIntelIndicatorEntitiesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get intel indicator entities o k response has a 5xx status code
func (o *GetIntelIndicatorEntitiesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get intel indicator entities o k response a status code equal to that given
func (o *GetIntelIndicatorEntitiesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get intel indicator entities o k response
func (o *GetIntelIndicatorEntitiesOK) Code() int {
	return 200
}

func (o *GetIntelIndicatorEntitiesOK) Error() string {
	return fmt.Sprintf("[POST /intel/entities/indicators/GET/v1][%d] getIntelIndicatorEntitiesOK  %+v", 200, o.Payload)
}

func (o *GetIntelIndicatorEntitiesOK) String() string {
	return fmt.Sprintf("[POST /intel/entities/indicators/GET/v1][%d] getIntelIndicatorEntitiesOK  %+v", 200, o.Payload)
}

func (o *GetIntelIndicatorEntitiesOK) GetPayload() *models.DomainPublicIndicatorsV3Response {
	return o.Payload
}

func (o *GetIntelIndicatorEntitiesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainPublicIndicatorsV3Response)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIntelIndicatorEntitiesForbidden creates a GetIntelIndicatorEntitiesForbidden with default headers values
func NewGetIntelIndicatorEntitiesForbidden() *GetIntelIndicatorEntitiesForbidden {
	return &GetIntelIndicatorEntitiesForbidden{}
}

/*
GetIntelIndicatorEntitiesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetIntelIndicatorEntitiesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get intel indicator entities forbidden response has a 2xx status code
func (o *GetIntelIndicatorEntitiesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get intel indicator entities forbidden response has a 3xx status code
func (o *GetIntelIndicatorEntitiesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get intel indicator entities forbidden response has a 4xx status code
func (o *GetIntelIndicatorEntitiesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get intel indicator entities forbidden response has a 5xx status code
func (o *GetIntelIndicatorEntitiesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get intel indicator entities forbidden response a status code equal to that given
func (o *GetIntelIndicatorEntitiesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get intel indicator entities forbidden response
func (o *GetIntelIndicatorEntitiesForbidden) Code() int {
	return 403
}

func (o *GetIntelIndicatorEntitiesForbidden) Error() string {
	return fmt.Sprintf("[POST /intel/entities/indicators/GET/v1][%d] getIntelIndicatorEntitiesForbidden  %+v", 403, o.Payload)
}

func (o *GetIntelIndicatorEntitiesForbidden) String() string {
	return fmt.Sprintf("[POST /intel/entities/indicators/GET/v1][%d] getIntelIndicatorEntitiesForbidden  %+v", 403, o.Payload)
}

func (o *GetIntelIndicatorEntitiesForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetIntelIndicatorEntitiesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIntelIndicatorEntitiesTooManyRequests creates a GetIntelIndicatorEntitiesTooManyRequests with default headers values
func NewGetIntelIndicatorEntitiesTooManyRequests() *GetIntelIndicatorEntitiesTooManyRequests {
	return &GetIntelIndicatorEntitiesTooManyRequests{}
}

/*
GetIntelIndicatorEntitiesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetIntelIndicatorEntitiesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get intel indicator entities too many requests response has a 2xx status code
func (o *GetIntelIndicatorEntitiesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get intel indicator entities too many requests response has a 3xx status code
func (o *GetIntelIndicatorEntitiesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get intel indicator entities too many requests response has a 4xx status code
func (o *GetIntelIndicatorEntitiesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get intel indicator entities too many requests response has a 5xx status code
func (o *GetIntelIndicatorEntitiesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get intel indicator entities too many requests response a status code equal to that given
func (o *GetIntelIndicatorEntitiesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get intel indicator entities too many requests response
func (o *GetIntelIndicatorEntitiesTooManyRequests) Code() int {
	return 429
}

func (o *GetIntelIndicatorEntitiesTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /intel/entities/indicators/GET/v1][%d] getIntelIndicatorEntitiesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetIntelIndicatorEntitiesTooManyRequests) String() string {
	return fmt.Sprintf("[POST /intel/entities/indicators/GET/v1][%d] getIntelIndicatorEntitiesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetIntelIndicatorEntitiesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetIntelIndicatorEntitiesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIntelIndicatorEntitiesInternalServerError creates a GetIntelIndicatorEntitiesInternalServerError with default headers values
func NewGetIntelIndicatorEntitiesInternalServerError() *GetIntelIndicatorEntitiesInternalServerError {
	return &GetIntelIndicatorEntitiesInternalServerError{}
}

/*
GetIntelIndicatorEntitiesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetIntelIndicatorEntitiesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get intel indicator entities internal server error response has a 2xx status code
func (o *GetIntelIndicatorEntitiesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get intel indicator entities internal server error response has a 3xx status code
func (o *GetIntelIndicatorEntitiesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get intel indicator entities internal server error response has a 4xx status code
func (o *GetIntelIndicatorEntitiesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get intel indicator entities internal server error response has a 5xx status code
func (o *GetIntelIndicatorEntitiesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get intel indicator entities internal server error response a status code equal to that given
func (o *GetIntelIndicatorEntitiesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get intel indicator entities internal server error response
func (o *GetIntelIndicatorEntitiesInternalServerError) Code() int {
	return 500
}

func (o *GetIntelIndicatorEntitiesInternalServerError) Error() string {
	return fmt.Sprintf("[POST /intel/entities/indicators/GET/v1][%d] getIntelIndicatorEntitiesInternalServerError  %+v", 500, o.Payload)
}

func (o *GetIntelIndicatorEntitiesInternalServerError) String() string {
	return fmt.Sprintf("[POST /intel/entities/indicators/GET/v1][%d] getIntelIndicatorEntitiesInternalServerError  %+v", 500, o.Payload)
}

func (o *GetIntelIndicatorEntitiesInternalServerError) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetIntelIndicatorEntitiesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
