// Code generated by go-swagger; DO NOT EDIT.

package intel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetIntelReportEntitiesReader is a Reader for the GetIntelReportEntities structure.
type GetIntelReportEntitiesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetIntelReportEntitiesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetIntelReportEntitiesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetIntelReportEntitiesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetIntelReportEntitiesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetIntelReportEntitiesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /intel/entities/reports/v1] GetIntelReportEntities", response, response.Code())
	}
}

// NewGetIntelReportEntitiesOK creates a GetIntelReportEntitiesOK with default headers values
func NewGetIntelReportEntitiesOK() *GetIntelReportEntitiesOK {
	return &GetIntelReportEntitiesOK{}
}

/*
GetIntelReportEntitiesOK describes a response with status code 200, with default header values.

OK
*/
type GetIntelReportEntitiesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainNewsResponse
}

// IsSuccess returns true when this get intel report entities o k response has a 2xx status code
func (o *GetIntelReportEntitiesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get intel report entities o k response has a 3xx status code
func (o *GetIntelReportEntitiesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get intel report entities o k response has a 4xx status code
func (o *GetIntelReportEntitiesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get intel report entities o k response has a 5xx status code
func (o *GetIntelReportEntitiesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get intel report entities o k response a status code equal to that given
func (o *GetIntelReportEntitiesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get intel report entities o k response
func (o *GetIntelReportEntitiesOK) Code() int {
	return 200
}

func (o *GetIntelReportEntitiesOK) Error() string {
	return fmt.Sprintf("[GET /intel/entities/reports/v1][%d] getIntelReportEntitiesOK  %+v", 200, o.Payload)
}

func (o *GetIntelReportEntitiesOK) String() string {
	return fmt.Sprintf("[GET /intel/entities/reports/v1][%d] getIntelReportEntitiesOK  %+v", 200, o.Payload)
}

func (o *GetIntelReportEntitiesOK) GetPayload() *models.DomainNewsResponse {
	return o.Payload
}

func (o *GetIntelReportEntitiesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainNewsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIntelReportEntitiesForbidden creates a GetIntelReportEntitiesForbidden with default headers values
func NewGetIntelReportEntitiesForbidden() *GetIntelReportEntitiesForbidden {
	return &GetIntelReportEntitiesForbidden{}
}

/*
GetIntelReportEntitiesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetIntelReportEntitiesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get intel report entities forbidden response has a 2xx status code
func (o *GetIntelReportEntitiesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get intel report entities forbidden response has a 3xx status code
func (o *GetIntelReportEntitiesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get intel report entities forbidden response has a 4xx status code
func (o *GetIntelReportEntitiesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get intel report entities forbidden response has a 5xx status code
func (o *GetIntelReportEntitiesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get intel report entities forbidden response a status code equal to that given
func (o *GetIntelReportEntitiesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get intel report entities forbidden response
func (o *GetIntelReportEntitiesForbidden) Code() int {
	return 403
}

func (o *GetIntelReportEntitiesForbidden) Error() string {
	return fmt.Sprintf("[GET /intel/entities/reports/v1][%d] getIntelReportEntitiesForbidden  %+v", 403, o.Payload)
}

func (o *GetIntelReportEntitiesForbidden) String() string {
	return fmt.Sprintf("[GET /intel/entities/reports/v1][%d] getIntelReportEntitiesForbidden  %+v", 403, o.Payload)
}

func (o *GetIntelReportEntitiesForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetIntelReportEntitiesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIntelReportEntitiesTooManyRequests creates a GetIntelReportEntitiesTooManyRequests with default headers values
func NewGetIntelReportEntitiesTooManyRequests() *GetIntelReportEntitiesTooManyRequests {
	return &GetIntelReportEntitiesTooManyRequests{}
}

/*
GetIntelReportEntitiesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetIntelReportEntitiesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get intel report entities too many requests response has a 2xx status code
func (o *GetIntelReportEntitiesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get intel report entities too many requests response has a 3xx status code
func (o *GetIntelReportEntitiesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get intel report entities too many requests response has a 4xx status code
func (o *GetIntelReportEntitiesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get intel report entities too many requests response has a 5xx status code
func (o *GetIntelReportEntitiesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get intel report entities too many requests response a status code equal to that given
func (o *GetIntelReportEntitiesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get intel report entities too many requests response
func (o *GetIntelReportEntitiesTooManyRequests) Code() int {
	return 429
}

func (o *GetIntelReportEntitiesTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /intel/entities/reports/v1][%d] getIntelReportEntitiesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetIntelReportEntitiesTooManyRequests) String() string {
	return fmt.Sprintf("[GET /intel/entities/reports/v1][%d] getIntelReportEntitiesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetIntelReportEntitiesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetIntelReportEntitiesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIntelReportEntitiesInternalServerError creates a GetIntelReportEntitiesInternalServerError with default headers values
func NewGetIntelReportEntitiesInternalServerError() *GetIntelReportEntitiesInternalServerError {
	return &GetIntelReportEntitiesInternalServerError{}
}

/*
GetIntelReportEntitiesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetIntelReportEntitiesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get intel report entities internal server error response has a 2xx status code
func (o *GetIntelReportEntitiesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get intel report entities internal server error response has a 3xx status code
func (o *GetIntelReportEntitiesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get intel report entities internal server error response has a 4xx status code
func (o *GetIntelReportEntitiesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get intel report entities internal server error response has a 5xx status code
func (o *GetIntelReportEntitiesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get intel report entities internal server error response a status code equal to that given
func (o *GetIntelReportEntitiesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get intel report entities internal server error response
func (o *GetIntelReportEntitiesInternalServerError) Code() int {
	return 500
}

func (o *GetIntelReportEntitiesInternalServerError) Error() string {
	return fmt.Sprintf("[GET /intel/entities/reports/v1][%d] getIntelReportEntitiesInternalServerError  %+v", 500, o.Payload)
}

func (o *GetIntelReportEntitiesInternalServerError) String() string {
	return fmt.Sprintf("[GET /intel/entities/reports/v1][%d] getIntelReportEntitiesInternalServerError  %+v", 500, o.Payload)
}

func (o *GetIntelReportEntitiesInternalServerError) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetIntelReportEntitiesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
