// Code generated by go-swagger; DO NOT EDIT.

package intel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetIntelRuleFileParams creates a new GetIntelRuleFileParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetIntelRuleFileParams() *GetIntelRuleFileParams {
	return &GetIntelRuleFileParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetIntelRuleFileParamsWithTimeout creates a new GetIntelRuleFileParams object
// with the ability to set a timeout on a request.
func NewGetIntelRuleFileParamsWithTimeout(timeout time.Duration) *GetIntelRuleFileParams {
	return &GetIntelRuleFileParams{
		timeout: timeout,
	}
}

// NewGetIntelRuleFileParamsWithContext creates a new GetIntelRuleFileParams object
// with the ability to set a context for a request.
func NewGetIntelRuleFileParamsWithContext(ctx context.Context) *GetIntelRuleFileParams {
	return &GetIntelRuleFileParams{
		Context: ctx,
	}
}

// NewGetIntelRuleFileParamsWithHTTPClient creates a new GetIntelRuleFileParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetIntelRuleFileParamsWithHTTPClient(client *http.Client) *GetIntelRuleFileParams {
	return &GetIntelRuleFileParams{
		HTTPClient: client,
	}
}

/*
GetIntelRuleFileParams contains all the parameters to send to the API endpoint

	for the get intel rule file operation.

	Typically these are written to a http.Request.
*/
type GetIntelRuleFileParams struct {

	/* Accept.

	   Choose the format you want the rule set in.
	*/
	Accept *string

	/* Format.

	   Choose the format you want the rule set in. Valid formats are zip and gzip. Defaults to zip.
	*/
	Format *string

	/* ID.

	   The ID of the rule set.
	*/
	ID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get intel rule file params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetIntelRuleFileParams) WithDefaults() *GetIntelRuleFileParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get intel rule file params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetIntelRuleFileParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get intel rule file params
func (o *GetIntelRuleFileParams) WithTimeout(timeout time.Duration) *GetIntelRuleFileParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get intel rule file params
func (o *GetIntelRuleFileParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get intel rule file params
func (o *GetIntelRuleFileParams) WithContext(ctx context.Context) *GetIntelRuleFileParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get intel rule file params
func (o *GetIntelRuleFileParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get intel rule file params
func (o *GetIntelRuleFileParams) WithHTTPClient(client *http.Client) *GetIntelRuleFileParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get intel rule file params
func (o *GetIntelRuleFileParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccept adds the accept to the get intel rule file params
func (o *GetIntelRuleFileParams) WithAccept(accept *string) *GetIntelRuleFileParams {
	o.SetAccept(accept)
	return o
}

// SetAccept adds the accept to the get intel rule file params
func (o *GetIntelRuleFileParams) SetAccept(accept *string) {
	o.Accept = accept
}

// WithFormat adds the format to the get intel rule file params
func (o *GetIntelRuleFileParams) WithFormat(format *string) *GetIntelRuleFileParams {
	o.SetFormat(format)
	return o
}

// SetFormat adds the format to the get intel rule file params
func (o *GetIntelRuleFileParams) SetFormat(format *string) {
	o.Format = format
}

// WithID adds the id to the get intel rule file params
func (o *GetIntelRuleFileParams) WithID(id int64) *GetIntelRuleFileParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the get intel rule file params
func (o *GetIntelRuleFileParams) SetID(id int64) {
	o.ID = id
}

// WriteToRequest writes these params to a swagger request
func (o *GetIntelRuleFileParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Accept != nil {

		// header param Accept
		if err := r.SetHeaderParam("Accept", *o.Accept); err != nil {
			return err
		}
	}

	if o.Format != nil {

		// query param format
		var qrFormat string

		if o.Format != nil {
			qrFormat = *o.Format
		}
		qFormat := qrFormat
		if qFormat != "" {

			if err := r.SetQueryParam("format", qFormat); err != nil {
				return err
			}
		}
	}

	// query param id
	qrID := o.ID
	qID := swag.FormatInt64(qrID)
	if qID != "" {

		if err := r.SetQueryParam("id", qID); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
