// Code generated by go-swagger; DO NOT EDIT.

package intel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetLatestIntelRuleFileReader is a Reader for the GetLatestIntelRuleFile structure.
type GetLatestIntelRuleFileReader struct {
	formats strfmt.Registry
	writer  io.Writer
}

// ReadResponse reads a server response into the received o.
func (o *GetLatestIntelRuleFileReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetLatestIntelRuleFileOK(o.writer)
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 304:
		result := NewGetLatestIntelRuleFileNotModified()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 400:
		result := NewGetLatestIntelRuleFileBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetLatestIntelRuleFileForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetLatestIntelRuleFileNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetLatestIntelRuleFileTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetLatestIntelRuleFileInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /intel/entities/rules-latest-files/v1] GetLatestIntelRuleFile", response, response.Code())
	}
}

// NewGetLatestIntelRuleFileOK creates a GetLatestIntelRuleFileOK with default headers values
func NewGetLatestIntelRuleFileOK(writer io.Writer) *GetLatestIntelRuleFileOK {
	return &GetLatestIntelRuleFileOK{

		Payload: writer,
	}
}

/*
GetLatestIntelRuleFileOK describes a response with status code 200, with default header values.

OK
*/
type GetLatestIntelRuleFileOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload io.Writer
}

// IsSuccess returns true when this get latest intel rule file o k response has a 2xx status code
func (o *GetLatestIntelRuleFileOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get latest intel rule file o k response has a 3xx status code
func (o *GetLatestIntelRuleFileOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get latest intel rule file o k response has a 4xx status code
func (o *GetLatestIntelRuleFileOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get latest intel rule file o k response has a 5xx status code
func (o *GetLatestIntelRuleFileOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get latest intel rule file o k response a status code equal to that given
func (o *GetLatestIntelRuleFileOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get latest intel rule file o k response
func (o *GetLatestIntelRuleFileOK) Code() int {
	return 200
}

func (o *GetLatestIntelRuleFileOK) Error() string {
	return fmt.Sprintf("[GET /intel/entities/rules-latest-files/v1][%d] getLatestIntelRuleFileOK  %+v", 200, o.Payload)
}

func (o *GetLatestIntelRuleFileOK) String() string {
	return fmt.Sprintf("[GET /intel/entities/rules-latest-files/v1][%d] getLatestIntelRuleFileOK  %+v", 200, o.Payload)
}

func (o *GetLatestIntelRuleFileOK) GetPayload() io.Writer {
	return o.Payload
}

func (o *GetLatestIntelRuleFileOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLatestIntelRuleFileNotModified creates a GetLatestIntelRuleFileNotModified with default headers values
func NewGetLatestIntelRuleFileNotModified() *GetLatestIntelRuleFileNotModified {
	return &GetLatestIntelRuleFileNotModified{}
}

/*
GetLatestIntelRuleFileNotModified describes a response with status code 304, with default header values.

Not Modified
*/
type GetLatestIntelRuleFileNotModified struct {
}

// IsSuccess returns true when this get latest intel rule file not modified response has a 2xx status code
func (o *GetLatestIntelRuleFileNotModified) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get latest intel rule file not modified response has a 3xx status code
func (o *GetLatestIntelRuleFileNotModified) IsRedirect() bool {
	return true
}

// IsClientError returns true when this get latest intel rule file not modified response has a 4xx status code
func (o *GetLatestIntelRuleFileNotModified) IsClientError() bool {
	return false
}

// IsServerError returns true when this get latest intel rule file not modified response has a 5xx status code
func (o *GetLatestIntelRuleFileNotModified) IsServerError() bool {
	return false
}

// IsCode returns true when this get latest intel rule file not modified response a status code equal to that given
func (o *GetLatestIntelRuleFileNotModified) IsCode(code int) bool {
	return code == 304
}

// Code gets the status code for the get latest intel rule file not modified response
func (o *GetLatestIntelRuleFileNotModified) Code() int {
	return 304
}

func (o *GetLatestIntelRuleFileNotModified) Error() string {
	return fmt.Sprintf("[GET /intel/entities/rules-latest-files/v1][%d] getLatestIntelRuleFileNotModified ", 304)
}

func (o *GetLatestIntelRuleFileNotModified) String() string {
	return fmt.Sprintf("[GET /intel/entities/rules-latest-files/v1][%d] getLatestIntelRuleFileNotModified ", 304)
}

func (o *GetLatestIntelRuleFileNotModified) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetLatestIntelRuleFileBadRequest creates a GetLatestIntelRuleFileBadRequest with default headers values
func NewGetLatestIntelRuleFileBadRequest() *GetLatestIntelRuleFileBadRequest {
	return &GetLatestIntelRuleFileBadRequest{}
}

/*
GetLatestIntelRuleFileBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetLatestIntelRuleFileBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get latest intel rule file bad request response has a 2xx status code
func (o *GetLatestIntelRuleFileBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get latest intel rule file bad request response has a 3xx status code
func (o *GetLatestIntelRuleFileBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get latest intel rule file bad request response has a 4xx status code
func (o *GetLatestIntelRuleFileBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get latest intel rule file bad request response has a 5xx status code
func (o *GetLatestIntelRuleFileBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get latest intel rule file bad request response a status code equal to that given
func (o *GetLatestIntelRuleFileBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get latest intel rule file bad request response
func (o *GetLatestIntelRuleFileBadRequest) Code() int {
	return 400
}

func (o *GetLatestIntelRuleFileBadRequest) Error() string {
	return fmt.Sprintf("[GET /intel/entities/rules-latest-files/v1][%d] getLatestIntelRuleFileBadRequest  %+v", 400, o.Payload)
}

func (o *GetLatestIntelRuleFileBadRequest) String() string {
	return fmt.Sprintf("[GET /intel/entities/rules-latest-files/v1][%d] getLatestIntelRuleFileBadRequest  %+v", 400, o.Payload)
}

func (o *GetLatestIntelRuleFileBadRequest) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetLatestIntelRuleFileBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLatestIntelRuleFileForbidden creates a GetLatestIntelRuleFileForbidden with default headers values
func NewGetLatestIntelRuleFileForbidden() *GetLatestIntelRuleFileForbidden {
	return &GetLatestIntelRuleFileForbidden{}
}

/*
GetLatestIntelRuleFileForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetLatestIntelRuleFileForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get latest intel rule file forbidden response has a 2xx status code
func (o *GetLatestIntelRuleFileForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get latest intel rule file forbidden response has a 3xx status code
func (o *GetLatestIntelRuleFileForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get latest intel rule file forbidden response has a 4xx status code
func (o *GetLatestIntelRuleFileForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get latest intel rule file forbidden response has a 5xx status code
func (o *GetLatestIntelRuleFileForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get latest intel rule file forbidden response a status code equal to that given
func (o *GetLatestIntelRuleFileForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get latest intel rule file forbidden response
func (o *GetLatestIntelRuleFileForbidden) Code() int {
	return 403
}

func (o *GetLatestIntelRuleFileForbidden) Error() string {
	return fmt.Sprintf("[GET /intel/entities/rules-latest-files/v1][%d] getLatestIntelRuleFileForbidden  %+v", 403, o.Payload)
}

func (o *GetLatestIntelRuleFileForbidden) String() string {
	return fmt.Sprintf("[GET /intel/entities/rules-latest-files/v1][%d] getLatestIntelRuleFileForbidden  %+v", 403, o.Payload)
}

func (o *GetLatestIntelRuleFileForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetLatestIntelRuleFileForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLatestIntelRuleFileNotFound creates a GetLatestIntelRuleFileNotFound with default headers values
func NewGetLatestIntelRuleFileNotFound() *GetLatestIntelRuleFileNotFound {
	return &GetLatestIntelRuleFileNotFound{}
}

/*
GetLatestIntelRuleFileNotFound describes a response with status code 404, with default header values.

Bad Request
*/
type GetLatestIntelRuleFileNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get latest intel rule file not found response has a 2xx status code
func (o *GetLatestIntelRuleFileNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get latest intel rule file not found response has a 3xx status code
func (o *GetLatestIntelRuleFileNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get latest intel rule file not found response has a 4xx status code
func (o *GetLatestIntelRuleFileNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get latest intel rule file not found response has a 5xx status code
func (o *GetLatestIntelRuleFileNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get latest intel rule file not found response a status code equal to that given
func (o *GetLatestIntelRuleFileNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get latest intel rule file not found response
func (o *GetLatestIntelRuleFileNotFound) Code() int {
	return 404
}

func (o *GetLatestIntelRuleFileNotFound) Error() string {
	return fmt.Sprintf("[GET /intel/entities/rules-latest-files/v1][%d] getLatestIntelRuleFileNotFound  %+v", 404, o.Payload)
}

func (o *GetLatestIntelRuleFileNotFound) String() string {
	return fmt.Sprintf("[GET /intel/entities/rules-latest-files/v1][%d] getLatestIntelRuleFileNotFound  %+v", 404, o.Payload)
}

func (o *GetLatestIntelRuleFileNotFound) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetLatestIntelRuleFileNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLatestIntelRuleFileTooManyRequests creates a GetLatestIntelRuleFileTooManyRequests with default headers values
func NewGetLatestIntelRuleFileTooManyRequests() *GetLatestIntelRuleFileTooManyRequests {
	return &GetLatestIntelRuleFileTooManyRequests{}
}

/*
GetLatestIntelRuleFileTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetLatestIntelRuleFileTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get latest intel rule file too many requests response has a 2xx status code
func (o *GetLatestIntelRuleFileTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get latest intel rule file too many requests response has a 3xx status code
func (o *GetLatestIntelRuleFileTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get latest intel rule file too many requests response has a 4xx status code
func (o *GetLatestIntelRuleFileTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get latest intel rule file too many requests response has a 5xx status code
func (o *GetLatestIntelRuleFileTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get latest intel rule file too many requests response a status code equal to that given
func (o *GetLatestIntelRuleFileTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get latest intel rule file too many requests response
func (o *GetLatestIntelRuleFileTooManyRequests) Code() int {
	return 429
}

func (o *GetLatestIntelRuleFileTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /intel/entities/rules-latest-files/v1][%d] getLatestIntelRuleFileTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetLatestIntelRuleFileTooManyRequests) String() string {
	return fmt.Sprintf("[GET /intel/entities/rules-latest-files/v1][%d] getLatestIntelRuleFileTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetLatestIntelRuleFileTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetLatestIntelRuleFileTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLatestIntelRuleFileInternalServerError creates a GetLatestIntelRuleFileInternalServerError with default headers values
func NewGetLatestIntelRuleFileInternalServerError() *GetLatestIntelRuleFileInternalServerError {
	return &GetLatestIntelRuleFileInternalServerError{}
}

/*
GetLatestIntelRuleFileInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetLatestIntelRuleFileInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get latest intel rule file internal server error response has a 2xx status code
func (o *GetLatestIntelRuleFileInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get latest intel rule file internal server error response has a 3xx status code
func (o *GetLatestIntelRuleFileInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get latest intel rule file internal server error response has a 4xx status code
func (o *GetLatestIntelRuleFileInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get latest intel rule file internal server error response has a 5xx status code
func (o *GetLatestIntelRuleFileInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get latest intel rule file internal server error response a status code equal to that given
func (o *GetLatestIntelRuleFileInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get latest intel rule file internal server error response
func (o *GetLatestIntelRuleFileInternalServerError) Code() int {
	return 500
}

func (o *GetLatestIntelRuleFileInternalServerError) Error() string {
	return fmt.Sprintf("[GET /intel/entities/rules-latest-files/v1][%d] getLatestIntelRuleFileInternalServerError  %+v", 500, o.Payload)
}

func (o *GetLatestIntelRuleFileInternalServerError) String() string {
	return fmt.Sprintf("[GET /intel/entities/rules-latest-files/v1][%d] getLatestIntelRuleFileInternalServerError  %+v", 500, o.Payload)
}

func (o *GetLatestIntelRuleFileInternalServerError) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetLatestIntelRuleFileInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
