// Code generated by go-swagger; DO NOT EDIT.

package intel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetMitreReportReader is a Reader for the GetMitreReport structure.
type GetMitreReportReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetMitreReportReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetMitreReportOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetMitreReportForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetMitreReportTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /intel/entities/mitre-reports/v1] GetMitreReport", response, response.Code())
	}
}

// NewGetMitreReportOK creates a GetMitreReportOK with default headers values
func NewGetMitreReportOK() *GetMitreReportOK {
	return &GetMitreReportOK{}
}

/*
GetMitreReportOK describes a response with status code 200, with default header values.

OK
*/
type GetMitreReportOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64
}

// IsSuccess returns true when this get mitre report o k response has a 2xx status code
func (o *GetMitreReportOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get mitre report o k response has a 3xx status code
func (o *GetMitreReportOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get mitre report o k response has a 4xx status code
func (o *GetMitreReportOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get mitre report o k response has a 5xx status code
func (o *GetMitreReportOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get mitre report o k response a status code equal to that given
func (o *GetMitreReportOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get mitre report o k response
func (o *GetMitreReportOK) Code() int {
	return 200
}

func (o *GetMitreReportOK) Error() string {
	return fmt.Sprintf("[GET /intel/entities/mitre-reports/v1][%d] getMitreReportOK ", 200)
}

func (o *GetMitreReportOK) String() string {
	return fmt.Sprintf("[GET /intel/entities/mitre-reports/v1][%d] getMitreReportOK ", 200)
}

func (o *GetMitreReportOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	return nil
}

// NewGetMitreReportForbidden creates a GetMitreReportForbidden with default headers values
func NewGetMitreReportForbidden() *GetMitreReportForbidden {
	return &GetMitreReportForbidden{}
}

/*
GetMitreReportForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetMitreReportForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get mitre report forbidden response has a 2xx status code
func (o *GetMitreReportForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get mitre report forbidden response has a 3xx status code
func (o *GetMitreReportForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get mitre report forbidden response has a 4xx status code
func (o *GetMitreReportForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get mitre report forbidden response has a 5xx status code
func (o *GetMitreReportForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get mitre report forbidden response a status code equal to that given
func (o *GetMitreReportForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get mitre report forbidden response
func (o *GetMitreReportForbidden) Code() int {
	return 403
}

func (o *GetMitreReportForbidden) Error() string {
	return fmt.Sprintf("[GET /intel/entities/mitre-reports/v1][%d] getMitreReportForbidden  %+v", 403, o.Payload)
}

func (o *GetMitreReportForbidden) String() string {
	return fmt.Sprintf("[GET /intel/entities/mitre-reports/v1][%d] getMitreReportForbidden  %+v", 403, o.Payload)
}

func (o *GetMitreReportForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetMitreReportForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMitreReportTooManyRequests creates a GetMitreReportTooManyRequests with default headers values
func NewGetMitreReportTooManyRequests() *GetMitreReportTooManyRequests {
	return &GetMitreReportTooManyRequests{}
}

/*
GetMitreReportTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetMitreReportTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get mitre report too many requests response has a 2xx status code
func (o *GetMitreReportTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get mitre report too many requests response has a 3xx status code
func (o *GetMitreReportTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get mitre report too many requests response has a 4xx status code
func (o *GetMitreReportTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get mitre report too many requests response has a 5xx status code
func (o *GetMitreReportTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get mitre report too many requests response a status code equal to that given
func (o *GetMitreReportTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get mitre report too many requests response
func (o *GetMitreReportTooManyRequests) Code() int {
	return 429
}

func (o *GetMitreReportTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /intel/entities/mitre-reports/v1][%d] getMitreReportTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetMitreReportTooManyRequests) String() string {
	return fmt.Sprintf("[GET /intel/entities/mitre-reports/v1][%d] getMitreReportTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetMitreReportTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetMitreReportTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
