// Code generated by go-swagger; DO NOT EDIT.

package intel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// PostMitreAttacksReader is a Reader for the PostMitreAttacks structure.
type PostMitreAttacksReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PostMitreAttacksReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPostMitreAttacksOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewPostMitreAttacksForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewPostMitreAttacksTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /intel/entities/mitre/v1] PostMitreAttacks", response, response.Code())
	}
}

// NewPostMitreAttacksOK creates a PostMitreAttacksOK with default headers values
func NewPostMitreAttacksOK() *PostMitreAttacksOK {
	return &PostMitreAttacksOK{}
}

/*
PostMitreAttacksOK describes a response with status code 200, with default header values.

OK
*/
type PostMitreAttacksOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64
}

// IsSuccess returns true when this post mitre attacks o k response has a 2xx status code
func (o *PostMitreAttacksOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this post mitre attacks o k response has a 3xx status code
func (o *PostMitreAttacksOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post mitre attacks o k response has a 4xx status code
func (o *PostMitreAttacksOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this post mitre attacks o k response has a 5xx status code
func (o *PostMitreAttacksOK) IsServerError() bool {
	return false
}

// IsCode returns true when this post mitre attacks o k response a status code equal to that given
func (o *PostMitreAttacksOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the post mitre attacks o k response
func (o *PostMitreAttacksOK) Code() int {
	return 200
}

func (o *PostMitreAttacksOK) Error() string {
	return fmt.Sprintf("[POST /intel/entities/mitre/v1][%d] postMitreAttacksOK ", 200)
}

func (o *PostMitreAttacksOK) String() string {
	return fmt.Sprintf("[POST /intel/entities/mitre/v1][%d] postMitreAttacksOK ", 200)
}

func (o *PostMitreAttacksOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	return nil
}

// NewPostMitreAttacksForbidden creates a PostMitreAttacksForbidden with default headers values
func NewPostMitreAttacksForbidden() *PostMitreAttacksForbidden {
	return &PostMitreAttacksForbidden{}
}

/*
PostMitreAttacksForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type PostMitreAttacksForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this post mitre attacks forbidden response has a 2xx status code
func (o *PostMitreAttacksForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post mitre attacks forbidden response has a 3xx status code
func (o *PostMitreAttacksForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post mitre attacks forbidden response has a 4xx status code
func (o *PostMitreAttacksForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this post mitre attacks forbidden response has a 5xx status code
func (o *PostMitreAttacksForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this post mitre attacks forbidden response a status code equal to that given
func (o *PostMitreAttacksForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the post mitre attacks forbidden response
func (o *PostMitreAttacksForbidden) Code() int {
	return 403
}

func (o *PostMitreAttacksForbidden) Error() string {
	return fmt.Sprintf("[POST /intel/entities/mitre/v1][%d] postMitreAttacksForbidden  %+v", 403, o.Payload)
}

func (o *PostMitreAttacksForbidden) String() string {
	return fmt.Sprintf("[POST /intel/entities/mitre/v1][%d] postMitreAttacksForbidden  %+v", 403, o.Payload)
}

func (o *PostMitreAttacksForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *PostMitreAttacksForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostMitreAttacksTooManyRequests creates a PostMitreAttacksTooManyRequests with default headers values
func NewPostMitreAttacksTooManyRequests() *PostMitreAttacksTooManyRequests {
	return &PostMitreAttacksTooManyRequests{}
}

/*
PostMitreAttacksTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type PostMitreAttacksTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this post mitre attacks too many requests response has a 2xx status code
func (o *PostMitreAttacksTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post mitre attacks too many requests response has a 3xx status code
func (o *PostMitreAttacksTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post mitre attacks too many requests response has a 4xx status code
func (o *PostMitreAttacksTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this post mitre attacks too many requests response has a 5xx status code
func (o *PostMitreAttacksTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this post mitre attacks too many requests response a status code equal to that given
func (o *PostMitreAttacksTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the post mitre attacks too many requests response
func (o *PostMitreAttacksTooManyRequests) Code() int {
	return 429
}

func (o *PostMitreAttacksTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /intel/entities/mitre/v1][%d] postMitreAttacksTooManyRequests  %+v", 429, o.Payload)
}

func (o *PostMitreAttacksTooManyRequests) String() string {
	return fmt.Sprintf("[POST /intel/entities/mitre/v1][%d] postMitreAttacksTooManyRequests  %+v", 429, o.Payload)
}

func (o *PostMitreAttacksTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *PostMitreAttacksTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
