// Code generated by go-swagger; DO NOT EDIT.

package intel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryIntelActorEntitiesParams creates a new QueryIntelActorEntitiesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryIntelActorEntitiesParams() *QueryIntelActorEntitiesParams {
	return &QueryIntelActorEntitiesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryIntelActorEntitiesParamsWithTimeout creates a new QueryIntelActorEntitiesParams object
// with the ability to set a timeout on a request.
func NewQueryIntelActorEntitiesParamsWithTimeout(timeout time.Duration) *QueryIntelActorEntitiesParams {
	return &QueryIntelActorEntitiesParams{
		timeout: timeout,
	}
}

// NewQueryIntelActorEntitiesParamsWithContext creates a new QueryIntelActorEntitiesParams object
// with the ability to set a context for a request.
func NewQueryIntelActorEntitiesParamsWithContext(ctx context.Context) *QueryIntelActorEntitiesParams {
	return &QueryIntelActorEntitiesParams{
		Context: ctx,
	}
}

// NewQueryIntelActorEntitiesParamsWithHTTPClient creates a new QueryIntelActorEntitiesParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryIntelActorEntitiesParamsWithHTTPClient(client *http.Client) *QueryIntelActorEntitiesParams {
	return &QueryIntelActorEntitiesParams{
		HTTPClient: client,
	}
}

/*
QueryIntelActorEntitiesParams contains all the parameters to send to the API endpoint

	for the query intel actor entities operation.

	Typically these are written to a http.Request.
*/
type QueryIntelActorEntitiesParams struct {

	/* Fields.

	     The fields to return, or a predefined set of fields in the form of the collection name surrounded by two underscores like:

	\_\_\<collection\>\_\_.

	Ex: slug \_\_full\_\_.

	Defaults to \_\_basic\_\_.
	*/
	Fields []string

	/* Filter.

	     Filter your query by specifying FQL filter parameters. Filter parameters include:

	actor_type, capabilities, capability, capability.id, capability.slug, capability.value, created_date, description, ecrime_kill_chain.attribution, ecrime_kill_chain.crimes, ecrime_kill_chain.customers, ecrime_kill_chain.marketing, ecrime_kill_chain.monetization, ecrime_kill_chain.services_offered, ecrime_kill_chain.services_used, ecrime_kill_chain.technical_tradecraft, ecrime_kill_chain.victims, first_activity_date, group, group.id, group.slug, group.value, id, kill_chain.actions_and_objectives, kill_chain.actions_on_objectives, kill_chain.command_and_control, kill_chain.delivery, kill_chain.exploitation, kill_chain.installation, kill_chain.objectives, kill_chain.reconnaissance, kill_chain.weaponization, known_as, last_activity_date, last_modified_date, motivations, motivations.id, motivations.slug, motivations.value, name, objectives, origins, origins.id, origins.slug, origins.value, region, region.id, region.slug, region.value, short_description, slug, status, target_countries, target_countries.id, target_countries.slug, target_countries.value, target_industries, target_industries.id, target_industries.slug, target_industries.value, target_regions, target_regions.id, target_regions.slug, target_regions.value.
	*/
	Filter *string

	/* Limit.

	   Set the number of actors to return. The value must be between 1 and 5000.
	*/
	Limit *int64

	/* Offset.

	   Set the starting row number to return actors from. Defaults to 0.
	*/
	Offset *int64

	/* Q.

	   Perform a generic substring search across all fields.
	*/
	Q *string

	/* Sort.

	     Order fields in ascending or descending order.

	Ex: created_date|asc.
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query intel actor entities params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryIntelActorEntitiesParams) WithDefaults() *QueryIntelActorEntitiesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query intel actor entities params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryIntelActorEntitiesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) WithTimeout(timeout time.Duration) *QueryIntelActorEntitiesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) WithContext(ctx context.Context) *QueryIntelActorEntitiesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) WithHTTPClient(client *http.Client) *QueryIntelActorEntitiesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) WithFields(fields []string) *QueryIntelActorEntitiesParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFilter adds the filter to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) WithFilter(filter *string) *QueryIntelActorEntitiesParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) WithLimit(limit *int64) *QueryIntelActorEntitiesParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) WithOffset(offset *int64) *QueryIntelActorEntitiesParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithQ adds the q to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) WithQ(q *string) *QueryIntelActorEntitiesParams {
	o.SetQ(q)
	return o
}

// SetQ adds the q to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) SetQ(q *string) {
	o.Q = q
}

// WithSort adds the sort to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) WithSort(sort *string) *QueryIntelActorEntitiesParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query intel actor entities params
func (o *QueryIntelActorEntitiesParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryIntelActorEntitiesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Q != nil {

		// query param q
		var qrQ string

		if o.Q != nil {
			qrQ = *o.Q
		}
		qQ := qrQ
		if qQ != "" {

			if err := r.SetQueryParam("q", qQ); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamQueryIntelActorEntities binds the parameter fields
func (o *QueryIntelActorEntitiesParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "multi"
	fieldsIS := swag.JoinByFormat(fieldsIC, "multi")

	return fieldsIS
}
