// Code generated by go-swagger; DO NOT EDIT.

package intel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryIntelActorIdsReader is a Reader for the QueryIntelActorIds structure.
type QueryIntelActorIdsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryIntelActorIdsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryIntelActorIdsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryIntelActorIdsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryIntelActorIdsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryIntelActorIdsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryIntelActorIdsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /intel/queries/actors/v1] QueryIntelActorIds", response, response.Code())
	}
}

// NewQueryIntelActorIdsOK creates a QueryIntelActorIdsOK with default headers values
func NewQueryIntelActorIdsOK() *QueryIntelActorIdsOK {
	return &QueryIntelActorIdsOK{}
}

/*
QueryIntelActorIdsOK describes a response with status code 200, with default header values.

OK
*/
type QueryIntelActorIdsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query intel actor ids o k response has a 2xx status code
func (o *QueryIntelActorIdsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query intel actor ids o k response has a 3xx status code
func (o *QueryIntelActorIdsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel actor ids o k response has a 4xx status code
func (o *QueryIntelActorIdsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query intel actor ids o k response has a 5xx status code
func (o *QueryIntelActorIdsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query intel actor ids o k response a status code equal to that given
func (o *QueryIntelActorIdsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query intel actor ids o k response
func (o *QueryIntelActorIdsOK) Code() int {
	return 200
}

func (o *QueryIntelActorIdsOK) Error() string {
	return fmt.Sprintf("[GET /intel/queries/actors/v1][%d] queryIntelActorIdsOK  %+v", 200, o.Payload)
}

func (o *QueryIntelActorIdsOK) String() string {
	return fmt.Sprintf("[GET /intel/queries/actors/v1][%d] queryIntelActorIdsOK  %+v", 200, o.Payload)
}

func (o *QueryIntelActorIdsOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryIntelActorIdsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIntelActorIdsBadRequest creates a QueryIntelActorIdsBadRequest with default headers values
func NewQueryIntelActorIdsBadRequest() *QueryIntelActorIdsBadRequest {
	return &QueryIntelActorIdsBadRequest{}
}

/*
QueryIntelActorIdsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryIntelActorIdsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query intel actor ids bad request response has a 2xx status code
func (o *QueryIntelActorIdsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query intel actor ids bad request response has a 3xx status code
func (o *QueryIntelActorIdsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel actor ids bad request response has a 4xx status code
func (o *QueryIntelActorIdsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query intel actor ids bad request response has a 5xx status code
func (o *QueryIntelActorIdsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query intel actor ids bad request response a status code equal to that given
func (o *QueryIntelActorIdsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query intel actor ids bad request response
func (o *QueryIntelActorIdsBadRequest) Code() int {
	return 400
}

func (o *QueryIntelActorIdsBadRequest) Error() string {
	return fmt.Sprintf("[GET /intel/queries/actors/v1][%d] queryIntelActorIdsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryIntelActorIdsBadRequest) String() string {
	return fmt.Sprintf("[GET /intel/queries/actors/v1][%d] queryIntelActorIdsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryIntelActorIdsBadRequest) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryIntelActorIdsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIntelActorIdsForbidden creates a QueryIntelActorIdsForbidden with default headers values
func NewQueryIntelActorIdsForbidden() *QueryIntelActorIdsForbidden {
	return &QueryIntelActorIdsForbidden{}
}

/*
QueryIntelActorIdsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryIntelActorIdsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query intel actor ids forbidden response has a 2xx status code
func (o *QueryIntelActorIdsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query intel actor ids forbidden response has a 3xx status code
func (o *QueryIntelActorIdsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel actor ids forbidden response has a 4xx status code
func (o *QueryIntelActorIdsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query intel actor ids forbidden response has a 5xx status code
func (o *QueryIntelActorIdsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query intel actor ids forbidden response a status code equal to that given
func (o *QueryIntelActorIdsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query intel actor ids forbidden response
func (o *QueryIntelActorIdsForbidden) Code() int {
	return 403
}

func (o *QueryIntelActorIdsForbidden) Error() string {
	return fmt.Sprintf("[GET /intel/queries/actors/v1][%d] queryIntelActorIdsForbidden  %+v", 403, o.Payload)
}

func (o *QueryIntelActorIdsForbidden) String() string {
	return fmt.Sprintf("[GET /intel/queries/actors/v1][%d] queryIntelActorIdsForbidden  %+v", 403, o.Payload)
}

func (o *QueryIntelActorIdsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryIntelActorIdsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIntelActorIdsTooManyRequests creates a QueryIntelActorIdsTooManyRequests with default headers values
func NewQueryIntelActorIdsTooManyRequests() *QueryIntelActorIdsTooManyRequests {
	return &QueryIntelActorIdsTooManyRequests{}
}

/*
QueryIntelActorIdsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryIntelActorIdsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query intel actor ids too many requests response has a 2xx status code
func (o *QueryIntelActorIdsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query intel actor ids too many requests response has a 3xx status code
func (o *QueryIntelActorIdsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel actor ids too many requests response has a 4xx status code
func (o *QueryIntelActorIdsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query intel actor ids too many requests response has a 5xx status code
func (o *QueryIntelActorIdsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query intel actor ids too many requests response a status code equal to that given
func (o *QueryIntelActorIdsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query intel actor ids too many requests response
func (o *QueryIntelActorIdsTooManyRequests) Code() int {
	return 429
}

func (o *QueryIntelActorIdsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /intel/queries/actors/v1][%d] queryIntelActorIdsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryIntelActorIdsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /intel/queries/actors/v1][%d] queryIntelActorIdsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryIntelActorIdsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryIntelActorIdsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIntelActorIdsInternalServerError creates a QueryIntelActorIdsInternalServerError with default headers values
func NewQueryIntelActorIdsInternalServerError() *QueryIntelActorIdsInternalServerError {
	return &QueryIntelActorIdsInternalServerError{}
}

/*
QueryIntelActorIdsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryIntelActorIdsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query intel actor ids internal server error response has a 2xx status code
func (o *QueryIntelActorIdsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query intel actor ids internal server error response has a 3xx status code
func (o *QueryIntelActorIdsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel actor ids internal server error response has a 4xx status code
func (o *QueryIntelActorIdsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query intel actor ids internal server error response has a 5xx status code
func (o *QueryIntelActorIdsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query intel actor ids internal server error response a status code equal to that given
func (o *QueryIntelActorIdsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query intel actor ids internal server error response
func (o *QueryIntelActorIdsInternalServerError) Code() int {
	return 500
}

func (o *QueryIntelActorIdsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /intel/queries/actors/v1][%d] queryIntelActorIdsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryIntelActorIdsInternalServerError) String() string {
	return fmt.Sprintf("[GET /intel/queries/actors/v1][%d] queryIntelActorIdsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryIntelActorIdsInternalServerError) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryIntelActorIdsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
