// Code generated by go-swagger; DO NOT EDIT.

package intel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryIntelIndicatorIdsReader is a Reader for the QueryIntelIndicatorIds structure.
type QueryIntelIndicatorIdsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryIntelIndicatorIdsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryIntelIndicatorIdsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryIntelIndicatorIdsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryIntelIndicatorIdsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryIntelIndicatorIdsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryIntelIndicatorIdsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /intel/queries/indicators/v1] QueryIntelIndicatorIds", response, response.Code())
	}
}

// NewQueryIntelIndicatorIdsOK creates a QueryIntelIndicatorIdsOK with default headers values
func NewQueryIntelIndicatorIdsOK() *QueryIntelIndicatorIdsOK {
	return &QueryIntelIndicatorIdsOK{}
}

/*
QueryIntelIndicatorIdsOK describes a response with status code 200, with default header values.

OK
*/
type QueryIntelIndicatorIdsOK struct {

	/* Provides next page pagination URL. Available only if sorting was done using using _marker field, which is the default one.
	 */
	NextPage string

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query intel indicator ids o k response has a 2xx status code
func (o *QueryIntelIndicatorIdsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query intel indicator ids o k response has a 3xx status code
func (o *QueryIntelIndicatorIdsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel indicator ids o k response has a 4xx status code
func (o *QueryIntelIndicatorIdsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query intel indicator ids o k response has a 5xx status code
func (o *QueryIntelIndicatorIdsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query intel indicator ids o k response a status code equal to that given
func (o *QueryIntelIndicatorIdsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query intel indicator ids o k response
func (o *QueryIntelIndicatorIdsOK) Code() int {
	return 200
}

func (o *QueryIntelIndicatorIdsOK) Error() string {
	return fmt.Sprintf("[GET /intel/queries/indicators/v1][%d] queryIntelIndicatorIdsOK  %+v", 200, o.Payload)
}

func (o *QueryIntelIndicatorIdsOK) String() string {
	return fmt.Sprintf("[GET /intel/queries/indicators/v1][%d] queryIntelIndicatorIdsOK  %+v", 200, o.Payload)
}

func (o *QueryIntelIndicatorIdsOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryIntelIndicatorIdsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Next-Page
	hdrNextPage := response.GetHeader("Next-Page")

	if hdrNextPage != "" {
		o.NextPage = hdrNextPage
	}

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIntelIndicatorIdsBadRequest creates a QueryIntelIndicatorIdsBadRequest with default headers values
func NewQueryIntelIndicatorIdsBadRequest() *QueryIntelIndicatorIdsBadRequest {
	return &QueryIntelIndicatorIdsBadRequest{}
}

/*
QueryIntelIndicatorIdsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryIntelIndicatorIdsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query intel indicator ids bad request response has a 2xx status code
func (o *QueryIntelIndicatorIdsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query intel indicator ids bad request response has a 3xx status code
func (o *QueryIntelIndicatorIdsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel indicator ids bad request response has a 4xx status code
func (o *QueryIntelIndicatorIdsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query intel indicator ids bad request response has a 5xx status code
func (o *QueryIntelIndicatorIdsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query intel indicator ids bad request response a status code equal to that given
func (o *QueryIntelIndicatorIdsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query intel indicator ids bad request response
func (o *QueryIntelIndicatorIdsBadRequest) Code() int {
	return 400
}

func (o *QueryIntelIndicatorIdsBadRequest) Error() string {
	return fmt.Sprintf("[GET /intel/queries/indicators/v1][%d] queryIntelIndicatorIdsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryIntelIndicatorIdsBadRequest) String() string {
	return fmt.Sprintf("[GET /intel/queries/indicators/v1][%d] queryIntelIndicatorIdsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryIntelIndicatorIdsBadRequest) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryIntelIndicatorIdsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIntelIndicatorIdsForbidden creates a QueryIntelIndicatorIdsForbidden with default headers values
func NewQueryIntelIndicatorIdsForbidden() *QueryIntelIndicatorIdsForbidden {
	return &QueryIntelIndicatorIdsForbidden{}
}

/*
QueryIntelIndicatorIdsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryIntelIndicatorIdsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query intel indicator ids forbidden response has a 2xx status code
func (o *QueryIntelIndicatorIdsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query intel indicator ids forbidden response has a 3xx status code
func (o *QueryIntelIndicatorIdsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel indicator ids forbidden response has a 4xx status code
func (o *QueryIntelIndicatorIdsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query intel indicator ids forbidden response has a 5xx status code
func (o *QueryIntelIndicatorIdsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query intel indicator ids forbidden response a status code equal to that given
func (o *QueryIntelIndicatorIdsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query intel indicator ids forbidden response
func (o *QueryIntelIndicatorIdsForbidden) Code() int {
	return 403
}

func (o *QueryIntelIndicatorIdsForbidden) Error() string {
	return fmt.Sprintf("[GET /intel/queries/indicators/v1][%d] queryIntelIndicatorIdsForbidden  %+v", 403, o.Payload)
}

func (o *QueryIntelIndicatorIdsForbidden) String() string {
	return fmt.Sprintf("[GET /intel/queries/indicators/v1][%d] queryIntelIndicatorIdsForbidden  %+v", 403, o.Payload)
}

func (o *QueryIntelIndicatorIdsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryIntelIndicatorIdsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIntelIndicatorIdsTooManyRequests creates a QueryIntelIndicatorIdsTooManyRequests with default headers values
func NewQueryIntelIndicatorIdsTooManyRequests() *QueryIntelIndicatorIdsTooManyRequests {
	return &QueryIntelIndicatorIdsTooManyRequests{}
}

/*
QueryIntelIndicatorIdsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryIntelIndicatorIdsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query intel indicator ids too many requests response has a 2xx status code
func (o *QueryIntelIndicatorIdsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query intel indicator ids too many requests response has a 3xx status code
func (o *QueryIntelIndicatorIdsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel indicator ids too many requests response has a 4xx status code
func (o *QueryIntelIndicatorIdsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query intel indicator ids too many requests response has a 5xx status code
func (o *QueryIntelIndicatorIdsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query intel indicator ids too many requests response a status code equal to that given
func (o *QueryIntelIndicatorIdsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query intel indicator ids too many requests response
func (o *QueryIntelIndicatorIdsTooManyRequests) Code() int {
	return 429
}

func (o *QueryIntelIndicatorIdsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /intel/queries/indicators/v1][%d] queryIntelIndicatorIdsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryIntelIndicatorIdsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /intel/queries/indicators/v1][%d] queryIntelIndicatorIdsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryIntelIndicatorIdsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryIntelIndicatorIdsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIntelIndicatorIdsInternalServerError creates a QueryIntelIndicatorIdsInternalServerError with default headers values
func NewQueryIntelIndicatorIdsInternalServerError() *QueryIntelIndicatorIdsInternalServerError {
	return &QueryIntelIndicatorIdsInternalServerError{}
}

/*
QueryIntelIndicatorIdsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryIntelIndicatorIdsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query intel indicator ids internal server error response has a 2xx status code
func (o *QueryIntelIndicatorIdsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query intel indicator ids internal server error response has a 3xx status code
func (o *QueryIntelIndicatorIdsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel indicator ids internal server error response has a 4xx status code
func (o *QueryIntelIndicatorIdsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query intel indicator ids internal server error response has a 5xx status code
func (o *QueryIntelIndicatorIdsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query intel indicator ids internal server error response a status code equal to that given
func (o *QueryIntelIndicatorIdsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query intel indicator ids internal server error response
func (o *QueryIntelIndicatorIdsInternalServerError) Code() int {
	return 500
}

func (o *QueryIntelIndicatorIdsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /intel/queries/indicators/v1][%d] queryIntelIndicatorIdsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryIntelIndicatorIdsInternalServerError) String() string {
	return fmt.Sprintf("[GET /intel/queries/indicators/v1][%d] queryIntelIndicatorIdsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryIntelIndicatorIdsInternalServerError) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryIntelIndicatorIdsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
