// Code generated by go-swagger; DO NOT EDIT.

package intel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryIntelReportIdsParams creates a new QueryIntelReportIdsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryIntelReportIdsParams() *QueryIntelReportIdsParams {
	return &QueryIntelReportIdsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryIntelReportIdsParamsWithTimeout creates a new QueryIntelReportIdsParams object
// with the ability to set a timeout on a request.
func NewQueryIntelReportIdsParamsWithTimeout(timeout time.Duration) *QueryIntelReportIdsParams {
	return &QueryIntelReportIdsParams{
		timeout: timeout,
	}
}

// NewQueryIntelReportIdsParamsWithContext creates a new QueryIntelReportIdsParams object
// with the ability to set a context for a request.
func NewQueryIntelReportIdsParamsWithContext(ctx context.Context) *QueryIntelReportIdsParams {
	return &QueryIntelReportIdsParams{
		Context: ctx,
	}
}

// NewQueryIntelReportIdsParamsWithHTTPClient creates a new QueryIntelReportIdsParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryIntelReportIdsParamsWithHTTPClient(client *http.Client) *QueryIntelReportIdsParams {
	return &QueryIntelReportIdsParams{
		HTTPClient: client,
	}
}

/*
QueryIntelReportIdsParams contains all the parameters to send to the API endpoint

	for the query intel report ids operation.

	Typically these are written to a http.Request.
*/
type QueryIntelReportIdsParams struct {

	/* Filter.

	     Filter your query by specifying FQL filter parameters. Filter parameters include:

	actors, actors.id, actors.name, actors.slug, actors.url, created_date, description, id, last_modified_date, motivations, motivations.id, motivations.slug, motivations.value, name, name.raw, short_description, slug, sub_type, sub_type.id, sub_type.name, sub_type.slug, tags, tags.id, tags.slug, tags.value, target_countries, target_countries.id, target_countries.slug, target_countries.value, target_industries, target_industries.id, target_industries.slug, target_industries.value, type, type.id, type.name, type.slug, url.
	*/
	Filter *string

	/* Limit.

	   Set the number of report IDs to return. The value must be between 1 and 5000.
	*/
	Limit *int64

	/* Offset.

	   Set the starting row number to return report IDs from. Defaults to 0.
	*/
	Offset *int64

	/* Q.

	   Perform a generic substring search across all fields.
	*/
	Q *string

	/* Sort.

	     Order fields in ascending or descending order.

	Ex: created_date|asc.
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query intel report ids params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryIntelReportIdsParams) WithDefaults() *QueryIntelReportIdsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query intel report ids params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryIntelReportIdsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query intel report ids params
func (o *QueryIntelReportIdsParams) WithTimeout(timeout time.Duration) *QueryIntelReportIdsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query intel report ids params
func (o *QueryIntelReportIdsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query intel report ids params
func (o *QueryIntelReportIdsParams) WithContext(ctx context.Context) *QueryIntelReportIdsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query intel report ids params
func (o *QueryIntelReportIdsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query intel report ids params
func (o *QueryIntelReportIdsParams) WithHTTPClient(client *http.Client) *QueryIntelReportIdsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query intel report ids params
func (o *QueryIntelReportIdsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query intel report ids params
func (o *QueryIntelReportIdsParams) WithFilter(filter *string) *QueryIntelReportIdsParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query intel report ids params
func (o *QueryIntelReportIdsParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query intel report ids params
func (o *QueryIntelReportIdsParams) WithLimit(limit *int64) *QueryIntelReportIdsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query intel report ids params
func (o *QueryIntelReportIdsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query intel report ids params
func (o *QueryIntelReportIdsParams) WithOffset(offset *int64) *QueryIntelReportIdsParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query intel report ids params
func (o *QueryIntelReportIdsParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithQ adds the q to the query intel report ids params
func (o *QueryIntelReportIdsParams) WithQ(q *string) *QueryIntelReportIdsParams {
	o.SetQ(q)
	return o
}

// SetQ adds the q to the query intel report ids params
func (o *QueryIntelReportIdsParams) SetQ(q *string) {
	o.Q = q
}

// WithSort adds the sort to the query intel report ids params
func (o *QueryIntelReportIdsParams) WithSort(sort *string) *QueryIntelReportIdsParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query intel report ids params
func (o *QueryIntelReportIdsParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryIntelReportIdsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Q != nil {

		// query param q
		var qrQ string

		if o.Q != nil {
			qrQ = *o.Q
		}
		qQ := qrQ
		if qQ != "" {

			if err := r.SetQueryParam("q", qQ); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
