// Code generated by go-swagger; DO NOT EDIT.

package intel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryIntelReportIdsReader is a Reader for the QueryIntelReportIds structure.
type QueryIntelReportIdsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryIntelReportIdsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryIntelReportIdsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryIntelReportIdsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryIntelReportIdsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryIntelReportIdsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryIntelReportIdsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /intel/queries/reports/v1] QueryIntelReportIds", response, response.Code())
	}
}

// NewQueryIntelReportIdsOK creates a QueryIntelReportIdsOK with default headers values
func NewQueryIntelReportIdsOK() *QueryIntelReportIdsOK {
	return &QueryIntelReportIdsOK{}
}

/*
QueryIntelReportIdsOK describes a response with status code 200, with default header values.

OK
*/
type QueryIntelReportIdsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query intel report ids o k response has a 2xx status code
func (o *QueryIntelReportIdsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query intel report ids o k response has a 3xx status code
func (o *QueryIntelReportIdsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel report ids o k response has a 4xx status code
func (o *QueryIntelReportIdsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query intel report ids o k response has a 5xx status code
func (o *QueryIntelReportIdsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query intel report ids o k response a status code equal to that given
func (o *QueryIntelReportIdsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query intel report ids o k response
func (o *QueryIntelReportIdsOK) Code() int {
	return 200
}

func (o *QueryIntelReportIdsOK) Error() string {
	return fmt.Sprintf("[GET /intel/queries/reports/v1][%d] queryIntelReportIdsOK  %+v", 200, o.Payload)
}

func (o *QueryIntelReportIdsOK) String() string {
	return fmt.Sprintf("[GET /intel/queries/reports/v1][%d] queryIntelReportIdsOK  %+v", 200, o.Payload)
}

func (o *QueryIntelReportIdsOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryIntelReportIdsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIntelReportIdsBadRequest creates a QueryIntelReportIdsBadRequest with default headers values
func NewQueryIntelReportIdsBadRequest() *QueryIntelReportIdsBadRequest {
	return &QueryIntelReportIdsBadRequest{}
}

/*
QueryIntelReportIdsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryIntelReportIdsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query intel report ids bad request response has a 2xx status code
func (o *QueryIntelReportIdsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query intel report ids bad request response has a 3xx status code
func (o *QueryIntelReportIdsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel report ids bad request response has a 4xx status code
func (o *QueryIntelReportIdsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query intel report ids bad request response has a 5xx status code
func (o *QueryIntelReportIdsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query intel report ids bad request response a status code equal to that given
func (o *QueryIntelReportIdsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query intel report ids bad request response
func (o *QueryIntelReportIdsBadRequest) Code() int {
	return 400
}

func (o *QueryIntelReportIdsBadRequest) Error() string {
	return fmt.Sprintf("[GET /intel/queries/reports/v1][%d] queryIntelReportIdsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryIntelReportIdsBadRequest) String() string {
	return fmt.Sprintf("[GET /intel/queries/reports/v1][%d] queryIntelReportIdsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryIntelReportIdsBadRequest) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryIntelReportIdsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIntelReportIdsForbidden creates a QueryIntelReportIdsForbidden with default headers values
func NewQueryIntelReportIdsForbidden() *QueryIntelReportIdsForbidden {
	return &QueryIntelReportIdsForbidden{}
}

/*
QueryIntelReportIdsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryIntelReportIdsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query intel report ids forbidden response has a 2xx status code
func (o *QueryIntelReportIdsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query intel report ids forbidden response has a 3xx status code
func (o *QueryIntelReportIdsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel report ids forbidden response has a 4xx status code
func (o *QueryIntelReportIdsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query intel report ids forbidden response has a 5xx status code
func (o *QueryIntelReportIdsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query intel report ids forbidden response a status code equal to that given
func (o *QueryIntelReportIdsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query intel report ids forbidden response
func (o *QueryIntelReportIdsForbidden) Code() int {
	return 403
}

func (o *QueryIntelReportIdsForbidden) Error() string {
	return fmt.Sprintf("[GET /intel/queries/reports/v1][%d] queryIntelReportIdsForbidden  %+v", 403, o.Payload)
}

func (o *QueryIntelReportIdsForbidden) String() string {
	return fmt.Sprintf("[GET /intel/queries/reports/v1][%d] queryIntelReportIdsForbidden  %+v", 403, o.Payload)
}

func (o *QueryIntelReportIdsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryIntelReportIdsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIntelReportIdsTooManyRequests creates a QueryIntelReportIdsTooManyRequests with default headers values
func NewQueryIntelReportIdsTooManyRequests() *QueryIntelReportIdsTooManyRequests {
	return &QueryIntelReportIdsTooManyRequests{}
}

/*
QueryIntelReportIdsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryIntelReportIdsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query intel report ids too many requests response has a 2xx status code
func (o *QueryIntelReportIdsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query intel report ids too many requests response has a 3xx status code
func (o *QueryIntelReportIdsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel report ids too many requests response has a 4xx status code
func (o *QueryIntelReportIdsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query intel report ids too many requests response has a 5xx status code
func (o *QueryIntelReportIdsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query intel report ids too many requests response a status code equal to that given
func (o *QueryIntelReportIdsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query intel report ids too many requests response
func (o *QueryIntelReportIdsTooManyRequests) Code() int {
	return 429
}

func (o *QueryIntelReportIdsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /intel/queries/reports/v1][%d] queryIntelReportIdsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryIntelReportIdsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /intel/queries/reports/v1][%d] queryIntelReportIdsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryIntelReportIdsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryIntelReportIdsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIntelReportIdsInternalServerError creates a QueryIntelReportIdsInternalServerError with default headers values
func NewQueryIntelReportIdsInternalServerError() *QueryIntelReportIdsInternalServerError {
	return &QueryIntelReportIdsInternalServerError{}
}

/*
QueryIntelReportIdsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryIntelReportIdsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query intel report ids internal server error response has a 2xx status code
func (o *QueryIntelReportIdsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query intel report ids internal server error response has a 3xx status code
func (o *QueryIntelReportIdsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel report ids internal server error response has a 4xx status code
func (o *QueryIntelReportIdsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query intel report ids internal server error response has a 5xx status code
func (o *QueryIntelReportIdsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query intel report ids internal server error response a status code equal to that given
func (o *QueryIntelReportIdsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query intel report ids internal server error response
func (o *QueryIntelReportIdsInternalServerError) Code() int {
	return 500
}

func (o *QueryIntelReportIdsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /intel/queries/reports/v1][%d] queryIntelReportIdsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryIntelReportIdsInternalServerError) String() string {
	return fmt.Sprintf("[GET /intel/queries/reports/v1][%d] queryIntelReportIdsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryIntelReportIdsInternalServerError) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryIntelReportIdsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
