// Code generated by go-swagger; DO NOT EDIT.

package intel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryIntelRuleIdsReader is a Reader for the QueryIntelRuleIds structure.
type QueryIntelRuleIdsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryIntelRuleIdsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryIntelRuleIdsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryIntelRuleIdsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryIntelRuleIdsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryIntelRuleIdsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryIntelRuleIdsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /intel/queries/rules/v1] QueryIntelRuleIds", response, response.Code())
	}
}

// NewQueryIntelRuleIdsOK creates a QueryIntelRuleIdsOK with default headers values
func NewQueryIntelRuleIdsOK() *QueryIntelRuleIdsOK {
	return &QueryIntelRuleIdsOK{}
}

/*
QueryIntelRuleIdsOK describes a response with status code 200, with default header values.

OK
*/
type QueryIntelRuleIdsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query intel rule ids o k response has a 2xx status code
func (o *QueryIntelRuleIdsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query intel rule ids o k response has a 3xx status code
func (o *QueryIntelRuleIdsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel rule ids o k response has a 4xx status code
func (o *QueryIntelRuleIdsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query intel rule ids o k response has a 5xx status code
func (o *QueryIntelRuleIdsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query intel rule ids o k response a status code equal to that given
func (o *QueryIntelRuleIdsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query intel rule ids o k response
func (o *QueryIntelRuleIdsOK) Code() int {
	return 200
}

func (o *QueryIntelRuleIdsOK) Error() string {
	return fmt.Sprintf("[GET /intel/queries/rules/v1][%d] queryIntelRuleIdsOK  %+v", 200, o.Payload)
}

func (o *QueryIntelRuleIdsOK) String() string {
	return fmt.Sprintf("[GET /intel/queries/rules/v1][%d] queryIntelRuleIdsOK  %+v", 200, o.Payload)
}

func (o *QueryIntelRuleIdsOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryIntelRuleIdsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIntelRuleIdsBadRequest creates a QueryIntelRuleIdsBadRequest with default headers values
func NewQueryIntelRuleIdsBadRequest() *QueryIntelRuleIdsBadRequest {
	return &QueryIntelRuleIdsBadRequest{}
}

/*
QueryIntelRuleIdsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryIntelRuleIdsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query intel rule ids bad request response has a 2xx status code
func (o *QueryIntelRuleIdsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query intel rule ids bad request response has a 3xx status code
func (o *QueryIntelRuleIdsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel rule ids bad request response has a 4xx status code
func (o *QueryIntelRuleIdsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query intel rule ids bad request response has a 5xx status code
func (o *QueryIntelRuleIdsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query intel rule ids bad request response a status code equal to that given
func (o *QueryIntelRuleIdsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query intel rule ids bad request response
func (o *QueryIntelRuleIdsBadRequest) Code() int {
	return 400
}

func (o *QueryIntelRuleIdsBadRequest) Error() string {
	return fmt.Sprintf("[GET /intel/queries/rules/v1][%d] queryIntelRuleIdsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryIntelRuleIdsBadRequest) String() string {
	return fmt.Sprintf("[GET /intel/queries/rules/v1][%d] queryIntelRuleIdsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryIntelRuleIdsBadRequest) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryIntelRuleIdsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIntelRuleIdsForbidden creates a QueryIntelRuleIdsForbidden with default headers values
func NewQueryIntelRuleIdsForbidden() *QueryIntelRuleIdsForbidden {
	return &QueryIntelRuleIdsForbidden{}
}

/*
QueryIntelRuleIdsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryIntelRuleIdsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query intel rule ids forbidden response has a 2xx status code
func (o *QueryIntelRuleIdsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query intel rule ids forbidden response has a 3xx status code
func (o *QueryIntelRuleIdsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel rule ids forbidden response has a 4xx status code
func (o *QueryIntelRuleIdsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query intel rule ids forbidden response has a 5xx status code
func (o *QueryIntelRuleIdsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query intel rule ids forbidden response a status code equal to that given
func (o *QueryIntelRuleIdsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query intel rule ids forbidden response
func (o *QueryIntelRuleIdsForbidden) Code() int {
	return 403
}

func (o *QueryIntelRuleIdsForbidden) Error() string {
	return fmt.Sprintf("[GET /intel/queries/rules/v1][%d] queryIntelRuleIdsForbidden  %+v", 403, o.Payload)
}

func (o *QueryIntelRuleIdsForbidden) String() string {
	return fmt.Sprintf("[GET /intel/queries/rules/v1][%d] queryIntelRuleIdsForbidden  %+v", 403, o.Payload)
}

func (o *QueryIntelRuleIdsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryIntelRuleIdsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIntelRuleIdsTooManyRequests creates a QueryIntelRuleIdsTooManyRequests with default headers values
func NewQueryIntelRuleIdsTooManyRequests() *QueryIntelRuleIdsTooManyRequests {
	return &QueryIntelRuleIdsTooManyRequests{}
}

/*
QueryIntelRuleIdsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryIntelRuleIdsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query intel rule ids too many requests response has a 2xx status code
func (o *QueryIntelRuleIdsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query intel rule ids too many requests response has a 3xx status code
func (o *QueryIntelRuleIdsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel rule ids too many requests response has a 4xx status code
func (o *QueryIntelRuleIdsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query intel rule ids too many requests response has a 5xx status code
func (o *QueryIntelRuleIdsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query intel rule ids too many requests response a status code equal to that given
func (o *QueryIntelRuleIdsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query intel rule ids too many requests response
func (o *QueryIntelRuleIdsTooManyRequests) Code() int {
	return 429
}

func (o *QueryIntelRuleIdsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /intel/queries/rules/v1][%d] queryIntelRuleIdsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryIntelRuleIdsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /intel/queries/rules/v1][%d] queryIntelRuleIdsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryIntelRuleIdsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryIntelRuleIdsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIntelRuleIdsInternalServerError creates a QueryIntelRuleIdsInternalServerError with default headers values
func NewQueryIntelRuleIdsInternalServerError() *QueryIntelRuleIdsInternalServerError {
	return &QueryIntelRuleIdsInternalServerError{}
}

/*
QueryIntelRuleIdsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryIntelRuleIdsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query intel rule ids internal server error response has a 2xx status code
func (o *QueryIntelRuleIdsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query intel rule ids internal server error response has a 3xx status code
func (o *QueryIntelRuleIdsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query intel rule ids internal server error response has a 4xx status code
func (o *QueryIntelRuleIdsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query intel rule ids internal server error response has a 5xx status code
func (o *QueryIntelRuleIdsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query intel rule ids internal server error response a status code equal to that given
func (o *QueryIntelRuleIdsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query intel rule ids internal server error response
func (o *QueryIntelRuleIdsInternalServerError) Code() int {
	return 500
}

func (o *QueryIntelRuleIdsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /intel/queries/rules/v1][%d] queryIntelRuleIdsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryIntelRuleIdsInternalServerError) String() string {
	return fmt.Sprintf("[GET /intel/queries/rules/v1][%d] queryIntelRuleIdsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryIntelRuleIdsInternalServerError) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryIntelRuleIdsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
